/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.autoconfig.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.TextListEntry;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.class_2561;

public class DefaultGuiTransformers {
    private static final ConfigEntryBuilder ENTRY_BUILDER = ConfigEntryBuilder.create();

    private DefaultGuiTransformers() {
    }

    public static GuiRegistry apply(GuiRegistry registry) {
        registry.registerAnnotationTransformer((guis, i18n, field, config, defaults, guiProvider) -> guis.stream().peek(gui -> {
            if (!(gui instanceof TextListEntry)) {
                ConfigEntry.Gui.Tooltip tooltip = field.getAnnotation(ConfigEntry.Gui.Tooltip.class);
                if (tooltip.count() == 0) {
                    DefaultGuiTransformers.tryRemoveTooltip(gui);
                } else if (tooltip.count() == 1) {
                    DefaultGuiTransformers.tryApplyTooltip(gui, new class_2561[]{class_2561.method_43471((String)String.format("%s.%s", i18n, "@Tooltip"))});
                } else {
                    DefaultGuiTransformers.tryApplyTooltip(gui, (class_2561[])IntStream.range(0, tooltip.count()).boxed().map(i -> String.format("%s.%s[%d]", i18n, "@Tooltip", i)).map(class_2561::method_43471).toArray(class_2561[]::new));
                }
            }
        }).collect(Collectors.toList()), ConfigEntry.Gui.Tooltip.class);
        registry.registerAnnotationTransformer((guis, i18n, field, config, defaults, guiProvider) -> guis.stream().peek(gui -> {
            if (!(gui instanceof TextListEntry)) {
                Comment tooltip = field.getAnnotation(Comment.class);
                class_2561[] text = new class_2561[]{class_2561.method_43470((String)tooltip.value())};
                DefaultGuiTransformers.tryApplyTooltip(gui, text);
            }
        }).collect(Collectors.toList()), field -> !field.isAnnotationPresent(ConfigEntry.Gui.Tooltip.class), Comment.class);
        registry.registerAnnotationTransformer((guis, i18n, field, config, defaults, guiProvider) -> guis.stream().peek(gui -> {
            if (!(gui instanceof TextListEntry)) {
                DefaultGuiTransformers.tryRemoveTooltip(gui);
            }
        }).collect(Collectors.toList()), ConfigEntry.Gui.NoTooltip.class);
        registry.registerAnnotationTransformer((guis, i18n, field, config, defaults, guiProvider) -> {
            ArrayList<TextListEntry> ret = new ArrayList<TextListEntry>(guis);
            String text = String.format("%s.%s", i18n, "@PrefixText");
            TextListEntry element = ENTRY_BUILDER.startTextDescription((class_2561)class_2561.method_43471((String)text)).build();
            String s = class_2561.method_43471((String)i18n).getString().toLowerCase(Locale.ROOT);
            if (!s.isEmpty()) {
                element.appendSearchTags(Lists.newArrayList((Object[])s.split(" ")));
            }
            ret.add(0, element);
            return Collections.unmodifiableList(ret);
        }, ConfigEntry.Gui.PrefixText.class);
        registry.registerAnnotationTransformer((guis, i18n, field, config, defaults, guiProvider) -> {
            for (AbstractConfigListEntry gui : guis) {
                gui.setRequiresRestart(field.getAnnotation(ConfigEntry.Gui.RequiresRestart.class).value());
            }
            return guis;
        }, ConfigEntry.Gui.RequiresRestart.class);
        return registry;
    }

    private static void tryApplyTooltip(AbstractConfigListEntry gui, class_2561[] text) {
        if (gui instanceof TooltipListEntry) {
            TooltipListEntry tooltipGui = (TooltipListEntry)gui;
            tooltipGui.setTooltipSupplier(() -> Optional.of(text));
        }
    }

    private static void tryRemoveTooltip(AbstractConfigListEntry gui) {
        if (gui instanceof TooltipListEntry) {
            TooltipListEntry tooltipGui = (TooltipListEntry)gui;
            tooltipGui.setTooltipSupplier(() -> Optional.empty());
        }
    }
}

