/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.autoconfig;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigManager;
import me.shedaniel.autoconfig.gui.ConfigScreenProvider;
import me.shedaniel.autoconfig.gui.DefaultGuiProviders;
import me.shedaniel.autoconfig.gui.DefaultGuiTransformers;
import me.shedaniel.autoconfig.gui.registry.ComposedGuiRegistryAccess;
import me.shedaniel.autoconfig.gui.registry.DefaultGuiRegistryAccess;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import net.minecraft.client.gui.screens.Screen;

public class AutoConfigClient {
    private static final Map<Class<? extends ConfigData>, GuiRegistry> guiRegistries = new HashMap<Class<? extends ConfigData>, GuiRegistry>();
    private static final GuiRegistry defaultGuiRegistry = DefaultGuiTransformers.apply(DefaultGuiProviders.apply(new GuiRegistry()));

    public static <T extends ConfigData> GuiRegistry getGuiRegistry(Class<T> configClass) {
        return guiRegistries.computeIfAbsent(configClass, n -> new GuiRegistry());
    }

    public static <T extends ConfigData> Supplier<Screen> getConfigScreen(Class<T> configClass, Screen parent) {
        return new ConfigScreenProvider((ConfigManager)AutoConfig.getConfigHolder(configClass), new ComposedGuiRegistryAccess(AutoConfigClient.getGuiRegistry(configClass), defaultGuiRegistry, new DefaultGuiRegistryAccess()), parent);
    }
}

