/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.CCTextures;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.Expandable;
import me.shedaniel.clothconfig2.api.LazyResettable;
import me.shedaniel.clothconfig2.api.ReferenceBuildingConfigScreen;
import me.shedaniel.clothconfig2.api.ReferenceProvider;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import me.shedaniel.clothconfig2.gui.entries.EmptyEntry;
import me.shedaniel.clothconfig2.gui.widget.SearchFieldEntry;
import me.shedaniel.math.Rectangle;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class GlobalizedClothConfigScreen
extends AbstractConfigScreen
implements ReferenceBuildingConfigScreen,
Expandable {
    public ClothConfigScreen.ListWidget<AbstractConfigEntry<AbstractConfigEntry<?>>> listWidget;
    private AbstractWidget cancelButton;
    private AbstractWidget exitButton;
    private final LinkedHashMap<Component, List<AbstractConfigEntry<?>>> categorizedEntries = Maps.newLinkedHashMap();
    private final ScrollingContainer sideScroller = new ScrollingContainer(){

        @Override
        public Rectangle getBounds() {
            return new Rectangle(4, 4, GlobalizedClothConfigScreen.this.getSideSliderPosition() - 14 - 4, GlobalizedClothConfigScreen.this.height - 8);
        }

        @Override
        public int getMaxScrollHeight() {
            int i = 0;
            for (Reference reference : GlobalizedClothConfigScreen.this.references) {
                if (i != 0) {
                    i = (int)((float)i + 3.0f * reference.getScale());
                }
                float f = i;
                Objects.requireNonNull(GlobalizedClothConfigScreen.this.font);
                i = (int)(f + 9.0f * reference.getScale());
            }
            return i;
        }
    };
    private Reference lastHoveredReference = null;
    private SearchFieldEntry searchFieldEntry;
    private final ScrollingContainer sideSlider = new ScrollingContainer(this){
        private final Rectangle empty = new Rectangle();

        @Override
        public Rectangle getBounds() {
            return this.empty;
        }

        @Override
        public int getMaxScrollHeight() {
            return 1;
        }
    };
    private final List<Reference> references = Lists.newArrayList();
    private final LazyResettable<Integer> sideExpandLimit = new LazyResettable<Integer>(() -> {
        int max = 0;
        for (Reference reference : this.references) {
            Component referenceText = reference.getText();
            int width = this.font.width((FormattedText)Component.literal((String)(StringUtils.repeat((String)"  ", (int)reference.getIndent()) + "- ")).append(referenceText));
            if (width <= max) continue;
            max = width;
        }
        return Math.min(max + 8, this.width / 4);
    });
    private boolean requestingReferenceRebuilding = false;

    @ApiStatus.Internal
    public GlobalizedClothConfigScreen(Screen parent, Component title, Map<String, ConfigCategory> categoryMap, Identifier backgroundLocation) {
        super(parent, title, backgroundLocation);
        categoryMap.forEach((categoryName, category) -> {
            ArrayList entries = Lists.newArrayList();
            for (Object object : category.getEntries()) {
                AbstractConfigListEntry entry = object instanceof Tuple ? (AbstractConfigListEntry)((Tuple)object).getB() : (AbstractConfigListEntry)object;
                entry.setScreen(this);
                entries.add(entry);
            }
            this.categorizedEntries.put(category.getCategoryKey(), entries);
        });
        this.sideSlider.scrollTo(0.0, false);
    }

    @Override
    public void requestReferenceRebuilding() {
        this.requestingReferenceRebuilding = true;
    }

    @Override
    public Map<Component, List<AbstractConfigEntry<?>>> getCategorizedEntries() {
        return this.categorizedEntries;
    }

    protected void init() {
        super.init();
        this.sideExpandLimit.reset();
        this.references.clear();
        this.buildReferences();
        this.listWidget = new ClothConfigScreen.ListWidget(this, this.minecraft, this.width - 14, this.height, 30, this.height - 32, this.getBackgroundLocation());
        this.addWidget((GuiEventListener)this.listWidget);
        this.listWidget.setLeftPos(14);
        this.listWidget.children().add(new EmptyEntry(5));
        this.searchFieldEntry = new SearchFieldEntry(this, this.listWidget);
        this.listWidget.children().add(this.searchFieldEntry);
        this.listWidget.children().add(new EmptyEntry(5));
        this.categorizedEntries.forEach((category, entries) -> {
            if (!this.listWidget.children().isEmpty()) {
                this.listWidget.children().add(new EmptyEntry(5));
            }
            this.listWidget.children().add(new EmptyEntry(4));
            this.listWidget.children().add(new CategoryTextEntry((Component)category, (Component)category.copy().withStyle(ChatFormatting.BOLD)));
            this.listWidget.children().add(new EmptyEntry(4));
            this.listWidget.children().addAll((Collection<AbstractConfigEntry<AbstractConfigEntry<?>>>)entries);
        });
        int buttonWidths = Math.min(200, (this.width - 50 - 12) / 3);
        this.cancelButton = Button.builder((Component)(this.isEdited() ? Component.translatable((String)"text.cloth-config.cancel_discard") : Component.translatable((String)"gui.cancel")), widget -> this.quit()).bounds(0, this.height - 26, buttonWidths, 20).build();
        this.addRenderableWidget((GuiEventListener)this.cancelButton);
        this.exitButton = new Button(0, this.height - 26, buttonWidths, 20, (Component)Component.empty(), button -> this.saveAll(true), Supplier::get){

            public void renderContents(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                boolean hasErrors = false;
                block0: for (List<AbstractConfigEntry<?>> entries : GlobalizedClothConfigScreen.this.categorizedEntries.values()) {
                    for (AbstractConfigEntry<?> entry : entries) {
                        if (!entry.getConfigError().isPresent()) continue;
                        hasErrors = true;
                        break block0;
                    }
                }
                this.active = GlobalizedClothConfigScreen.this.isEdited() && !hasErrors;
                this.setMessage((Component)(hasErrors ? Component.translatable((String)"text.cloth-config.error_cannot_save") : Component.translatable((String)"text.cloth-config.save_and_done")));
                this.renderDefaultSprite(graphics);
                this.renderDefaultLabel(graphics.textRendererForWidget((AbstractWidget)this, GuiGraphics.HoveredTextEffects.NONE));
            }
        };
        this.addRenderableWidget((GuiEventListener)this.exitButton);
        Optional.ofNullable(this.afterInitConsumer).ifPresent(consumer -> consumer.accept(this));
    }

    @Override
    public boolean matchesSearch(Iterator<String> tags) {
        return this.searchFieldEntry.matchesSearch(tags);
    }

    private void buildReferences() {
        this.categorizedEntries.forEach((categoryText, entries) -> {
            this.references.add(new CategoryReference((Component)categoryText));
            for (AbstractConfigEntry entry : entries) {
                this.buildReferenceFor(entry, 1);
            }
        });
    }

    private void buildReferenceFor(AbstractConfigEntry<?> entry, int layer) {
        List<ReferenceProvider<?>> referencableEntries = entry.getReferenceProviderEntries();
        if (referencableEntries != null) {
            this.references.add(new ConfigEntryReference(entry, layer));
            for (ReferenceProvider<?> referencableEntry : referencableEntries) {
                this.buildReferenceFor(referencableEntry.provideReferenceEntry(), layer + 1);
            }
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Rectangle scrollerBounds;
        Rectangle slideArrowBounds;
        int textColor;
        this.lastHoveredReference = null;
        if (this.requestingReferenceRebuilding) {
            this.references.clear();
            this.buildReferences();
            this.requestingReferenceRebuilding = false;
        }
        int sliderPosition = this.getSideSliderPosition();
        if (!this.isTransparentBackground()) {
            graphics.enableScissor(sliderPosition, 0, this.width, this.height);
            this.renderMenuBackground(graphics);
            this.overlayBackground(graphics, new Rectangle(14, 0, this.width, this.height), 64, 64, 64, 255);
        } else {
            if (this.minecraft.level == null) {
                this.renderPanorama(graphics, delta);
            }
            this.renderBlurredBackground(graphics);
            this.renderMenuBackground(graphics);
            graphics.enableScissor(sliderPosition, 0, this.width, this.height);
        }
        this.listWidget.width = this.width - sliderPosition;
        this.listWidget.setLeftPos(sliderPosition);
        this.listWidget.render(graphics, mouseX, mouseY, delta);
        graphics.enableScissor(this.listWidget.left, this.listWidget.top, this.listWidget.left + this.listWidget.width, this.listWidget.bottom);
        for (AbstractConfigEntry<AbstractConfigEntry<?>> child : this.listWidget.children()) {
            child.lateRender(graphics, mouseX, mouseY, delta);
        }
        graphics.disableScissor();
        graphics.drawString(this.font, this.title.getVisualOrderText(), (int)((float)sliderPosition + (float)(this.width - sliderPosition) / 2.0f - (float)this.font.width((FormattedText)this.title) / 2.0f), 12, -1);
        graphics.disableScissor();
        this.cancelButton.setX(sliderPosition + (this.width - sliderPosition) / 2 - this.cancelButton.getWidth() - 3);
        this.exitButton.setX(sliderPosition + (this.width - sliderPosition) / 2 + 3);
        super.render(graphics, mouseX, mouseY, delta);
        this.sideSlider.updatePosition(delta);
        this.sideScroller.updatePosition(delta);
        if (this.isTransparentBackground()) {
            graphics.blit(RenderPipelines.GUI_TEXTURED, Identifier.withDefaultNamespace((String)"textures/gui/menu_list_background.png"), 0, 0, (float)sliderPosition, (float)this.height, sliderPosition, this.height, 32, 32);
            graphics.blit(RenderPipelines.GUI_TEXTURED, Identifier.withDefaultNamespace((String)"textures/gui/menu_list_background.png"), 0, 0, (float)(sliderPosition - 14), (float)this.height, sliderPosition - 14, this.height, 32, 32);
            graphics.blit(RenderPipelines.GUI_TEXTURED, CCTextures.VERTICAL_HEADER_SEPARATOR, sliderPosition - 1, 0, 0.0f, 0.0f, 1, this.height, 2, 32);
            if (sliderPosition - 14 - 1 > 0) {
                graphics.blit(RenderPipelines.GUI_TEXTURED, CCTextures.VERTICAL_HEADER_SEPARATOR, sliderPosition - 14 - 1, 0, 0.0f, 0.0f, 1, this.height, 2, 32);
            }
        } else {
            graphics.blit(RenderPipelines.GUI_TEXTURED, this.getBackgroundLocation(), 0, 0, (float)sliderPosition, (float)this.height, sliderPosition, this.height, sliderPosition, this.height, 32, 32, -12303292);
            graphics.blit(RenderPipelines.GUI_TEXTURED, this.getBackgroundLocation(), 0, 0, (float)(sliderPosition - 14), (float)this.height, sliderPosition - 14, this.height, sliderPosition - 14, this.height, 32, 32, -14671840);
            graphics.blit(RenderPipelines.GUI_TEXTURED, CCTextures.VERTICAL_HEADER_SEPARATOR, sliderPosition - 1, 0, 0.0f, 0.0f, 1, this.height, 2, 32);
            if (sliderPosition - 14 - 1 > 0) {
                graphics.blit(RenderPipelines.GUI_TEXTURED, CCTextures.VERTICAL_HEADER_SEPARATOR, sliderPosition - 14 - 1, 0, 0.0f, 0.0f, 1, this.height, 2, 32);
            }
        }
        int n = textColor = (slideArrowBounds = new Rectangle(sliderPosition - 14, 0, 14, this.height)).contains(mouseX, mouseY) ? -96 : -1;
        if (Mth.ceil((double)((1.0 - this.sideSlider.scrollAmount()) * 255.0)) >= 10) {
            graphics.drawString(this.font, ">", Math.round((float)(sliderPosition - 7) - (float)this.font.width(">") / 2.0f), this.height / 2, textColor | Mth.clamp((int)Mth.ceil((double)((1.0 - this.sideSlider.scrollAmount()) * 255.0)), (int)0, (int)255) << 24);
        }
        if (Mth.ceil((double)(this.sideSlider.scrollAmount() * 255.0)) >= 10) {
            graphics.drawString(this.font, "<", Math.round((float)(sliderPosition - 7) - (float)this.font.width("<") / 2.0f), this.height / 2, textColor | Mth.clamp((int)Mth.ceil((double)(this.sideSlider.scrollAmount() * 255.0)), (int)0, (int)255) << 24);
        }
        if (!(scrollerBounds = this.sideScroller.getBounds()).isEmpty()) {
            graphics.enableScissor(0, 0, sliderPosition - 14, this.height);
            int scrollOffset = scrollerBounds.y - this.sideScroller.scrollAmountInt();
            for (Reference reference : this.references) {
                graphics.pose().pushMatrix();
                graphics.pose().scale(reference.getScale(), reference.getScale());
                MutableComponent text = Component.literal((String)(StringUtils.repeat((String)"  ", (int)reference.getIndent()) + "- ")).append(reference.getText());
                if (this.lastHoveredReference == null) {
                    int n2 = scrollerBounds.x;
                    int n3 = (int)((float)scrollOffset - 4.0f * reference.getScale());
                    int n4 = (int)((float)this.font.width((FormattedText)text) * reference.getScale());
                    Objects.requireNonNull(this.font);
                    if (new Rectangle(n2, n3, n4, (int)((float)(9 + 4) * reference.getScale())).contains(mouseX, mouseY)) {
                        this.lastHoveredReference = reference;
                    }
                }
                graphics.drawString(this.font, text.getVisualOrderText(), scrollerBounds.x, scrollOffset, this.lastHoveredReference == reference ? -7672 : -1, false);
                graphics.pose().popMatrix();
                float f = scrollOffset;
                Objects.requireNonNull(this.font);
                scrollOffset = (int)(f + (float)(9 + 3) * reference.getScale());
            }
            graphics.disableScissor();
            this.sideScroller.renderScrollBar(graphics);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
    }

    @Override
    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        Rectangle slideBounds = new Rectangle(0, 0, this.getSideSliderPosition() - 14, this.height);
        if (event.button() == 0 && slideBounds.contains(event.x(), event.y()) && this.lastHoveredReference != null) {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            this.lastHoveredReference.go();
            return true;
        }
        Rectangle slideArrowBounds = new Rectangle(this.getSideSliderPosition() - 14, 0, 14, this.height);
        if (event.button() == 0 && slideArrowBounds.contains(event.x(), event.y())) {
            this.setExpanded(!this.isExpanded());
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        return super.mouseClicked(event, doubleClick);
    }

    @Override
    public boolean isExpanded() {
        return this.sideSlider.scrollTarget() == 1.0;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.sideSlider.scrollTo(expanded ? 1.0 : 0.0, true, 2000L);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        Rectangle slideBounds = new Rectangle(0, 0, this.getSideSliderPosition() - 14, this.height);
        if (amountY != 0.0 && slideBounds.contains(mouseX, mouseY)) {
            this.sideScroller.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, amountX, amountY);
    }

    private int getSideSliderPosition() {
        return (int)(this.sideSlider.scrollAmount() * (double)this.sideExpandLimit.get().intValue() + 14.0);
    }

    private static interface Reference {
        default public int getIndent() {
            return 0;
        }

        public Component getText();

        public float getScale();

        public void go();
    }

    private class ConfigEntryReference
    implements Reference {
        private final AbstractConfigEntry<?> entry;
        private final int layer;

        public ConfigEntryReference(AbstractConfigEntry<?> entry, int layer) {
            this.entry = entry;
            this.layer = layer;
        }

        @Override
        public int getIndent() {
            return this.layer;
        }

        @Override
        public Component getText() {
            return this.entry.getFieldName();
        }

        @Override
        public float getScale() {
            return 1.0f;
        }

        @Override
        public void go() {
            int[] i = new int[]{0};
            for (AbstractConfigEntry<AbstractConfigEntry<?>> child : GlobalizedClothConfigScreen.this.listWidget.children()) {
                int i1 = i[0];
                if (this.goChild(i, null, child)) {
                    return;
                }
                i[0] = i1 + child.getItemHeight();
            }
        }

        private boolean goChild(int[] i, Integer expandedParent, AbstractConfigEntry<?> root) {
            boolean expanded;
            if (root == this.entry) {
                GlobalizedClothConfigScreen.this.listWidget.scrollTo(expandedParent == null ? (double)i[0] : (double)expandedParent.intValue(), true);
                return true;
            }
            int j = i[0];
            i[0] = i[0] + root.getInitialReferenceOffset();
            boolean bl = expanded = root instanceof Expandable && ((Expandable)((Object)root)).isExpanded();
            if (root instanceof Expandable) {
                ((Expandable)((Object)root)).setExpanded(true);
            }
            List children = root.children();
            if (root instanceof Expandable) {
                ((Expandable)((Object)root)).setExpanded(expanded);
            }
            for (GuiEventListener child : children) {
                if (!(child instanceof ReferenceProvider)) continue;
                int i1 = i[0];
                if (this.goChild(i, expandedParent != null ? expandedParent : (root instanceof Expandable && !expanded ? Integer.valueOf(j) : null), ((ReferenceProvider)child).provideReferenceEntry())) {
                    return true;
                }
                i[0] = i1 + ((ReferenceProvider)child).provideReferenceEntry().getItemHeight();
            }
            return false;
        }
    }

    private class CategoryReference
    implements Reference {
        private final Component category;

        public CategoryReference(Component category) {
            this.category = category;
        }

        @Override
        public Component getText() {
            return this.category;
        }

        @Override
        public float getScale() {
            return 1.0f;
        }

        @Override
        public void go() {
            int i = 0;
            for (AbstractConfigEntry<AbstractConfigEntry<?>> child : GlobalizedClothConfigScreen.this.listWidget.children()) {
                if (child instanceof CategoryTextEntry && ((CategoryTextEntry)child).category == this.category) {
                    GlobalizedClothConfigScreen.this.listWidget.scrollTo(i, true);
                    return;
                }
                i += child.getItemHeight();
            }
        }
    }

    private static class CategoryTextEntry
    extends AbstractConfigListEntry<Object> {
        private final Component category;
        private final Component text;

        public CategoryTextEntry(Component category, Component text) {
            super((Component)Component.literal((String)UUID.randomUUID().toString()), false);
            this.category = category;
            this.text = text;
        }

        @Override
        public int getItemHeight() {
            List strings = Minecraft.getInstance().font.split((FormattedText)this.text, this.getParent().getItemWidth());
            if (strings.isEmpty()) {
                return 0;
            }
            return 4 + strings.size() * 10;
        }

        @Override
        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent focusNavigationEvent) {
            return null;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public Optional<Object> getDefaultValue() {
            return Optional.empty();
        }

        @Override
        public boolean isMouseInside(int mouseX, int mouseY, int x, int y, int entryWidth, int entryHeight) {
            return false;
        }

        @Override
        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
            int yy = y + 2;
            List texts = Minecraft.getInstance().font.split((FormattedText)this.text, this.getParent().getItemWidth());
            for (FormattedCharSequence text : texts) {
                graphics.drawString(Minecraft.getInstance().font, text, x - 4 + entryWidth / 2 - Minecraft.getInstance().font.width(text) / 2, yy, -1);
                yy += 10;
            }
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }
    }
}

