/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.autoconfig;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.ConfigManager;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;

public class AutoConfig {
    public static final String MOD_ID = "autoconfig1u";
    private static final Map<Class<? extends ConfigData>, ConfigHolder<?>> holders = new HashMap();

    private AutoConfig() {
    }

    public static <T extends ConfigData> ConfigHolder<T> register(Class<T> configClass, ConfigSerializer.Factory<T> serializerFactory) {
        Objects.requireNonNull(configClass);
        Objects.requireNonNull(serializerFactory);
        if (holders.containsKey(configClass)) {
            throw new RuntimeException(String.format("Config '%s' already registered", configClass));
        }
        Config definition = configClass.getAnnotation(Config.class);
        if (definition == null) {
            throw new RuntimeException(String.format("No @Config annotation on %s!", configClass));
        }
        ConfigSerializer<T> serializer = serializerFactory.create(definition, configClass);
        ConfigManager<T> manager = new ConfigManager<T>(definition, configClass, serializer);
        holders.put(configClass, manager);
        return manager;
    }

    public static <T extends ConfigData> ConfigHolder<T> getConfigHolder(Class<T> configClass) {
        Objects.requireNonNull(configClass);
        if (holders.containsKey(configClass)) {
            return holders.get(configClass);
        }
        throw new RuntimeException(String.format("Config '%s' has not been registered", configClass));
    }
}

