/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.ConfigScreen;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.api.TickableWidget;
import me.shedaniel.clothconfig2.api.Tooltip;
import me.shedaniel.clothconfig2.gui.ClothRequiresRestartScreen;
import me.shedaniel.clothconfig2.gui.entries.KeyCodeEntry;
import me.shedaniel.math.Color;
import me.shedaniel.math.Rectangle;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConfigScreen
extends Screen
implements ConfigScreen {
    protected static final ResourceLocation CONFIG_TEX = ResourceLocation.fromNamespaceAndPath((String)"cloth-config2", (String)"textures/gui/cloth_config.png");
    private final ResourceLocation backgroundLocation;
    protected boolean confirmSave;
    protected final Screen parent;
    private boolean alwaysShowTabs = false;
    private boolean transparentBackground = false;
    @Nullable
    private Component defaultFallbackCategory = null;
    public int selectedCategoryIndex = 0;
    private boolean editable = true;
    private KeyCodeEntry focusedBinding;
    private ModifierKeyCode startedKeyCode = null;
    private final List<Tooltip> tooltips = Lists.newArrayList();
    @Nullable
    private Runnable savingRunnable = null;
    @Nullable
    protected Consumer<Screen> afterInitConsumer = null;

    protected AbstractConfigScreen(Screen parent, Component title, ResourceLocation backgroundLocation) {
        super(title);
        this.parent = parent;
        this.backgroundLocation = backgroundLocation;
    }

    public List<GuiEventListener> childrenL() {
        return super.children();
    }

    @Override
    public void setSavingRunnable(@Nullable Runnable savingRunnable) {
        this.savingRunnable = savingRunnable;
    }

    @Override
    public void setAfterInitConsumer(@Nullable Consumer<Screen> afterInitConsumer) {
        this.afterInitConsumer = afterInitConsumer;
    }

    @Override
    public ResourceLocation getBackgroundLocation() {
        return this.backgroundLocation;
    }

    @Override
    public boolean isRequiresRestart() {
        for (List<AbstractConfigEntry<?>> entries : this.getCategorizedEntries().values()) {
            for (AbstractConfigEntry<?> entry : entries) {
                if (!entry.getConfigError().isEmpty() || !entry.isEdited() || !entry.isRequiresRestart()) continue;
                return true;
            }
        }
        return false;
    }

    public abstract Map<Component, List<AbstractConfigEntry<?>>> getCategorizedEntries();

    @Override
    public boolean isEdited() {
        for (List<AbstractConfigEntry<?>> entries : this.getCategorizedEntries().values()) {
            for (AbstractConfigEntry<?> entry : entries) {
                if (!entry.isEdited()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isShowingTabs() {
        return this.isAlwaysShowTabs() || this.getCategorizedEntries().size() > 1;
    }

    public boolean isAlwaysShowTabs() {
        return this.alwaysShowTabs;
    }

    @ApiStatus.Internal
    public void setAlwaysShowTabs(boolean alwaysShowTabs) {
        this.alwaysShowTabs = alwaysShowTabs;
    }

    public boolean isTransparentBackground() {
        return this.transparentBackground;
    }

    @ApiStatus.Internal
    public void setTransparentBackground(boolean transparentBackground) {
        this.transparentBackground = transparentBackground;
    }

    public Component getFallbackCategory() {
        if (this.defaultFallbackCategory != null) {
            return this.defaultFallbackCategory;
        }
        return this.getCategorizedEntries().keySet().iterator().next();
    }

    @ApiStatus.Internal
    public void setFallbackCategory(@Nullable Component defaultFallbackCategory) {
        this.defaultFallbackCategory = defaultFallbackCategory;
        ArrayList categories = Lists.newArrayList(this.getCategorizedEntries().keySet());
        for (int i = 0; i < categories.size(); ++i) {
            Component category = (Component)categories.get(i);
            if (!category.equals((Object)this.getFallbackCategory())) continue;
            this.selectedCategoryIndex = i;
            break;
        }
    }

    @Override
    public void saveAll(boolean openOtherScreens) {
        for (List entries : Lists.newArrayList(this.getCategorizedEntries().values())) {
            for (AbstractConfigEntry entry : entries) {
                entry.save();
            }
        }
        this.save();
        if (openOtherScreens) {
            if (this.isRequiresRestart()) {
                this.minecraft.setScreen((Screen)new ClothRequiresRestartScreen(this.parent));
            } else {
                this.minecraft.setScreen(this.parent);
            }
        }
    }

    public void save() {
        Optional.ofNullable(this.savingRunnable).ifPresent(Runnable::run);
    }

    public boolean isEditable() {
        return this.editable;
    }

    @ApiStatus.Internal
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @ApiStatus.Internal
    public void setConfirmSave(boolean confirmSave) {
        this.confirmSave = confirmSave;
    }

    public KeyCodeEntry getFocusedBinding() {
        return this.focusedBinding;
    }

    @ApiStatus.Internal
    public void setFocusedBinding(KeyCodeEntry focusedBinding) {
        this.focusedBinding = focusedBinding;
        if (focusedBinding != null) {
            this.startedKeyCode = this.focusedBinding.getValue();
            this.startedKeyCode.setKeyCodeAndModifier(InputConstants.UNKNOWN, Modifier.none());
        } else {
            this.startedKeyCode = null;
        }
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (this.focusedBinding != null && this.startedKeyCode != null && !this.startedKeyCode.isUnknown() && this.focusedBinding.isAllowMouse()) {
            this.focusedBinding.setValue(this.startedKeyCode);
            this.setFocusedBinding(null);
            return true;
        }
        return super.mouseReleased(event);
    }

    public boolean keyReleased(KeyEvent event) {
        if (this.focusedBinding != null && this.startedKeyCode != null && this.focusedBinding.isAllowKey()) {
            this.focusedBinding.setValue(this.startedKeyCode);
            this.setFocusedBinding(null);
            return true;
        }
        return super.keyReleased(event);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.focusedBinding != null && this.startedKeyCode != null && this.focusedBinding.isAllowMouse()) {
            if (this.startedKeyCode.isUnknown()) {
                this.startedKeyCode.setKeyCode(InputConstants.Type.MOUSE.getOrCreate(event.button()));
            } else if (this.focusedBinding.isAllowModifiers() && this.startedKeyCode.getType() == InputConstants.Type.KEYSYM) {
                int code = this.startedKeyCode.getKeyCode().getValue();
                if (event.hasControlDown()) {
                    Modifier modifier = this.startedKeyCode.getModifier();
                    this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), true, modifier.hasShift()));
                    this.startedKeyCode.setKeyCode(InputConstants.Type.MOUSE.getOrCreate(event.button()));
                    return true;
                }
                if (event.hasShiftDown()) {
                    Modifier modifier = this.startedKeyCode.getModifier();
                    this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), modifier.hasControl(), true));
                    this.startedKeyCode.setKeyCode(InputConstants.Type.MOUSE.getOrCreate(event.button()));
                    return true;
                }
                if (event.hasAltDown()) {
                    Modifier modifier = this.startedKeyCode.getModifier();
                    this.startedKeyCode.setModifier(Modifier.of(true, modifier.hasControl(), modifier.hasShift()));
                    this.startedKeyCode.setKeyCode(InputConstants.Type.MOUSE.getOrCreate(event.button()));
                    return true;
                }
            }
            return true;
        }
        if (this.focusedBinding != null) {
            return true;
        }
        return super.mouseClicked(event, doubleClick);
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.focusedBinding != null && (this.focusedBinding.isAllowKey() || event.key() == 256)) {
            if (event.key() != 256) {
                if (this.startedKeyCode.isUnknown()) {
                    this.startedKeyCode.setKeyCode(InputConstants.getKey((KeyEvent)event));
                } else if (this.focusedBinding.isAllowModifiers()) {
                    if (this.startedKeyCode.getType() == InputConstants.Type.KEYSYM) {
                        int code = this.startedKeyCode.getKeyCode().getValue();
                        if (event.hasControlDown()) {
                            Modifier modifier = this.startedKeyCode.getModifier();
                            this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), true, modifier.hasShift()));
                            this.startedKeyCode.setKeyCode(InputConstants.getKey((KeyEvent)event));
                            return true;
                        }
                        if (event.hasShiftDown()) {
                            Modifier modifier = this.startedKeyCode.getModifier();
                            this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), modifier.hasControl(), true));
                            this.startedKeyCode.setKeyCode(InputConstants.getKey((KeyEvent)event));
                            return true;
                        }
                        if (event.hasAltDown()) {
                            Modifier modifier = this.startedKeyCode.getModifier();
                            this.startedKeyCode.setModifier(Modifier.of(true, modifier.hasControl(), modifier.hasShift()));
                            this.startedKeyCode.setKeyCode(InputConstants.getKey((KeyEvent)event));
                            return true;
                        }
                    }
                    if (event.hasControlDown()) {
                        Modifier modifier = this.startedKeyCode.getModifier();
                        this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), true, modifier.hasShift()));
                        return true;
                    }
                    if (event.hasShiftDown()) {
                        Modifier modifier = this.startedKeyCode.getModifier();
                        this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), modifier.hasControl(), true));
                        return true;
                    }
                    if (event.hasAltDown()) {
                        Modifier modifier = this.startedKeyCode.getModifier();
                        this.startedKeyCode.setModifier(Modifier.of(true, modifier.hasControl(), modifier.hasShift()));
                        return true;
                    }
                }
            } else {
                this.focusedBinding.setValue(ModifierKeyCode.unknown());
                this.setFocusedBinding(null);
            }
            return true;
        }
        if (this.focusedBinding != null && !event.isEscape()) {
            return true;
        }
        if (event.isEscape() && this.shouldCloseOnEsc()) {
            return this.quit();
        }
        return super.keyPressed(event);
    }

    protected final boolean quit() {
        if (this.confirmSave && this.isEdited()) {
            this.minecraft.setScreen((Screen)new ConfirmScreen((BooleanConsumer)new QuitSaveConsumer(), (Component)Component.translatable((String)"text.cloth-config.quit_config"), (Component)Component.translatable((String)"text.cloth-config.quit_config_sure"), (Component)Component.translatable((String)"text.cloth-config.quit_discard"), (Component)Component.translatable((String)"gui.cancel")));
        } else {
            this.minecraft.setScreen(this.parent);
        }
        return true;
    }

    public void tick() {
        super.tick();
        boolean edited = this.isEdited();
        Optional.ofNullable(this.getQuitButton()).ifPresent(button -> button.setMessage((Component)(edited ? Component.translatable((String)"text.cloth-config.cancel_discard") : Component.translatable((String)"gui.cancel"))));
        for (GuiEventListener child : this.children()) {
            if (!(child instanceof TickableWidget)) continue;
            TickableWidget widget = (TickableWidget)child;
            widget.tick();
        }
    }

    @Nullable
    protected AbstractWidget getQuitButton() {
        return null;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        for (Tooltip tooltip : this.tooltips) {
            graphics.setTooltipForNextFrame(Minecraft.getInstance().font, tooltip.getText(), tooltip.getX(), tooltip.getY());
        }
        this.tooltips.clear();
    }

    @Override
    public void addTooltip(Tooltip tooltip) {
        this.tooltips.add(tooltip);
    }

    @Deprecated
    protected void overlayBackground(GuiGraphics graphics, Rectangle rect, int red, int green, int blue, int alpha) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, this.getBackgroundLocation(), rect.getMinX(), rect.getMinY(), (float)rect.getMaxX(), (float)rect.getMaxY(), rect.getWidth(), rect.getHeight(), rect.getWidth(), rect.getHeight(), 32, 32, Color.ofRGBA((int)red, (int)green, (int)blue, (int)alpha).getColor());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleComponentClicked(@Nullable Style style) {
        URI uri;
        if (style == null) {
            return false;
        }
        ClickEvent clickEvent = style.getClickEvent();
        if (!(clickEvent instanceof ClickEvent.OpenUrl)) return super.handleComponentClicked(style);
        ClickEvent.OpenUrl openUrl = (ClickEvent.OpenUrl)clickEvent;
        try {
            URI uRI;
            uri = uRI = openUrl.uri();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Minecraft.getInstance().setScreen((Screen)new ConfirmLinkScreen(openInBrowser -> {
            if (openInBrowser) {
                Util.getPlatform().openUri(uri);
            }
            Minecraft.getInstance().setScreen((Screen)this);
        }, uri.toString(), true));
        return true;
    }

    private class QuitSaveConsumer
    implements BooleanConsumer {
        private QuitSaveConsumer() {
        }

        public void accept(boolean t) {
            if (!t) {
                AbstractConfigScreen.this.minecraft.setScreen((Screen)AbstractConfigScreen.this);
            } else {
                AbstractConfigScreen.this.minecraft.setScreen(AbstractConfigScreen.this.parent);
            }
        }
    }
}

