/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.StringListEntry;
import me.shedaniel.clothconfig2.impl.builders.AbstractFieldBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class StringFieldBuilder
extends AbstractFieldBuilder<String, StringListEntry, StringFieldBuilder> {
    public StringFieldBuilder(Component resetButtonKey, Component fieldNameKey, String value) {
        super(resetButtonKey, fieldNameKey);
        Objects.requireNonNull(value);
        this.value = value;
    }

    @Override
    public StringFieldBuilder setErrorSupplier(Function<String, Optional<Component>> errorSupplier) {
        return (StringFieldBuilder)super.setErrorSupplier(errorSupplier);
    }

    @Override
    public StringFieldBuilder requireRestart() {
        return (StringFieldBuilder)super.requireRestart();
    }

    @Override
    public StringFieldBuilder setSaveConsumer(Consumer<String> saveConsumer) {
        return (StringFieldBuilder)super.setSaveConsumer(saveConsumer);
    }

    @Override
    public StringFieldBuilder setDefaultValue(Supplier<String> defaultValue) {
        return (StringFieldBuilder)super.setDefaultValue(defaultValue);
    }

    @Override
    public StringFieldBuilder setDefaultValue(String defaultValue) {
        return (StringFieldBuilder)super.setDefaultValue(defaultValue);
    }

    @Override
    public StringFieldBuilder setTooltipSupplier(Function<String, Optional<Component[]>> tooltipSupplier) {
        return (StringFieldBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public StringFieldBuilder setTooltipSupplier(Supplier<Optional<Component[]>> tooltipSupplier) {
        return (StringFieldBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public StringFieldBuilder setTooltip(Optional<Component[]> tooltip) {
        return (StringFieldBuilder)super.setTooltip(tooltip);
    }

    @Override
    public StringFieldBuilder setTooltip(Component ... tooltip) {
        return (StringFieldBuilder)super.setTooltip(tooltip);
    }

    @Override
    @NotNull
    public StringListEntry build() {
        StringListEntry entry = new StringListEntry(this.getFieldNameKey(), (String)this.value, this.getResetButtonKey(), this.defaultValue, this.getSaveConsumer(), null, this.isRequireRestart());
        entry.setTooltipSupplier(() -> this.getTooltipSupplier().apply(entry.getValue()));
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return this.finishBuilding(entry);
    }
}

