/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
public class LongSliderEntry
extends TooltipListEntry<Long> {
    protected Slider sliderWidget;
    protected Button resetButton;
    protected AtomicLong value;
    protected final long orginial;
    private long minimum;
    private long maximum;
    private final Supplier<Long> defaultValue;
    private Function<Long, Component> textGetter = value -> Component.literal((String)String.format("Value: %d", value));
    private final List<AbstractWidget> widgets;

    @Deprecated
    @ApiStatus.Internal
    public LongSliderEntry(Component fieldName, long minimum, long maximum, long value, Consumer<Long> saveConsumer, Component resetButtonKey, Supplier<Long> defaultValue) {
        this(fieldName, minimum, maximum, value, saveConsumer, resetButtonKey, defaultValue, null);
    }

    @Deprecated
    @ApiStatus.Internal
    public LongSliderEntry(Component fieldName, long minimum, long maximum, long value, Consumer<Long> saveConsumer, Component resetButtonKey, Supplier<Long> defaultValue, Supplier<Optional<Component[]>> tooltipSupplier) {
        this(fieldName, minimum, maximum, value, saveConsumer, resetButtonKey, defaultValue, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public LongSliderEntry(Component fieldName, long minimum, long maximum, long value2, Consumer<Long> saveConsumer, Component resetButtonKey, Supplier<Long> defaultValue, Supplier<Optional<Component[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.orginial = value2;
        this.defaultValue = defaultValue;
        this.value = new AtomicLong(value2);
        this.saveCallback = saveConsumer;
        this.maximum = maximum;
        this.minimum = minimum;
        this.sliderWidget = new Slider(0, 0, 152, 20, ((double)this.value.get() - (double)minimum) / (double)Math.abs(maximum - minimum));
        this.resetButton = Button.builder((Component)resetButtonKey, widget -> this.setValue((Long)defaultValue.get())).bounds(0, 0, Minecraft.getInstance().font.width((FormattedText)resetButtonKey) + 6, 20).build();
        this.sliderWidget.setMessage(this.textGetter.apply(this.value.get()));
        this.widgets = Lists.newArrayList((Object[])new AbstractWidget[]{this.sliderWidget, this.resetButton});
    }

    public Function<Long, Component> getTextGetter() {
        return this.textGetter;
    }

    public LongSliderEntry setTextGetter(Function<Long, Component> textGetter) {
        this.textGetter = textGetter;
        this.sliderWidget.setMessage(textGetter.apply(this.value.get()));
        return this;
    }

    @Override
    public Long getValue() {
        return this.value.get();
    }

    @Deprecated
    public void setValue(long value) {
        this.sliderWidget.setValue((double)(Mth.clamp((long)value, (long)this.minimum, (long)this.maximum) - this.minimum) / (double)Math.abs(this.maximum - this.minimum));
        this.value.set(Math.min(Math.max(value, this.minimum), this.maximum));
        this.sliderWidget.updateMessage();
    }

    @Override
    public Optional<Long> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    public List<? extends GuiEventListener> children() {
        return this.widgets;
    }

    @Override
    public List<? extends NarratableEntry> narratables() {
        return this.widgets;
    }

    @Override
    public boolean isEdited() {
        return super.isEdited() || this.getValue() != this.orginial;
    }

    public LongSliderEntry setMaximum(long maximum) {
        this.maximum = maximum;
        return this;
    }

    public LongSliderEntry setMinimum(long minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        Window window = Minecraft.getInstance().getWindow();
        this.resetButton.active = this.isEditable() && this.getDefaultValue().isPresent() && this.defaultValue.get().longValue() != this.value.get();
        this.resetButton.setY(y);
        this.sliderWidget.active = this.isEditable();
        this.sliderWidget.setY(y);
        Component displayedFieldName = this.getDisplayedFieldName();
        if (Minecraft.getInstance().font.isBidirectional()) {
            graphics.drawString(Minecraft.getInstance().font, displayedFieldName.getVisualOrderText(), window.getGuiScaledWidth() - x - Minecraft.getInstance().font.width((FormattedText)displayedFieldName), y + 6, this.getPreferredTextColor());
            this.resetButton.setX(x);
            this.sliderWidget.setX(x + this.resetButton.getWidth() + 1);
        } else {
            graphics.drawString(Minecraft.getInstance().font, displayedFieldName.getVisualOrderText(), x, y + 6, this.getPreferredTextColor());
            this.resetButton.setX(x + entryWidth - this.resetButton.getWidth());
            this.sliderWidget.setX(x + entryWidth - 150);
        }
        this.sliderWidget.setWidth(150 - this.resetButton.getWidth() - 2);
        this.resetButton.render(graphics, mouseX, mouseY, delta);
        this.sliderWidget.render(graphics, mouseX, mouseY, delta);
    }

    private class Slider
    extends AbstractSliderButton {
        protected Slider(int int_1, int int_2, int int_3, int int_4, double double_1) {
            super(int_1, int_2, int_3, int_4, (Component)Component.empty(), double_1);
        }

        public void updateMessage() {
            this.setMessage(LongSliderEntry.this.textGetter.apply(LongSliderEntry.this.value.get()));
        }

        protected void applyValue() {
            LongSliderEntry.this.value.set((long)((double)LongSliderEntry.this.minimum + (double)Math.abs(LongSliderEntry.this.maximum - LongSliderEntry.this.minimum) * this.value));
        }

        public boolean keyPressed(KeyEvent event) {
            if (!LongSliderEntry.this.isEditable()) {
                return false;
            }
            return super.keyPressed(event);
        }

        public boolean mouseDragged(MouseButtonEvent event, double double_3, double double_4) {
            if (!LongSliderEntry.this.isEditable()) {
                return false;
            }
            return super.mouseDragged(event, double_3, double_4);
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double integer) {
            this.value = integer;
        }
    }
}

