/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.config.options.preview;

import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.config.ConfigAccess;
import me.shedaniel.rei.impl.client.gui.config.options.AllREIConfigOptions;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.stream.Stream;

public class TooltipPreviewer {
    public static WidgetWithBounds create(ConfigAccess access, int width, @Nullable IntSupplier height) {
        Rectangle bounds = new Rectangle();
        return Widgets.withBounds(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
            EntryStack<class_1799> stack = EntryStacks.of(class_1802.field_8118);
            boolean appendModNames = access.get(AllREIConfigOptions.APPEND_MOD_NAMES);
            boolean appendFavorites = access.get(AllREIConfigOptions.APPEND_FAVORITES_HINT);
            List<Tooltip.Entry> entries = new ArrayList<>();
            entries.add(Tooltip.entry(ConfigUtils.translatable("block.minecraft.oak_planks")));
            if (appendModNames) {
                entries.add(Tooltip.entry(ConfigUtils.literal("Minecraft").method_27695(class_124.field_1078, class_124.field_1056)));
            }
            if (appendFavorites) {
                String name = ConfigObject.getInstance().getFavoriteKeyCode().getLocalizedName().getString();
                entries.addAll(Stream.of(class_1074.method_4662("text.rei.favorites_tooltip", name).split("\n"))
                        .map(ConfigUtils::literal).map(Tooltip::entry).toList());
            }
            List<class_5481> components = entries.stream().flatMap(entry -> class_310.method_1551().field_1772.method_1728(entry.getAsText(), width - 12 - 4).stream()).toList();
            int minWidth = components.stream().mapToInt(component -> class_310.method_1551().field_1772.method_30880(component)).max().orElse(0) + 4;
            int minHeight = components.stream().mapToInt(component -> components.get(0) == component && components.size() >= 2 ? 2 + 10 : 10).sum() + 4;
            
            int tX = Math.max(6, (width - minWidth) / 2), tWidth = Math.min(width - 12, minWidth), tY = 24 + 4, tHeight = Math.min(minHeight, height == null ? 100000 : height.getAsInt() - tY - 4);
            graphics.method_51448().pushMatrix();
            graphics.method_51448().translate(0, height == null ? 4 : Math.max(0, (height.getAsInt() - (tY + tHeight)) / 2));
            bounds.setSize(width, height == null ? tY + tHeight + 12 : height.getAsInt());
            stack.getRenderer().render(stack, graphics, new Rectangle(width / 2 - 12, 0, 24, 24), mouseX, mouseY, delta);
            
            int finalTY = tY;
            graphics.method_25296(tX - 3, finalTY - 4, tX + tWidth + 3, finalTY - 3, -267386864, -267386864);
            graphics.method_25296(tX - 3, finalTY + tHeight + 3, tX + tWidth + 3, finalTY + tHeight + 4, -267386864, -267386864);
            graphics.method_25296(tX - 3, finalTY - 3, tX + tWidth + 3, finalTY + tHeight + 3, -267386864, -267386864);
            graphics.method_25296(tX - 4, finalTY - 3, tX - 3, finalTY + tHeight + 3, -267386864, -267386864);
            graphics.method_25296(tX + tWidth + 3, finalTY - 3, tX + tWidth + 4, finalTY + tHeight + 3, -267386864, -267386864);
            graphics.method_25296(tX - 3, finalTY - 3 + 1, tX - 3 + 1, finalTY + tHeight + 3 - 1, 1347420415, 1344798847);
            graphics.method_25296(tX + tWidth + 2, finalTY - 3 + 1, tX + tWidth + 3, finalTY + tHeight + 3 - 1, 1347420415, 1344798847);
            graphics.method_25296(tX - 3, finalTY - 3, tX + tWidth + 3, finalTY - 3 + 1, 1347420415, 1347420415);
            graphics.method_25296(tX - 3, finalTY + tHeight + 2, tX + tWidth + 3, finalTY + tHeight + 3, 1344798847, 1344798847);
            
            for (int i = 0; i < components.size(); i++) {
                graphics.method_51430(class_310.method_1551().field_1772, components.get(i), tX + 2, tY + 2, -1, false);
                tY += 10 + (i == 0 ? 2 : 0);
            }
            
            graphics.method_51448().popMatrix();
        }), bounds);
    }
    
    private static void fillGradient(Matrix4f pose, class_4588 buffer, int x1, int y1, int x2, int y2, int blitOffset, int color1, int color2) {
        float f = (float) (color1 >> 24 & 0xFF) / 255.0F;
        float g = (float) (color1 >> 16 & 0xFF) / 255.0F;
        float h = (float) (color1 >> 8 & 0xFF) / 255.0F;
        float i = (float) (color1 & 0xFF) / 255.0F;
        float j = (float) (color2 >> 24 & 0xFF) / 255.0F;
        float k = (float) (color2 >> 16 & 0xFF) / 255.0F;
        float l = (float) (color2 >> 8 & 0xFF) / 255.0F;
        float m = (float) (color2 & 0xFF) / 255.0F;
        buffer.method_22918(pose, (float) x2, (float) y1, (float) blitOffset).method_22915(g, h, i, f);
        buffer.method_22918(pose, (float) x1, (float) y1, (float) blitOffset).method_22915(g, h, i, f);
        buffer.method_22918(pose, (float) x1, (float) y2, (float) blitOffset).method_22915(k, l, m, j);
        buffer.method_22918(pose, (float) x2, (float) y2, (float) blitOffset).method_22915(k, l, m, j);
    }
}
