/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.entry;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.architectury.hooks.item.ItemStackHooks;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class ItemEntryDefinition
implements EntryDefinition<class_1799>,
EntrySerializer<class_1799> {
    @Environment(value=EnvType.CLIENT)
    private EntryRenderer<class_1799> renderer;
    private static final ReferenceSet<class_1792> SEARCH_BLACKLISTED = new ReferenceOpenHashSet();

    public ItemEntryDefinition() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> Client.init(this));
    }

    public Class<class_1799> getValueType() {
        return class_1799.class;
    }

    public EntryType<class_1799> getType() {
        return VanillaEntryTypes.ITEM;
    }

    @Environment(value=EnvType.CLIENT)
    public EntryRenderer<class_1799> getRenderer() {
        return this.renderer;
    }

    @Nullable
    public class_2960 getIdentifier(EntryStack<class_1799> entry, class_1799 value) {
        return class_7923.field_41178.method_10221((Object)value.method_7909());
    }

    public boolean isEmpty(EntryStack<class_1799> entry, class_1799 value) {
        return value.method_7960();
    }

    public class_1799 copy(EntryStack<class_1799> entry, class_1799 value) {
        return value.method_7972();
    }

    public class_1799 normalize(EntryStack<class_1799> entry, class_1799 value) {
        class_1799 copy = value.method_7972();
        copy.method_7939(1);
        return copy;
    }

    public class_1799 wildcard(EntryStack<class_1799> entry, class_1799 value) {
        return new class_1799((class_1935)value.method_7909(), 1);
    }

    @Nullable
    public class_1799 cheatsAs(EntryStack<class_1799> entry, class_1799 value) {
        return value.method_7972();
    }

    @Nullable
    public class_1799 add(class_1799 o1, class_1799 o2) {
        return ItemStackHooks.copyWithCount((class_1799)o1, (int)(o1.method_7947() + o2.method_7947()));
    }

    public long hash(EntryStack<class_1799> entry, class_1799 value, ComparisonContext context) {
        int code = 1;
        code = 31 * code + System.identityHashCode(value.method_7909());
        code = 31 * code + Long.hashCode(ItemComparatorRegistry.getInstance().hashOf(context, (Object)value));
        return code;
    }

    public boolean equals(class_1799 o1, class_1799 o2, ComparisonContext context) {
        if (o1.method_7909() != o2.method_7909()) {
            return false;
        }
        return ItemComparatorRegistry.getInstance().hashOf(context, (Object)o1) == ItemComparatorRegistry.getInstance().hashOf(context, (Object)o2);
    }

    @Nullable
    public EntrySerializer<class_1799> getSerializer() {
        return this;
    }

    public boolean acceptsNull() {
        return false;
    }

    public Codec<class_1799> codec() {
        return class_1799.field_24671;
    }

    public class_9139<class_9129, class_1799> streamCodec() {
        return class_1799.field_49268;
    }

    public class_2561 asFormattedText(EntryStack<class_1799> entry, class_1799 value) {
        return this.asFormattedText(entry, value, TooltipContext.of((class_1792.class_9635)class_1792.class_9635.field_51353));
    }

    public class_2561 asFormattedText(EntryStack<class_1799> entry, class_1799 value, TooltipContext context) {
        if (!SEARCH_BLACKLISTED.contains((Object)value.method_7909())) {
            try {
                return value.method_7964();
            }
            catch (Throwable e) {
                if (context != null && context.isSearch()) {
                    throw e;
                }
                e.printStackTrace();
                SEARCH_BLACKLISTED.add((Object)value.method_7909());
            }
        }
        try {
            return class_2561.method_43470((String)class_1074.method_4662((String)("item." + class_7923.field_41178.method_10221((Object)value.method_7909()).toString().replace(":", ".")), (Object[])new Object[0]));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return class_2561.method_43470((String)"ERROR");
        }
    }

    public Stream<? extends class_6862<?>> getTagsFor(EntryStack<class_1799> entry, class_1799 value) {
        Stream tags = value.method_40133();
        class_1792 class_17922 = value.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            tags = Stream.concat(tags, blockItem.method_7711().method_40142().method_40228());
        }
        return tags;
    }

    @Environment(value=EnvType.CLIENT)
    private List<class_2561> tryGetItemStackToolTip(EntryStack<class_1799> entry, class_1799 value, TooltipContext context) {
        if (!SEARCH_BLACKLISTED.contains((Object)value.method_7909())) {
            try {
                return value.method_7950(context.vanillaContext(), (class_1657)class_310.method_1551().field_1724, context.getFlag());
            }
            catch (Throwable e) {
                if (context.isSearch()) {
                    throw e;
                }
                e.printStackTrace();
                SEARCH_BLACKLISTED.add((Object)value.method_7909());
            }
        }
        return Lists.newArrayList((Object[])new class_2561[]{this.asFormattedText(entry, value, context)});
    }

    public void fillCrashReport(class_128 report, class_129 category, EntryStack<class_1799> entry) {
        super.fillCrashReport(report, category, entry);
        class_1799 stack = (class_1799)entry.getValue();
        category.method_577("Item Type", () -> String.valueOf(stack.method_7909()));
        category.method_577("Item Damage", () -> String.valueOf(stack.method_7919()));
        category.method_577("Item Components", () -> class_9326.field_49589.encodeStart((DynamicOps)BasicDisplay.registryAccess().method_57093((DynamicOps)class_2509.field_11560), (Object)stack.method_57380()).result().map(class_2520::toString).orElse("Error"));
        category.method_577("Item Foil", () -> String.valueOf(stack.method_7958()));
    }

    @Environment(value=EnvType.CLIENT)
    private static class Client {
        private Client() {
        }

        private static void init(ItemEntryDefinition definition) {
            definition.renderer = definition.new ItemEntryRenderer();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class ItemEntryRenderer
    implements EntryRenderer<class_1799> {
        private static final float SCALE = 20.0f;
        public static final int ITEM_LIGHT = 0xF000F0;

        public void render(EntryStack<class_1799> entry, class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
            if (!entry.isEmpty()) {
                class_1799 value = (class_1799)entry.getValue();
                graphics.method_51448().pushMatrix();
                graphics.method_51448().translate((float)bounds.x, (float)bounds.y);
                graphics.method_51448().scale((float)bounds.getWidth() / 16.0f, (float)bounds.getHeight() / 16.0f);
                graphics.method_51427(value, 0, 0);
                if (!value.method_7960()) {
                    graphics.method_51431(class_310.method_1551().field_1772, value, 0, 0);
                }
                graphics.method_51448().popMatrix();
            }
        }

        @Nullable
        public Tooltip getTooltip(EntryStack<class_1799> entry, TooltipContext context) {
            if (entry.isEmpty()) {
                return null;
            }
            Tooltip tooltip = Tooltip.create((class_2561[])new class_2561[0]);
            Optional component = ((class_1799)entry.getValue()).method_32347();
            List<class_2561> components = ItemEntryDefinition.this.tryGetItemStackToolTip(entry, (class_1799)entry.getValue(), context);
            if (!components.isEmpty()) {
                tooltip.add(components.get(0));
            }
            component.ifPresent(arg_0 -> ((Tooltip)tooltip).add(arg_0));
            for (int i = 1; i < components.size(); ++i) {
                tooltip.add(components.get(i));
            }
            return tooltip.withTooltipStyle((class_2960)((class_1799)entry.getValue()).method_58694(class_9334.field_54198));
        }
    }
}

