/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.comparison;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.EntryComparator;
import me.shedaniel.rei.api.common.entry.comparison.EntryComparatorRegistry;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class EntryComparatorRegistryImpl<T, S>
implements EntryComparatorRegistry<T, S> {
    private final List<EntryComparator<T>> globalComparators = new ArrayList<EntryComparator<T>>();
    private final Map<S, EntryComparator<T>> comparators = new IdentityHashMap<S, EntryComparator<T>>();

    public void register(EntryComparator<T> comparator, S entry) {
        EntryComparator<T> existing = this.comparators.get(entry);
        if (existing != null) {
            comparator = existing.then(comparator);
        }
        this.comparators.put(entry, comparator);
    }

    public void registerGlobal(EntryComparator<T> comparator) {
        this.globalComparators.add(comparator);
    }

    public ReloadStage getStage() {
        return ReloadStage.START;
    }

    public void startReload() {
        this.globalComparators.clear();
        this.comparators.clear();
    }

    public abstract S getEntry(T var1);

    public abstract EntryComparator<T> defaultComparator();

    public long hashOf(ComparisonContext context, T stack) {
        EntryComparator<T> comparator = this.comparators.get(this.getEntry(stack));
        if (comparator == null) {
            comparator = this.defaultComparator();
        }
        long hash = 1L;
        hash = hash * 31L + comparator.hash(context, stack);
        for (EntryComparator<T> globalComparator : this.globalComparators) {
            hash = hash * 31L + globalComparator.hash(context, stack);
        }
        return hash;
    }

    public boolean containsComparator(S item) {
        return !this.globalComparators.isEmpty() || this.comparators.containsKey(item);
    }

    public int comparatorSize() {
        return this.globalComparators.size() + this.comparators.size();
    }
}

