/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.util;

import com.google.common.collect.Iterators;
import java.util.List;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.util.CyclingList;

public abstract class ConcatenatedListIterator<T>
implements CyclingList<T> {
    private static final int HEAD_FIRST = -1;
    private static final int HEAD_LAST = -2;
    private static final int TAIL_FIRST = -3;
    private static final int TAIL_LAST = -4;
    private final List<T> listView = CollectionUtils.concatUnmodifiable(() -> Iterators.forArray((Object[])new List[]{(List)head.get(), (List)tail.get()}));
    private final CyclingList<T> head;
    private final CyclingList<T> tail;
    private int position = -1;

    public ConcatenatedListIterator(CyclingList<T> head, CyclingList<T> tail) {
        this.head = head;
        this.tail = tail;
        this.head.resetToStart();
        this.tail.resetToStart();
    }

    protected abstract T empty();

    @Override
    public T peek() {
        int p = this.currentIndex();
        int neededHeadPos = Math.min(p, this.head.size() - 1);
        int neededTailPos = Math.max(p - this.head.size(), 0);
        while (this.head.currentIndex() != neededHeadPos) {
            this.head.next();
        }
        while (this.tail.currentIndex() != neededTailPos) {
            this.tail.next();
        }
        return p < this.head.size() ? this.head.peek() : this.tail.peek();
    }

    @Override
    public T next() {
        this.position = this.nextIndex();
        int neededHeadPos = Math.min(this.position, this.head.size() - 1);
        int neededTailPos = Math.max(this.position - this.head.size(), 0);
        while (this.head.currentIndex() != neededHeadPos) {
            this.head.next();
        }
        while (this.tail.currentIndex() != neededTailPos) {
            this.tail.next();
        }
        T t = this.position < this.head.size() ? this.head.peek() : this.tail.peek();
        this.position = this.normalizeIndex(this.position);
        return t;
    }

    @Override
    public T previous() {
        this.position = this.previousIndex();
        int neededHeadPos = Math.min(this.position, this.head.size() - 1);
        int neededTailPos = Math.max(this.position - this.head.size(), 0);
        while (this.head.currentIndex() != neededHeadPos) {
            this.head.previous();
        }
        while (this.tail.currentIndex() != neededTailPos) {
            this.tail.previous();
        }
        T t = this.position < this.head.size() ? this.head.peek() : this.tail.peek();
        this.position = this.normalizeIndex(this.position);
        return t;
    }

    private int normalizeIndex(int index) {
        if (index == 0) {
            return -1;
        }
        int hSize = this.head.size();
        if (index == hSize - 1) {
            return -2;
        }
        if (index == hSize) {
            return -3;
        }
        if (index == hSize + this.tail.size() - 1) {
            return -4;
        }
        return index;
    }

    @Override
    public int currentIndex() {
        int size = this.size();
        int tmp = switch (this.position) {
            case -1 -> 0;
            case -2 -> this.head.size() - 1;
            case -3 -> {
                if (this.tail.size() > 0) {
                    yield this.head.size();
                }
                yield 0;
            }
            case -4 -> size - 1;
            default -> this.position;
        };
        return Math.floorMod(tmp, size);
    }

    @Override
    public int nextIndex() {
        int size = this.size();
        int tmp = switch (this.position) {
            case -1 -> 1;
            case -2 -> {
                if (this.tail.size() > 0) {
                    yield this.head.size();
                }
                if (this.head.size() > 0) {
                    yield 0;
                }
                yield 1;
            }
            case -3 -> {
                if (this.tail.size() > 0) {
                    yield this.head.size() + 1;
                }
                if (this.head.size() > 0) {
                    yield 0;
                }
                yield 1;
            }
            case -4 -> {
                if (size > 0) {
                    yield 0;
                }
                yield 1;
            }
            default -> this.position + 1;
        };
        return Math.floorMod(tmp, size);
    }

    @Override
    public int previousIndex() {
        int size = this.size();
        int tmp = switch (this.position) {
            case -1 -> size - 1;
            case -2 -> {
                if (this.head.size() > 0) {
                    yield this.head.size() - 2;
                }
                if (this.tail.size() > 0) {
                    yield this.tail.size() - 1;
                }
                yield -1;
            }
            case -3 -> this.head.size() - 1;
            case -4 -> {
                if (size > 0) {
                    yield size - 2;
                }
                yield -1;
            }
            default -> this.position - 1;
        };
        return Math.floorMod(tmp, size);
    }

    @Override
    public List<T> get() {
        if (this.tail.size() == 0) {
            return (List)this.head.get();
        }
        if (this.head.size() == 0) {
            return (List)this.tail.get();
        }
        return this.listView;
    }

    @Override
    public int size() {
        return this.head.size() + this.tail.size();
    }

    @Override
    public void resetToStart() {
        this.head.resetToStart();
        this.tail.resetToStart();
        this.position = 0;
    }
}

