/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.screen;

import me.shedaniel.rei.impl.client.gui.modules.Menu;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class ScreenWithMenu extends class_437 {
    @Nullable
    private Menu menu;
    
    protected ScreenWithMenu(class_2561 component) {
        super(component);
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        if (this.menu != null) {
            this.menu.method_25394(graphics, mouseX, mouseY, delta);
        }
    }
    
    protected void setMenu(@Nullable Menu menu) {
        this.menu = menu;
    }
    
    protected void closeMenu() {
        this.menu = null;
    }
    
    @Override
    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (this.menu != null) {
            if (!this.menu.method_25402(event, doubleClick))
                this.menu = null;
            return true;
        }
        return super.method_25402(event, doubleClick);
    }
    
    @Override
    public boolean method_25406(class_11909 event) {
        if (this.menu != null && this.menu.method_25406(event))
            return true;
        return super.method_25406(event);
    }
    
    @Override
    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.menu != null && this.menu.method_25401(mouseX, mouseY, amountX, amountY))
            return true;
        return super.method_25401(mouseX, mouseY, amountX, amountY);
    }
    
    @Override
    public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
        if (this.menu != null && this.menu.method_25403(event, deltaX, deltaY))
            return true;
        return super.method_25403(event, deltaX, deltaY);
    }
}
