/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.config.entries;

import com.google.common.base.Suppliers;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleType;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContextType;
import me.shedaniel.rei.impl.client.entry.filtering.rules.ManualFilteringRule;
import me.shedaniel.rei.impl.client.entry.filtering.rules.SearchFilteringRuleType;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.screen.generic.OptionEntriesScreen;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import me.shedaniel.rei.impl.common.entry.type.FilteringLogic;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_11909;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class FilteringRulesScreen extends class_437 {
    private final FilteringScreen filteringScreen;
    private final List<FilteringRule<?>> rules;
    private RulesList rulesList;
    public class_437 parent;
    
    public FilteringRulesScreen(FilteringScreen filteringScreen, List<FilteringRule<?>> rules) {
        super(class_2561.method_43471("config.roughlyenoughitems.filteringRulesScreen"));
        this.filteringScreen = filteringScreen;
        this.rules = rules;
    }
    
    @Override
    public void method_25426() {
        super.method_25426();
        {
            class_2561 backText = class_2561.method_43470("↩ ").method_10852(class_2561.method_43471("gui.back"));
            method_37063(new class_4185(4, 4, class_310.method_1551().field_1772.method_27525(backText) + 10, 20, backText, button -> {
                field_22787.method_1507(parent);
                this.parent = null;
            }, Supplier::get) {
            });
        }
        {
            class_2561 addText = class_2561.method_43470(" + ");
            method_37063(new class_4185(field_22789 - 4 - 20, 4, 20, 20, addText, button -> {
                FilteringAddRuleScreen screen = new FilteringAddRuleScreen(rules);
                screen.parent = this;
                field_22787.method_1507(screen);
            }, Supplier::get) {
            });
        }
        rulesList = method_25429(new RulesList(field_22787, field_22789, field_22790, 30, field_22790));
        for (int i = rules.size() - 1; i >= 0; i--) {
            FilteringRule<?> rule = rules.get(i);
            if (rule instanceof ManualFilteringRule)
                rulesList.addItem(new DefaultRuleEntry(rule, rules, (screen) -> {
                    filteringScreen.parent = screen;
                    return filteringScreen;
                }));
            else rulesList.addItem(new DefaultRuleEntry(rule, rules, null));
        }
        rulesList.selectItem(rulesList.method_25396().get(0));
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.rulesList.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_35720(this.field_22793, this.field_22785.method_30937(), (int) (this.field_22789 / 2.0F - this.field_22793.method_27525(this.field_22785) / 2.0F), 12, -1);
    }
    
    @Override
    public void method_25419() {
        this.field_22787.method_1507(parent);
    }
    
    public static class RulesList extends UpdatedListWidget<RuleEntry> {
        private boolean inFocus;
        
        public RulesList(class_310 client, int width, int height, int top, int bottom) {
            super(client, width, height, top, bottom);
        }
        
        @Override
        protected boolean isSelected(int index) {
            return Objects.equals(this.getSelectedItem(), this.method_25396().get(index));
        }
        
        @Override
        protected int addItem(RuleEntry item) {
            return super.addItem(item);
        }
        
        @Override
        public boolean method_25402(class_11909 event, boolean doubleClick) {
            if (super.method_25402(event, doubleClick))
                return true;
            RuleEntry item = getItemAtPosition(event.comp_4798(), event.comp_4799());
            if (item != null) {
                client.method_1483().method_4873(class_1109.method_47978(class_3417.field_15015, 1.0F));
                selectItem(item);
                this.method_25395(item);
                this.method_25398(true);
                return true;
            }
            return false;
        }
        
        @Override
        public int getItemWidth() {
            return width - 40;
        }
        
        @Override
        protected int getScrollbarPosition() {
            return width - 14;
        }
    }
    
    public static abstract class RuleEntry extends UpdatedListWidget.ElementEntry<RuleEntry> {
        private final FilteringRule<?> rule;
        
        public RuleEntry(FilteringRule<?> rule) {
            this.rule = rule;
        }
        
        public FilteringRule<?> getRule() {
            return rule;
        }
        
        @Override
        public int getItemHeight() {
            return 26;
        }
    }
    
    public static class DefaultRuleEntry extends RuleEntry {
        private final class_4185 configureButton;
        private final class_4185 deleteButton;
        private final Function<class_437, class_437> screenFunction;
        
        public DefaultRuleEntry(FilteringRule<?> rule, List<FilteringRule<?>> rules, Function<class_437, class_437> screenFunction) {
            super(rule);
            this.screenFunction = Objects.requireNonNullElseGet(screenFunction == null ? ((FilteringRuleType<FilteringRule<?>>) rule.getType()).createEntryScreen(rule) : screenFunction, () -> placeholderScreen(rule));
            configureButton = new class_4185(0, 0, 20, 20, class_2561.method_30163(null), button -> {
                class_310.method_1551().method_1507(this.screenFunction.apply(class_310.method_1551().field_1755));
            }, Supplier::get) {
                @Override
                public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
                    super.method_48579(graphics, mouseX, mouseY, delta);
                    graphics.method_25290(class_10799.field_56883, InternalTextures.CHEST_GUI_TEXTURE, method_46426() + 3, method_46427() + 3, 0, 0, 14, 14, 256, 256);
                }
            };
            {
                class_2561 deleteText = class_2561.method_43471("config.roughlyenoughitems.filteringRulesScreen.delete");
                deleteButton = new class_4185(0, 0, class_310.method_1551().field_1772.method_27525(deleteText) + 10, 20, deleteText, button -> {
                    final class_437 screen = class_310.method_1551().field_1755;
                    rules.remove(rule);
                    screen.method_25423(class_310.method_1551(), screen.field_22789, screen.field_22790);
                }, Supplier::get) {
                };
            }
            configureButton.field_22763 = this.screenFunction != null;
            deleteButton.field_22763 = !rule.getType().isSingular();
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            class_310 client = class_310.method_1551();
            {
                class_2561 title = ((FilteringRuleType<FilteringRule<?>>) getRule().getType()).getTitle(getRule());
                int i = client.field_1772.method_27525(title);
                if (i > entryWidth - 28) {
                    class_5348 titleTrimmed = class_5348.method_29433(client.field_1772.method_1714(title, entryWidth - 28 - client.field_1772.method_1727("...")), class_5348.method_29430("..."));
                    graphics.method_35720(client.field_1772, class_2477.method_10517().method_30934(titleTrimmed), x + 2, y + 1, 16777215);
                } else {
                    graphics.method_35720(client.field_1772, title.method_30937(), x + 2, y + 1, 16777215);
                }
            }
            {
                class_2561 subtitle = ((FilteringRuleType<FilteringRule<?>>) getRule().getType()).getSubtitle(getRule());
                int i = client.field_1772.method_27525(subtitle);
                if (i > entryWidth - 28) {
                    class_5348 subtitleTrimmed = class_5348.method_29433(client.field_1772.method_1714(subtitle, entryWidth - 28 - client.field_1772.method_1727("...")), class_5348.method_29430("..."));
                    graphics.method_35720(client.field_1772, class_2477.method_10517().method_30934(subtitleTrimmed), x + 2, y + 12, 8421504);
                } else {
                    graphics.method_35720(client.field_1772, subtitle.method_30937(), x + 2, y + 12, 8421504);
                }
            }
            configureButton.method_46421(x + entryWidth - 25);
            configureButton.method_46419(y + 1);
            configureButton.method_25394(graphics, mouseX, mouseY, delta);
            deleteButton.method_46421(x + entryWidth - 27 - deleteButton.method_25368());
            deleteButton.method_46419(y + 1);
            deleteButton.method_25394(graphics, mouseX, mouseY, delta);
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Arrays.asList(configureButton, deleteButton);
        }
        
        @Override
        public List<? extends class_6379> narratables() {
            return Arrays.asList(configureButton, deleteButton);
        }
    }
    
    private static <Cache> Function<class_437, class_437> placeholderScreen(FilteringRule<Cache> r) {
        class PlaceholderScreen extends OptionEntriesScreen {
            public PlaceholderScreen(class_437 parent) {
                super(class_2561.method_43471("config.roughlyenoughitems.filteringRulesScreen"), parent);
            }
            
            @Override
            public void addEntries(Consumer<ListEntry> entryConsumer) {
                addEmpty(entryConsumer, 10);
                Function<Boolean, class_2561> function = bool -> {
                    return class_2561.method_43471("rule.roughlyenoughitems.filtering.search.show." + bool);
                };
                Map<FilteringContextType, Set<HashedEntryStackWrapper>> stacks = FilteringLogic.hidden(List.of(r), false, false, EntryRegistry.getInstance().getEntryStacks().collect(Collectors.toList()));
                
                entryConsumer.accept(new SubListEntry(() -> function.apply(true),
                        Collections.singletonList(new SearchFilteringRuleType.EntryStacksRuleEntry(
                                Suppliers.ofInstance(CollectionUtils.map(stacks.get(FilteringContextType.SHOWN),
                                        stack -> (EntryWidget) Widgets.createSlot(new Rectangle(0, 0, 18, 18)).disableBackground().entry(stack.unwrap().normalize())))))));
                addEmpty(entryConsumer, 10);
                entryConsumer.accept(new SubListEntry(() -> function.apply(false),
                        Collections.singletonList(new SearchFilteringRuleType.EntryStacksRuleEntry(
                                Suppliers.ofInstance(CollectionUtils.map(stacks.get(FilteringContextType.HIDDEN),
                                        stack -> (EntryWidget) Widgets.createSlot(new Rectangle(0, 0, 18, 18)).disableBackground().entry(stack.unwrap().normalize())))))));
            }
            
            @Override
            public void save() {
            }
        }
        return PlaceholderScreen::new;
    }
}
