/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.config.entries;

import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import net.minecraft.class_1109;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import java.util.*;
import java.util.function.Supplier;

public class ConfigureCategoriesScreen extends class_437 {
    private final Map<CategoryIdentifier<?>, Boolean> filteringQuickCraftCategories;
    private final Set<CategoryIdentifier<?>> hiddenCategories;
    private final List<CategoryIdentifier<?>> categoryOrdering;
    private ListWidget listWidget;
    public Runnable editedSink = () -> {
    };
    public class_437 parent;
    
    public ConfigureCategoriesScreen(Map<CategoryIdentifier<?>, Boolean> filteringQuickCraftCategories, Set<CategoryIdentifier<?>> hiddenCategories, List<CategoryIdentifier<?>> categoryOrdering) {
        super(class_2561.method_43471("config.roughlyenoughitems.configureCategories.title"));
        this.filteringQuickCraftCategories = filteringQuickCraftCategories;
        this.hiddenCategories = hiddenCategories;
        this.categoryOrdering = categoryOrdering;
        for (CategoryRegistry.CategoryConfiguration<?> configuration : CategoryRegistry.getInstance()) {
            if (!this.categoryOrdering.contains(configuration.getCategoryIdentifier())) {
                this.categoryOrdering.add(configuration.getCategoryIdentifier());
            }
        }
    }
    
    public Map<CategoryIdentifier<?>, Boolean> getFilteringQuickCraftCategories() {
        return filteringQuickCraftCategories;
    }
    
    public Set<CategoryIdentifier<?>> getHiddenCategories() {
        return hiddenCategories;
    }
    
    public List<CategoryIdentifier<?>> getCategoryOrdering() {
        return categoryOrdering;
    }
    
    @Override
    public void method_25426() {
        super.method_25426();
        {
            class_2561 backText = class_2561.method_43470("↩ ").method_10852(class_2561.method_43471("gui.back"));
            method_37063(new class_4185(4, 4, class_310.method_1551().field_1772.method_27525(backText) + 10, 20, backText, button -> {
                field_22787.method_1507(parent);
                this.parent = null;
            }, Supplier::get) {
            });
        }
        listWidget = method_25429(new ListWidget(field_22787, field_22789, field_22790, 30, field_22790));
        this.resetListEntries();
    }
    
    public void resetListEntries() {
        listWidget.method_25396().clear();
        List<CategoryRegistry.CategoryConfiguration<?>> configurations = new ArrayList<>(CategoryRegistry.getInstance().stream().toList());
        configurations.sort(Comparator.comparingInt(o -> {
            int indexOf = categoryOrdering.indexOf(o.getCategoryIdentifier());
            return indexOf == -1 ? Integer.MAX_VALUE : indexOf;
        }));
        for (CategoryRegistry.CategoryConfiguration<?> configuration : configurations) {
            listWidget.addItem(new DefaultListEntry(configuration));
        }
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.listWidget.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_35720(this.field_22793, this.field_22785.method_30937(), (int) (this.field_22789 / 2.0F - this.field_22793.method_27525(this.field_22785) / 2.0F), 12, -1);
    }
    
    @Override
    public void method_25419() {
        this.field_22787.method_1507(parent);
    }
    
    private static class ListWidget extends UpdatedListWidget<ListEntry> {
        private boolean inFocus;
        
        public ListWidget(class_310 client, int width, int height, int top, int bottom) {
            super(client, width, height, top, bottom);
        }
        
        @Override
        protected boolean isSelected(int index) {
            return false;
        }
        
        @Override
        public ListEntry getSelectedItem() {
            return null;
        }
        
        @Override
        protected int addItem(ListEntry item) {
            return super.addItem(item);
        }
        
        @Override
        public boolean method_25402(class_11909 event, boolean doubleClick) {
            if (super.method_25402(event, doubleClick))
                return true;
            ListEntry item = getItemAtPosition(event.comp_4798(), event.comp_4799());
            if (item != null) {
                client.method_1483().method_4873(class_1109.method_47978(class_3417.field_15015, 1.0F));
                selectItem(item);
                this.method_25395(item);
                this.method_25398(true);
                return true;
            }
            return false;
        }
        
        @Override
        public int getItemWidth() {
            return width - 40;
        }
        
        @Override
        protected int getScrollbarPosition() {
            return width - 14;
        }
    }
    
    private static abstract class ListEntry extends UpdatedListWidget.ElementEntry<ListEntry> {
        @Override
        public int getItemHeight() {
            return 45;
        }
    }
    
    private class DefaultListEntry extends ListEntry {
        private final Label visibilityToggleButton, quickCraftToggleButton;
        private final class_4185 upButton, downButton;
        private final CategoryRegistry.CategoryConfiguration<?> configuration;
        
        public DefaultListEntry(CategoryRegistry.CategoryConfiguration<?> configuration) {
            this.configuration = configuration;
            {
                class_2561 toggleText = class_2561.method_43471("config.roughlyenoughitems.filtering.filteringQuickCraftCategories.configure.toggle");
                visibilityToggleButton = Widgets.createClickableLabel(new Point(), toggleText, $ -> {
                    boolean enabled = !hiddenCategories.contains(configuration.getCategoryIdentifier());
                    if (enabled) {
                        // set to false
                        hiddenCategories.add(configuration.getCategoryIdentifier());
                    } else {
                        // set to true
                        hiddenCategories.remove(configuration.getCategoryIdentifier());
                    }
                    
                    editedSink.run();
                }).leftAligned();
                quickCraftToggleButton = Widgets.createClickableLabel(new Point(), toggleText, $ -> {
                    boolean quickCraftingEnabledByDefault = configuration.isQuickCraftingEnabledByDefault();
                    boolean enabled = filteringQuickCraftCategories.getOrDefault(configuration.getCategoryIdentifier(), quickCraftingEnabledByDefault);
                    if (enabled) {
                        // set to false
                        if (!quickCraftingEnabledByDefault) {
                            filteringQuickCraftCategories.remove(configuration.getCategoryIdentifier());
                        } else {
                            filteringQuickCraftCategories.put(configuration.getCategoryIdentifier(), false);
                        }
                    } else {
                        // set to true
                        if (quickCraftingEnabledByDefault) {
                            filteringQuickCraftCategories.remove(configuration.getCategoryIdentifier());
                        } else {
                            filteringQuickCraftCategories.put(configuration.getCategoryIdentifier(), true);
                        }
                    }
                    
                    editedSink.run();
                }).leftAligned();
            }
            {
                this.upButton = new class_4185(0, 0, 20, 20, class_2561.method_43470("↑"), button -> {
                    int index = categoryOrdering.indexOf(configuration.getCategoryIdentifier());
                    if (index > 0) {
                        categoryOrdering.remove(index);
                        categoryOrdering.add(index - 1, configuration.getCategoryIdentifier());
                        editedSink.run();
                        resetListEntries();
                    }
                }, Supplier::get) {
                };
                this.downButton = new class_4185(0, 0, 20, 20, class_2561.method_43470("↓"), button -> {
                    int index = categoryOrdering.indexOf(configuration.getCategoryIdentifier());
                    if (index < categoryOrdering.size() - 1) {
                        categoryOrdering.remove(index);
                        categoryOrdering.add(index + 1, configuration.getCategoryIdentifier());
                        editedSink.run();
                        resetListEntries();
                    }
                }, Supplier::get) {
                };
                this.upButton.field_22763 = categoryOrdering.indexOf(configuration.getCategoryIdentifier()) > 0;
                this.downButton.field_22763 = categoryOrdering.indexOf(configuration.getCategoryIdentifier()) < categoryOrdering.size() - 1;
            }
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            if (y + entryHeight < 0 || y > field_22790) {
                return;
            }
            
            class_310 client = class_310.method_1551();
            configuration.getCategory().getIcon().render(graphics, new Rectangle(x + 2, y, 16, 16), mouseY, mouseY, delta);
            int xPos = x + 22;
            {
                class_2561 title = configuration.getCategory().getTitle();
                int i = client.field_1772.method_27525(title);
                if (i > entryWidth - 28) {
                    class_5348 titleTrimmed = class_5348.method_29433(client.field_1772.method_1714(title, entryWidth - 28 - client.field_1772.method_1727("...")), class_5348.method_29430("..."));
                    graphics.method_35720(client.field_1772, class_2477.method_10517().method_30934(titleTrimmed), x + 2, y + 1, 16777215);
                } else {
                    graphics.method_35720(client.field_1772, title.method_30937(), xPos, y + 1, 16777215);
                }
            }
            {
                class_2561 id = class_2561.method_43470(configuration.getCategoryIdentifier().toString())
                        .method_27692(class_124.field_1063);
                int i = client.field_1772.method_27525(id);
                if (i > entryWidth - 28) {
                    class_5348 idTrimmed = class_5348.method_29433(client.field_1772.method_1714(id, entryWidth - 28 - client.field_1772.method_1727("...")), class_5348.method_29430("..."));
                    graphics.method_35720(client.field_1772, class_2477.method_10517().method_30934(idTrimmed), x + 2, y + 12, 8421504);
                } else {
                    graphics.method_35720(client.field_1772, id.method_30937(), xPos, y + 12, 8421504);
                }
            }
            boolean shown = !hiddenCategories.contains(configuration.getCategoryIdentifier());
            {
                class_2561 subtitle = class_2561.method_43471("config.roughlyenoughitems.configureCategories.visibility." + shown)
                        .method_27692(shown ? class_124.field_1060 : class_124.field_1061);
                graphics.method_27535(client.field_1772, subtitle, xPos, y + 22, 8421504);
                int i = xPos + client.field_1772.method_27525(subtitle);
                visibilityToggleButton.getPoint().setLocation(i + 3, y + 22);
                visibilityToggleButton.method_25394(graphics, mouseX, mouseY, delta);
            }
            if (shown) {
                class_2561 subtitle = class_2561.method_43471("config.roughlyenoughitems.filtering.filteringQuickCraftCategories.configure." + filteringQuickCraftCategories.getOrDefault(configuration.getCategoryIdentifier(), configuration.isQuickCraftingEnabledByDefault()))
                        .method_27692(class_124.field_1080);
                graphics.method_27535(client.field_1772, subtitle, xPos, y + 32, 8421504);
                int i = xPos + client.field_1772.method_27525(subtitle);
                quickCraftToggleButton.getPoint().setLocation(i + 3, y + 32);
                quickCraftToggleButton.method_25394(graphics, mouseX, mouseY, delta);
            } else {
                quickCraftToggleButton.getPoint().setLocation(-12390, -12390);
            }
            upButton.method_46421(x + entryWidth - 20);
            upButton.method_46419(y + entryHeight / 2 - 21);
            upButton.method_25394(graphics, mouseX, mouseY, delta);
            downButton.method_46421(x + entryWidth - 20);
            downButton.method_46419(y + entryHeight / 2 + 1);
            downButton.method_25394(graphics, mouseX, mouseY, delta);
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return List.of(visibilityToggleButton, quickCraftToggleButton, upButton, downButton);
        }
        
        @Override
        public List<? extends class_6379> narratables() {
            return List.of();
        }
    }
}
