/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.type;

import com.google.common.base.Stopwatch;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.AbstractLongList;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContextType;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryList;
import me.shedaniel.rei.impl.common.entry.type.FilteredEntryList;
import me.shedaniel.rei.impl.common.entry.type.FilteringLogic;
import me.shedaniel.rei.impl.common.util.HNEntryStackWrapper;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import org.jetbrains.annotations.Nullable;

public class PreFilteredEntryList
implements FilteredEntryList {
    private final EntryRegistry registry;
    private final EntryRegistryList list;
    private final Map<FilteringRule<?>, DataPair> filteringData = new HashMap();
    private final Long2BooleanMap cached = new Long2BooleanOpenHashMap();
    private final List<HNEntryStackWrapper> listView = new InternalListView();
    private final List<EntryStack<?>> simpleListView = new InternalSimpleListView(this.listView);
    private long mod = 0L;

    public PreFilteredEntryList(EntryRegistry registry, EntryRegistryList list) {
        this.registry = registry;
        this.list = list;
    }

    @Override
    public void addEntryAfter(@Nullable EntryStack<?> afterEntry, EntryStack<?> stack, long stackHashExact) {
        if (!this.registry.isReloading()) {
            this.refreshFilteringFor(null, List.of(stack), (LongCollection)LongList.of((long)stackHashExact));
        }
    }

    @Override
    public void addEntriesAfter(@Nullable EntryStack<?> afterEntry, List<EntryStack<?>> stacks, @Nullable LongList hashes) {
        if (!this.registry.isReloading()) {
            this.refreshFilteringFor(null, stacks, (LongCollection)hashes);
        }
    }

    @Override
    public void removeEntry(EntryStack<?> stack, long hashExact) {
        if (!this.registry.isReloading()) {
            this.removeFilteringFor(List.of(stack), LongList.of((long)hashExact));
        }
    }

    @Override
    public void removeEntries(List<EntryStack<?>> stacks, @Nullable LongList hashes) {
        if (!this.registry.isReloading()) {
            this.removeFilteringFor(stacks, hashes);
        }
    }

    @Override
    public void onReFilter(final List<HNEntryStackWrapper> stacks) {
        ConfigObject config = ConfigObject.getInstance();
        if (config.getFilteredStackProviders() != null) {
            List normalizedFilteredStacks = CollectionUtils.map((Collection)config.getFilteredStackProviders(), EntryStackProvider::provide);
            normalizedFilteredStacks.removeIf(EntryStack::isEmpty);
            config.getFilteredStackProviders().clear();
            config.getFilteredStackProviders().addAll(CollectionUtils.map((Collection)normalizedFilteredStacks, EntryStackProvider::ofStack));
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.refreshFilteringFor(true, null, Lists.transform(stacks, HashedEntryStackWrapper::unwrap), (LongCollection)new AbstractLongList(this){

            public long getLong(int index) {
                return ((HNEntryStackWrapper)stacks.get(index)).hashExact();
            }

            public int size() {
                return stacks.size();
            }
        });
        InternalLogger.getInstance().debug("Refiltered %d entries with %d rules in %s.", new Object[]{stacks.size(), FilteringLogic.getRules().size(), stopwatch.stop().toString()});
    }

    private void queueSearchUpdate() {
        REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadSearch);
    }

    @Override
    public void refreshFilteringFor(@Nullable Set<FilteringRule<?>> refilterRules, Collection<EntryStack<?>> stack, @Nullable LongCollection hashes) {
        this.refreshFilteringFor(false, refilterRules, stack, hashes);
    }

    @Override
    public void refreshFilteringFor(boolean log, @Nullable Set<FilteringRule<?>> refilterRules, Collection<EntryStack<?>> stacks, @Nullable LongCollection hashes) {
        ++this.mod;
        if (hashes == null) {
            hashes = new LongArrayList(stacks.size());
            for (EntryStack<?> stack : stacks) {
                hashes.add(EntryStacks.hashExact(stack));
            }
        }
        LongIterator hashIterator = hashes.iterator();
        while (hashIterator.hasNext()) {
            long hash = hashIterator.nextLong();
            this.cached.remove(hash);
        }
        List<FilteringRule<?>> rules = FilteringLogic.getRules();
        for (int i = rules.size() - 1; i >= 0; --i) {
            boolean refilter;
            FilteringRule<?> rule = rules.get(i);
            if (!this.filteringData.containsKey(rule)) {
                this.filteringData.put(rule, new DataPair());
            }
            DataPair longPair = this.filteringData.get(rule);
            LongSet hidden = longPair.hidden();
            LongSet shown = longPair.shown();
            boolean bl = refilter = refilterRules == null || refilterRules.contains(rule);
            if (refilter) {
                if (!hidden.isEmpty()) {
                    hidden.removeAll(hashes);
                    ++this.mod;
                }
                if (!shown.isEmpty()) {
                    shown.removeAll(hashes);
                    ++this.mod;
                }
                Map<FilteringContextType, Set<HashedEntryStackWrapper>> map = FilteringLogic.hidden(List.of(rule), log, true, stacks);
                Set<HashedEntryStackWrapper> hiddenWrappers = map.get((Object)FilteringContextType.HIDDEN);
                Set<HashedEntryStackWrapper> shownWrappers = map.get((Object)FilteringContextType.SHOWN);
                for (HashedEntryStackWrapper stack : hiddenWrappers) {
                    hidden.add(stack.hashExact());
                    this.cached.put(stack.hashExact(), false);
                }
                for (HashedEntryStackWrapper stack : shownWrappers) {
                    shown.add(stack.hashExact());
                    this.cached.put(stack.hashExact(), true);
                }
                if (hiddenWrappers.isEmpty() && shownWrappers.isEmpty()) continue;
                ++this.mod;
                continue;
            }
            hashIterator = hashes.iterator();
            while (hashIterator.hasNext()) {
                long hash = hashIterator.nextLong();
                if (hidden.contains(hash)) {
                    this.cached.put(hash, false);
                    ++this.mod;
                    continue;
                }
                if (!shown.contains(hash)) continue;
                this.cached.put(hash, true);
                ++this.mod;
            }
        }
        this.queueSearchUpdate();
    }

    private void removeFilteringFor(List<EntryStack<?>> stacks, @Nullable LongList hashes) {
        if (hashes == null) {
            hashes = new LongArrayList(stacks.size());
            for (EntryStack<?> stack : stacks) {
                hashes.add(EntryStacks.hashExact(stack));
            }
        }
        this.removeFilteringFor(hashes);
    }

    private void removeFilteringFor(LongList hashes) {
        for (DataPair value : this.filteringData.values()) {
            value.hidden().removeAll((LongCollection)hashes);
            value.shown().removeAll((LongCollection)hashes);
        }
        LongListIterator hashIterator = hashes.iterator();
        while (hashIterator.hasNext()) {
            long hash = hashIterator.nextLong();
            this.cached.remove(hash);
        }
        ++this.mod;
    }

    @Override
    public List<HNEntryStackWrapper> getList() {
        return this.listView;
    }

    @Override
    public List<EntryStack<?>> getUnwrappedList() {
        return this.simpleListView;
    }

    @Override
    public boolean isFiltered(EntryStack<?> stack, long hashExact) {
        return !stack.isEmpty() && this.cached.getOrDefault(hashExact, true);
    }

    private class InternalListView
    extends AbstractList<HNEntryStackWrapper> {
        private long prevMod = -1L;
        private List<HNEntryStackWrapper> stacks;

        private InternalListView() {
        }

        @Override
        public HNEntryStackWrapper get(int index) {
            if (this.prevMod == PreFilteredEntryList.this.mod) {
                return this.stacks.get(index);
            }
            if (index < PreFilteredEntryList.this.list.size() / 5) {
                return (HNEntryStackWrapper)Iterators.get(this.iterator(), (int)index);
            }
            this.stacks = Lists.newArrayList(this.iterator());
            this.prevMod = PreFilteredEntryList.this.mod;
            return this.stacks.get(index);
        }

        @Override
        public int size() {
            if (this.prevMod != PreFilteredEntryList.this.mod) {
                this.stacks = Lists.newArrayList(this.iterator());
                this.prevMod = PreFilteredEntryList.this.mod;
            }
            return this.stacks.size();
        }

        @Override
        public Iterator<HNEntryStackWrapper> iterator() {
            if (this.prevMod == PreFilteredEntryList.this.mod) {
                return this.stacks.iterator();
            }
            final Iterator<HNEntryStackWrapper> iterator = PreFilteredEntryList.this.list.collectHN().iterator();
            return new AbstractIterator<HNEntryStackWrapper>(){

                @Nullable
                protected HNEntryStackWrapper computeNext() {
                    while (iterator.hasNext()) {
                        HNEntryStackWrapper wrapper = (HNEntryStackWrapper)iterator.next();
                        if (!PreFilteredEntryList.this.isFiltered(wrapper.unwrap(), wrapper.hashExact())) continue;
                        return wrapper;
                    }
                    return (HNEntryStackWrapper)this.endOfData();
                }
            };
        }
    }

    private static class InternalSimpleListView
    extends AbstractList<EntryStack<?>> {
        private final List<HNEntryStackWrapper> list;

        public InternalSimpleListView(List<HNEntryStackWrapper> list) {
            this.list = list;
        }

        @Override
        public EntryStack<?> get(int i) {
            return this.list.get(i).unwrap();
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public Iterator<EntryStack<?>> iterator() {
            final Iterator<HNEntryStackWrapper> iterator = this.list.iterator();
            return new Iterator<EntryStack<?>>(this){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public EntryStack<?> next() {
                    return ((HNEntryStackWrapper)iterator.next()).unwrap();
                }
            };
        }
    }

    private record DataPair(LongSet hidden, LongSet shown) {
        private DataPair() {
            this((LongSet)new LongOpenHashSet(), (LongSet)new LongOpenHashSet());
        }
    }
}

