/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.ForwardingList;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.widget.DelegateWidgetWithTranslate;
import org.joml.Matrix3x2f;

public class VStackWidget {
    public static <T extends WidgetWithBounds> Builder<T> builder(int x, int y) {
        return VStackWidget.builder(new Point(x, y));
    }

    public static <T extends WidgetWithBounds> Builder<T> builder(Point point) {
        return new Builder(point);
    }

    public static <T extends WidgetWithBounds> WidgetWithBounds create(Point point, List<T> entries, int gap, boolean calculateWidthDynamically, boolean calculateTotalHeightDynamically) {
        Rectangle bounds = new Rectangle(point.x, point.y, VStackWidget.collectMaximumWidth(entries), VStackWidget.collectTotalHeight(entries, gap));
        List wrapped = CollectionUtils.map(entries, CellWidget::new);
        Widget update = Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
            if (calculateWidthDynamically) {
                bounds.width = VStackWidget.collectMaximumWidth(entries);
            }
            if (calculateTotalHeightDynamically) {
                bounds.height = VStackWidget.collectTotalHeight(entries, gap);
            }
            bounds.move(point.x, point.y);
            int y = bounds.y;
            for (CellWidget cell : wrapped) {
                cell.position.move(bounds.x, y);
                y += (calculateTotalHeightDynamically ? cell.getBounds().getHeight() : cell.height) + gap;
            }
        });
        ArrayList<Widget> innerWidgets = new ArrayList<Widget>();
        innerWidgets.add(update);
        innerWidgets.addAll(wrapped);
        return Widgets.concatWithBounds((Rectangle)bounds, innerWidgets);
    }

    private static int collectMaximumWidth(List<? extends WidgetWithBounds> cells) {
        int width = 0;
        for (WidgetWithBounds widgetWithBounds : cells) {
            width = Math.max(width, widgetWithBounds.getBounds().getWidth());
        }
        return width;
    }

    private static int collectTotalHeight(List<? extends WidgetWithBounds> cells, int gap) {
        int height = Math.max(0, (cells.size() - 1) * gap);
        for (WidgetWithBounds widgetWithBounds : cells) {
            height += widgetWithBounds.getBounds().getHeight();
        }
        return height;
    }

    public static class Builder<T extends WidgetWithBounds>
    extends ForwardingList<T> {
        private final Point point;
        private final List<T> entries = new ArrayList<T>();
        private int gap;
        private boolean calculateWidthDynamically = false;
        private boolean calculateTotalHeightDynamically = false;

        public Builder(Point point) {
            this.point = point;
        }

        protected List<T> delegate() {
            return this.entries;
        }

        public Builder<T> gap(int gap) {
            this.gap = gap;
            return this;
        }

        public Builder<T> calculateWidthDynamically() {
            this.calculateWidthDynamically = true;
            return this;
        }

        public Builder<T> calculateTotalHeightDynamically() {
            this.calculateTotalHeightDynamically = true;
            return this;
        }

        public WidgetWithBounds build() {
            return VStackWidget.create(this.point, this.entries, this.gap, this.calculateWidthDynamically, this.calculateTotalHeightDynamically);
        }
    }

    private static class CellWidget<T>
    extends DelegateWidgetWithTranslate {
        private final Point position = new Point();
        private final int height;

        public CellWidget(WidgetWithBounds widget) {
            super(widget, Matrix3x2f::new);
            this.height = widget.getBounds().getHeight();
        }

        public WidgetWithBounds delegate() {
            return (WidgetWithBounds)super.delegate();
        }

        @Override
        protected Matrix3x2f translate() {
            Rectangle bounds = this.delegate().getBounds();
            return new Matrix3x2f().translate((float)(this.position.x - bounds.x), (float)(this.position.y - bounds.y));
        }
    }

    @FunctionalInterface
    public static interface ListEntryPredicate<T> {
        public boolean test(int var1, T var2);
    }

    @FunctionalInterface
    public static interface ListCellRenderer<T> {
        public WidgetWithBounds create(int var1, T var2);
    }
}

