/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.performance.entry;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.api.Expandable;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.impl.client.gui.performance.PerformanceScreen;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6880;

@Environment(value=EnvType.CLIENT)
public class SubCategoryListEntry
extends PerformanceScreen.PerformanceEntry
implements Expandable {
    private static final class_2960 CONFIG_TEX = class_2960.method_60655((String)"cloth-config2", (String)"textures/gui/cloth_config.png");
    private final List<PerformanceScreen.PerformanceEntry> entries;
    private final CategoryLabelWidget widget;
    private final List<class_364> children;
    private final class_2561 name;
    private final long totalTime;
    private boolean expanded;

    public SubCategoryListEntry(class_2561 name, List<PerformanceScreen.PerformanceEntry> entries, long totalTime, boolean defaultExpanded) {
        this.name = name;
        this.entries = entries;
        this.totalTime = totalTime;
        this.expanded = defaultExpanded;
        this.widget = new CategoryLabelWidget();
        this.children = Lists.newArrayList((Object[])new class_364[]{this.widget});
        this.children.addAll(entries);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        this.widget.rectangle.x = x + 3;
        this.widget.rectangle.y = y;
        this.widget.rectangle.width = entryWidth - 6;
        this.widget.rectangle.height = 24;
        graphics.method_25290(class_10799.field_56883, CONFIG_TEX, x + 3, y + 5, 24.0f, (float)((this.widget.rectangle.contains(mouseX, mouseY) ? 18 : 0) + (this.expanded ? 9 : 0)), 9, 9, 256, 256);
        graphics.method_35720(class_310.method_1551().field_1772, this.name.method_30937(), x + 3 + 15, y + 6, this.widget.rectangle.contains(mouseX, mouseY) ? -1638890 : -1);
        for (PerformanceScreen.PerformanceEntry performanceEntry : this.entries) {
            performanceEntry.setParent(this.getParent());
        }
        if (this.expanded) {
            int yy = y + 24;
            for (PerformanceScreen.PerformanceEntry entry : this.entries) {
                entry.render(graphics, -1, yy, x + 3 + 15, entryWidth - 15 - 3, entry.getItemHeight(), mouseX, mouseY, isHovered && this.method_25399() == entry, delta);
                yy += entry.getItemHeight();
            }
        }
        class_5481 timeText = PerformanceScreen.formatTime(this.totalTime, true);
        graphics.method_35720(class_310.method_1551().field_1772, timeText, x + entryWidth - 6 - 4 - class_310.method_1551().field_1772.method_30880(timeText), y + 6, -1);
    }

    public int getMorePossibleHeight() {
        if (!this.expanded) {
            return -1;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 24;
        for (PerformanceScreen.PerformanceEntry entry : this.entries) {
            i += entry.getItemHeight();
            if (entry.getMorePossibleHeight() < 0) continue;
            list.add(i + entry.getMorePossibleHeight());
        }
        list.add(i);
        return list.stream().max(Integer::compare).orElse(0) - this.getItemHeight();
    }

    public Rectangle getEntryArea(int x, int y, int entryWidth, int entryHeight) {
        this.widget.rectangle.x = x;
        this.widget.rectangle.y = y;
        this.widget.rectangle.width = entryWidth;
        this.widget.rectangle.height = 24;
        return new Rectangle(this.getParent().left, y, this.getParent().right - this.getParent().left, 20);
    }

    public int getItemHeight() {
        if (!this.expanded) {
            return 24;
        }
        int i = 24;
        for (PerformanceScreen.PerformanceEntry entry : this.entries) {
            i += entry.getItemHeight();
        }
        return i;
    }

    @Override
    public List<? extends class_364> method_25396() {
        return this.expanded ? this.children : Collections.singletonList(this.widget);
    }

    public List<? extends class_6379> narratables() {
        return Collections.emptyList();
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public class CategoryLabelWidget
    implements class_364 {
        private final Rectangle rectangle = new Rectangle();

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            if (this.rectangle.contains(event.comp_4798(), event.comp_4799())) {
                SubCategoryListEntry.this.expanded = !SubCategoryListEntry.this.expanded;
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                return true;
            }
            return false;
        }

        public void method_25365(boolean bl) {
        }

        public boolean method_25370() {
            return false;
        }
    }
}

