/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.type.collapsed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.collapsible.CollapsibleConfigManager;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class CollapsibleEntryRegistryImpl
implements CollapsibleEntryRegistry {
    private final Map<class_2960, Entry> entries = new LinkedHashMap<class_2960, Entry>();
    private final List<Entry> customEntries = new ArrayList<Entry>();

    public <T> void group(class_2960 id, class_2561 name, List<? extends EntryStack<? extends T>> stacks) {
        Objects.requireNonNull(stacks, "stacks");
        Entry old = this.entries.put(id, new Entry(id, name, new ListMatcher(CollectionUtils.map(stacks, HashedEntryStackWrapper::new)), true));
        InternalLogger.getInstance().debug("Added collapsible entry group [%s] %s with %d entries", new Object[]{id, name.getString(), stacks.size()});
        if (old != null) {
            InternalLogger.getInstance().warn("Overwritten collapsible entry group [%s] %s with %d entries", new Object[]{id, name.getString(), stacks.size()});
        }
        if (stacks.isEmpty()) {
            InternalLogger.getInstance().warn("Collapsible entry group [%s] %s has no entries, ignoring.", new Object[]{id, name.getString()});
            this.entries.remove(id);
        }
    }

    public void group(class_2960 id, class_2561 name, Predicate<? extends EntryStack<?>> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        Entry old = this.entries.put(id, new Entry(id, name, (stack, hashExact) -> predicate.test((EntryStack<?>)stack), false));
        InternalLogger.getInstance().debug("Added collapsible entry group [%s] %s with dynamic predicate", new Object[]{id, name.getString()});
        if (old != null) {
            InternalLogger.getInstance().warn("Overwritten collapsible entry group [%s] %s with dynamic predicate", new Object[]{id, name.getString()});
        }
    }

    public void startReload() {
        this.entries.clear();
    }

    public void endReload() {
        this.recollectCustomEntries();
        InternalLogger.getInstance().debug("Registered %d collapsible entry groups: %s", new Object[]{this.entries.values().size(), this.entries.values().stream().map(entry -> entry.getName().getString()).collect(Collectors.joining(", "))});
    }

    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerCollapsibleEntries((CollapsibleEntryRegistry)this);
    }

    public void recollectCustomEntries() {
        InternalLogger.getInstance().debug("Recollecting custom collapsible entry groups");
        this.customEntries.clear();
        for (CollapsibleConfigManager.CustomGroup customEntry : CollapsibleConfigManager.getInstance().getConfig().customGroups) {
            List stacks = CollectionUtils.filterAndMap(customEntry.stacks, EntryStackProvider::isValid, provider -> new HashedEntryStackWrapper(provider.provide()));
            Entry entry2 = new Entry(customEntry.id, (class_2561)class_2561.method_43470((String)customEntry.name), new ListMatcher(stacks), false);
            this.customEntries.add(entry2);
            InternalLogger.getInstance().debug("Added custom collapsible entry group [%s] %s with %d entries", new Object[]{entry2.getId(), entry2.getName().getString(), stacks.size()});
        }
        InternalLogger.getInstance().debug("Registered %d custom collapsible entry groups: ", new Object[]{this.customEntries.size(), this.customEntries.stream().map(entry -> entry.getName().getString()).collect(Collectors.joining(", "))});
    }

    public Collection<Entry> getEntries() {
        return this.entries.values();
    }

    public List<Entry> getCustomEntries() {
        return this.customEntries;
    }

    public static class Entry {
        private final class_2960 id;
        private final class_2561 name;
        private final Matcher matcher;
        private boolean canCache;
        private boolean expanded;

        public Entry(class_2960 id, class_2561 name, Matcher matcher, boolean canCache) {
            this.id = id;
            this.name = name;
            this.matcher = matcher;
            this.canCache = canCache;
        }

        public class_2960 getId() {
            return this.id;
        }

        public String getModId() {
            return this.id.method_12836();
        }

        public class_2561 getName() {
            return this.name;
        }

        public Matcher getMatcher() {
            return this.matcher;
        }

        public boolean canCache() {
            return this.canCache;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public void setExpanded(boolean expanded) {
            this.expanded = expanded;
        }
    }

    private static class ListMatcher
    implements Matcher {
        private final Set<HashedEntryStackWrapper> stacks;

        public ListMatcher(List<? extends HashedEntryStackWrapper> stacks) {
            this.stacks = new HashSet<HashedEntryStackWrapper>(stacks);
        }

        @Override
        public boolean matches(EntryStack<?> stack, long hashExact) {
            return this.stacks.contains(new HashedEntryStackWrapper(stack, hashExact));
        }
    }

    @FunctionalInterface
    public static interface Matcher {
        public boolean matches(EntryStack<?> var1, long var2);
    }
}

