/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.comparison;

import com.google.common.base.Predicates;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.EntryComparator;
import me.shedaniel.rei.impl.Internals;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9335;
import net.minecraft.class_9336;
import org.jetbrains.annotations.Nullable;

public enum NbtHasherProviderImpl implements Internals.NbtHasherProvider
{
    INSTANCE;

    private final EntryComparator<class_9323> defaultHasher = this._provide(new class_9331[0]);

    public EntryComparator<class_9323> provide(class_9331<?> ... ignoredKeys) {
        if (ignoredKeys == null || ignoredKeys.length == 0) {
            return this.defaultHasher;
        }
        return this._provide(ignoredKeys);
    }

    private EntryComparator<class_9323> _provide(class_9331<?> ... ignoredKeys) {
        return new Hasher(ignoredKeys);
    }

    private static class Hasher
    implements EntryComparator<class_9323> {
        @Nullable
        private final Predicate<class_9331<?>> filter;

        private Hasher(@Nullable class_9331<?>[] ignoredKeys) {
            if (ignoredKeys == null || ignoredKeys.length == 0) {
                this.filter = null;
            } else if (ignoredKeys.length == 1) {
                class_9331<?> s = ignoredKeys[0];
                this.filter = key -> !Objects.equals(s, key);
            } else {
                ReferenceOpenHashSet set = new ReferenceOpenHashSet(Arrays.asList(ignoredKeys));
                this.filter = Predicates.not(((Set)set)::contains);
            }
        }

        public long hash(ComparisonContext context, class_9323 value) {
            return this.filter == null && value instanceof class_9335 ? (long)value.hashCode() : this.hashIgnoringKeys(value);
        }

        private long hashIgnoringKeys(class_9323 tag) {
            long i = 1L;
            for (class_9336 entry : tag) {
                if (!this.filter.test(entry.comp_2443())) continue;
                i = i * 31L + (long)(Objects.hashCode(entry.comp_2443()) ^ Objects.hashCode(entry.comp_2444()));
            }
            return i;
        }
    }
}

