/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.entrylist;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchFieldLocation;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.CachedEntryListRender;
import me.shedaniel.rei.impl.client.gui.widget.DefaultDisplayChoosePageWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.CachingEntryRenderer;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.CollapsedEntriesBorderRenderer;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.CollapsingEntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListStackEntry;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsedStack;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;

public class PaginatedEntryListWidget
extends CollapsingEntryListWidget {
    private Button leftButton;
    private Button rightButton;
    private List<Widget> additionalWidgets;
    private List<Object> stacks = new ArrayList<Object>();
    private Object2IntMap<CollapsedStack> collapsedStackIndices = new Object2IntOpenHashMap();
    protected List<EntryListStackEntry> entries = Collections.emptyList();
    private int page;

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    @Override
    protected void renderEntries(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.leftButton.setEnabled(this.getTotalPages() > 1);
        this.rightButton.setEnabled(this.getTotalPages() > 1);
        if (ConfigObject.getInstance().doesCacheEntryRendering()) {
            for (EntryListStackEntry entry : this.entries) {
                CachedEntryListRender.Sprite sprite;
                CollapsedStack collapsedStack = entry.getCollapsedStack();
                if (collapsedStack != null && !collapsedStack.isExpanded() || entry.our != null || (sprite = CachedEntryListRender.get(entry.getCurrentEntry())) == null) continue;
                CachingEntryRenderer renderer = new CachingEntryRenderer(sprite);
                entry.our = entry.getCurrentEntry().copy().cast().withRenderer(stack -> renderer);
            }
        }
        EntryRendererManager<EntryListStackEntry> manager = new EntryRendererManager<EntryListStackEntry>(this.entries);
        manager.render(this.debugger.debugTime, this.debugger.size, this.debugger.time, graphics, mouseX, mouseY, delta);
        new CollapsedEntriesBorderRenderer().render(graphics, this.entries, this.collapsedStackIndices);
        for (Widget widget : this.additionalWidgets) {
            widget.method_25394(graphics, mouseX, mouseY, delta);
        }
    }

    public int getTotalPages() {
        return this.getTotalPages(this.entries);
    }

    public int getTotalPages(List<?> entries) {
        return class_3532.method_15386((float)((float)this.stacks.size() / (float)entries.size()));
    }

    @Override
    protected void updateEntries(int entrySize, boolean zoomed) {
        this.page = Math.max(this.page, 0);
        ArrayList entries = Lists.newArrayList();
        int width = this.innerBounds.width / entrySize;
        int height = this.innerBounds.height / entrySize;
        for (int currentY = 0; currentY < height; ++currentY) {
            for (int currentX = 0; currentX < width; ++currentX) {
                int slotX = currentX * entrySize + this.innerBounds.x;
                int slotY = currentY * entrySize + this.innerBounds.y;
                if (!PaginatedEntryListWidget.notSteppingOnExclusionZones(slotX - 1, slotY - 1, entrySize, entrySize)) continue;
                entries.add((EntryListStackEntry)new EntryListStackEntry(this, slotX, slotY, entrySize, zoomed).noBackground());
            }
        }
        this.page = class_3532.method_15340((int)this.page, (int)0, (int)(this.getTotalPages(entries) - 1));
        int skip = Math.max(0, this.page * entries.size());
        List<Object> subList = this.stacks.subList(skip, Math.min(this.stacks.size(), skip + entries.size()));
        Int2ObjectMap<CollapsedStack> indexedCollapsedStack = this.getCollapsedStackIndexed();
        LinkedHashSet<CollapsedStack> collapsedStacks = new LinkedHashSet<CollapsedStack>();
        for (int i = 0; i < subList.size(); ++i) {
            Object stack = subList.get(i);
            EntryListStackEntry entry = (EntryListStackEntry)((Object)entries.get(i + Math.max(0, -this.page * entries.size())));
            entry.clearStacks();
            if (stack instanceof EntryStack) {
                EntryStack entryStack = (EntryStack)stack;
                entry.entry(entryStack);
            } else {
                entry.entries((Collection)((List)stack));
            }
            CollapsedStack collapsedStack = (CollapsedStack)indexedCollapsedStack.get(i + skip);
            if (collapsedStack != null && collapsedStack.getIngredient().size() > 1) {
                entry.collapsed(collapsedStack);
                collapsedStacks.add(collapsedStack);
                continue;
            }
            entry.collapsed(null);
        }
        this.entries = entries;
        this.collapsedStackIndices = new Object2IntOpenHashMap();
        int index = 0;
        for (CollapsedStack stack : collapsedStacks) {
            this.collapsedStackIndices.put((Object)stack, index++);
        }
    }

    @Override
    public List<Object> getStacks() {
        return this.stacks;
    }

    @Override
    public void setStacks(List<Object> stacks) {
        this.stacks = stacks;
    }

    public Stream<EntryStack<?>> getEntries() {
        return this.entries.stream().map(EntryWidget::getCurrentEntry);
    }

    @Override
    protected List<EntryListStackEntry> getEntryWidgets() {
        return this.entries;
    }

    @Override
    public List<? extends Widget> method_25396() {
        return CollectionUtils.concatUnmodifiable((List[])new List[]{super.method_25396(), this.additionalWidgets});
    }

    @Override
    public void init(ScreenOverlayImpl overlay) {
        Rectangle overlayBounds = overlay.getBounds();
        this.additionalWidgets = new ArrayList<Widget>();
        this.leftButton = ((Button)Widgets.createButton((Rectangle)new Rectangle(overlayBounds.x, overlayBounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16), (class_2561)class_2561.method_43470((String)"")).onClick(button -> {
            this.setPage(this.getPage() - 1);
            if (this.getPage() < 0) {
                this.setPage(this.getTotalPages() - 1);
            }
            this.updateEntriesPosition();
        }).containsMousePredicate((button, point) -> button.getBounds().contains(point) && overlay.isNotInExclusionZones(point.x, point.y))).tooltipLine((class_2561)class_2561.method_43471((String)"text.rei.previous_page")).focusable(false);
        this.additionalWidgets.add((Widget)this.leftButton);
        this.additionalWidgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
            Rectangle bounds = this.leftButton.getBounds();
            graphics.method_25290(class_10799.field_56883, InternalTextures.ARROW_LEFT_TEXTURE, bounds.x + 4, bounds.y + 4, 0.0f, 0.0f, 8, 8, 8, 8);
        }));
        this.rightButton = ((Button)Widgets.createButton((Rectangle)new Rectangle(overlayBounds.getMaxX() - 18, overlayBounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16), (class_2561)class_2561.method_43471((String)"")).onClick(button -> {
            this.setPage(this.getPage() + 1);
            if (this.getPage() >= this.getTotalPages()) {
                this.setPage(0);
            }
            this.updateEntriesPosition();
        }).containsMousePredicate((button, point) -> button.getBounds().contains(point) && overlay.isNotInExclusionZones(point.x, point.y))).tooltipLine((class_2561)class_2561.method_43471((String)"text.rei.next_page")).focusable(false);
        this.additionalWidgets.add((Widget)this.rightButton);
        this.additionalWidgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
            Rectangle bounds = this.rightButton.getBounds();
            graphics.method_25290(class_10799.field_56883, InternalTextures.ARROW_RIGHT_TEXTURE, bounds.x + 4, bounds.y + 4, 0.0f, 0.0f, 8, 8, 8, 8);
        }));
        this.additionalWidgets.add((Widget)Widgets.createClickableLabel((Point)new Point(overlayBounds.x + overlayBounds.width / 2, overlayBounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 10), (class_2561)class_2561.method_43473(), label -> {
            if (!class_310.method_1551().method_74187()) {
                this.setPage(0);
                this.updateEntriesPosition();
            } else {
                ScreenOverlayImpl.getInstance().choosePageWidget = new DefaultDisplayChoosePageWidget(page -> {
                    this.setPage(page);
                    this.updateEntriesPosition();
                }, this.getPage(), this.getTotalPages());
            }
        }).tooltip(new class_2561[]{class_2561.method_43471((String)"text.rei.go_back_first_page"), class_2561.method_43470((String)" "), class_2561.method_43469((String)"text.rei.shift_click_to", (Object[])new Object[]{class_2561.method_43471((String)"text.rei.choose_page")}).method_27692(class_124.field_1080)}).focusable(false).onRender((matrices, label) -> {
            label.setClickable(this.getTotalPages() > 1);
            label.setMessage((class_5348)class_2561.method_43470((String)String.format("%s/%s", this.getPage() + 1, Math.max(this.getTotalPages(), 1))));
        }).rainbow((double)new Random().nextFloat() < 1.0E-4 || (Boolean)ClientHelperImpl.getInstance().isAprilFools.method_15332() != false || ConfigManagerImpl.getInstance().getConfig().appearance.rainbow));
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        if (super.method_25401(mouseX, mouseY, amountX, amountY)) {
            return true;
        }
        if (!class_310.method_1551().method_74188()) {
            if (amountY > 0.0 && this.leftButton.isEnabled()) {
                this.leftButton.onClick();
            } else if (amountY < 0.0 && this.rightButton.isEnabled()) {
                this.rightButton.onClick();
            } else {
                return false;
            }
            return true;
        }
        return false;
    }
}

