/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5632;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class QueuedTooltip
implements Tooltip {
    private Point location;
    private List<TooltipEntryImpl> entries;
    private EntryStack<?> stack = EntryStack.empty();
    @Nullable
    private class_2960 tooltipStyle;

    private QueuedTooltip(Point location, Collection<? extends Tooltip.Entry> entries) {
        this.location = location;
        if (this.location == null) {
            this.location = PointHelper.ofMouse();
        }
        this.entries = Lists.newArrayList(entries);
    }

    public static QueuedTooltip impl(Point location, Collection<Tooltip.Entry> text) {
        return new QueuedTooltip(location, text);
    }

    public int getX() {
        return this.location.x;
    }

    public int getY() {
        return this.location.y;
    }

    public List<Tooltip.Entry> entries() {
        return this.entries;
    }

    public Tooltip add(class_2561 text) {
        this.entries.add(new TooltipEntryImpl(text));
        return this;
    }

    public Tooltip add(class_5632 component) {
        this.entries.add(new TooltipEntryImpl(component));
        return this;
    }

    public void queue() {
        super.queue();
    }

    public Tooltip copy() {
        QueuedTooltip tooltip = new QueuedTooltip(this.location.clone(), this.entries);
        tooltip.withContextStack(this.getContextStack());
        return tooltip;
    }

    public EntryStack<?> getContextStack() {
        return this.stack;
    }

    public Tooltip withContextStack(EntryStack<?> stack) {
        this.stack = stack.copy();
        return this;
    }

    @Nullable
    public class_2960 getTooltipStyle() {
        return this.tooltipStyle;
    }

    public Tooltip withTooltipStyle(@Nullable class_2960 styleLocation) {
        this.tooltipStyle = styleLocation;
        return this;
    }

    public record TooltipEntryImpl(Object obj) implements Tooltip.Entry
    {
        public TooltipEntryImpl(Object obj) {
            this.obj = obj;
            if (!(obj instanceof class_2561) && !(obj instanceof class_5632)) {
                throw new IllegalArgumentException("obj must be a Component or TooltipComponent");
            }
        }

        public class_2561 getAsText() {
            return (class_2561)this.obj;
        }

        public boolean isText() {
            return this.obj instanceof class_2561;
        }

        public boolean isTooltipComponent() {
            return this.obj instanceof class_5632;
        }

        public class_5632 getAsTooltipComponent() {
            return (class_5632)this.obj;
        }
    }
}

