/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.runtime;

import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.Iterator;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.api.client.entry.filtering.FilteringContext;
import me.shedaniel.rei.api.client.entry.filtering.FilteringResult;
import me.shedaniel.rei.api.client.entry.filtering.FilteringResultFactory;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleType;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
@ApiStatus.Internal
public class HideIngredientsFromTagsPlugin
implements REIClientPlugin {
    private static final class_2960 HIDDEN_TAG = class_2960.method_60655((String)"c", (String)"hidden_from_recipe_viewers");

    static {
        FilteringRuleTypeRegistry.getInstance().register(class_2960.method_60655((String)"roughlyenoughitems", (String)"hidden_from_recipe_viewers"), (FilteringRuleType)HideTagsFilteringRuleType.INSTANCE);
        RoughlyEnoughItemsCoreClient.POST_UPDATE_TAGS.register(HideTagsFilteringRule.INSTANCE::markDirty);
    }

    private static enum HideTagsFilteringRuleType implements FilteringRuleType<HideTagsFilteringRule>
    {
        INSTANCE;


        public class_2487 saveTo(HideTagsFilteringRule rule, class_2487 tag) {
            return tag;
        }

        public HideTagsFilteringRule readFrom(class_2487 tag) {
            return HideTagsFilteringRule.INSTANCE;
        }

        public class_2561 getTitle(HideTagsFilteringRule rule) {
            return class_2561.method_43471((String)"rule.roughlyenoughitems.filtering.hide.tag");
        }

        public class_2561 getSubtitle(HideTagsFilteringRule rule) {
            return class_2561.method_43471((String)"rule.roughlyenoughitems.filtering.hide.tag.subtitle");
        }

        public HideTagsFilteringRule createNew() {
            return HideTagsFilteringRule.INSTANCE;
        }

        public boolean isSingular() {
            return true;
        }
    }

    private static enum HideTagsFilteringRule implements FilteringRule<Cache>
    {
        INSTANCE;

        private Cache cache;

        public FilteringRuleType<? extends FilteringRule<Cache>> getType() {
            return HideTagsFilteringRuleType.INSTANCE;
        }

        public Cache prepareCache(boolean async) {
            try {
                EntryIngredient ingredient = EntryIngredient.builder().addAll((Iterable)EntryIngredients.ofItemTag((class_6862)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)HIDDEN_TAG))).addAll((Iterable)EntryIngredients.ofItemTag((class_6862)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)HIDDEN_TAG))).addAll((Iterable)EntryIngredients.ofFluidTag((class_6862)class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)HIDDEN_TAG))).build();
                LongOpenHashSet hashes = new LongOpenHashSet();
                for (EntryStack stack : ingredient) {
                    hashes.add(EntryStacks.hashExact((EntryStack)stack));
                }
                this.cache = new Cache(ingredient, (LongSet)hashes);
                return this.cache;
            }
            catch (Throwable e) {
                InternalLogger.getInstance().warn("Failed to load hidden ingredients from tag, falling back to empty cache.", e);
                this.cache = null;
                return null;
            }
        }

        public FilteringResult processFilteredStacks(FilteringContext context, FilteringResultFactory resultFactory, Cache cache, boolean async) {
            FilteringResult result = resultFactory.create();
            if (cache != null) {
                this.process(result, context.getShownStacks(), context.getShownExactHashes(), cache);
                this.process(result, context.getUnsetStacks(), context.getUnsetExactHashes(), cache);
            }
            return result;
        }

        private void process(FilteringResult result, Collection<EntryStack<?>> stacks, LongCollection hashes, Cache cache) {
            Iterator<EntryStack<?>> stackIterator = stacks.iterator();
            LongIterator hashIterator = hashes.iterator();
            while (stackIterator.hasNext()) {
                EntryStack<?> stack = stackIterator.next();
                long hash = hashIterator.nextLong();
                if (!cache.hashes().contains(hash)) continue;
                result.hide(stack);
            }
        }

        private void markDirty() {
            InternalLogger.getInstance().debug("Marking hidden ingredients from tag cache as dirty.");
            if (this.cache != null) {
                this.markDirty((Collection)this.cache.ingredient(), (LongCollection)this.cache.hashes());
            }
            try {
                VanillaEntryTypes.ITEM.getDefinition();
            }
            catch (NullPointerException ignored) {
                this.cache = null;
                return;
            }
            this.cache = this.prepareCache(false);
            if (this.cache != null) {
                this.markDirty((Collection)this.cache.ingredient(), (LongCollection)this.cache.hashes());
            }
            InternalLogger.getInstance().debug("Marked %d hidden ingredients from tag cache as dirty.", new Object[]{this.cache == null ? 0 : this.cache.hashes().size()});
        }

        private record Cache(EntryIngredient ingredient, LongSet hashes) {
        }
    }
}

