/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.search.method.InputMethod;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.util.FormattingUtils;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.dragging.CurrentDraggingStack;
import me.shedaniel.rei.impl.client.gui.widget.AutoCraftingEvaluator;
import me.shedaniel.rei.impl.client.gui.widget.DisplayTooltipComponent;
import me.shedaniel.rei.impl.client.registry.display.DisplayCache;
import me.shedaniel.rei.impl.client.registry.display.DisplayRegistryImpl;
import me.shedaniel.rei.impl.client.util.CyclingList;
import me.shedaniel.rei.impl.client.util.OriginalRetainingCyclingList;
import me.shedaniel.rei.impl.client.view.ViewsImpl;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5632;
import net.minecraft.class_6880;
import net.minecraft.class_9848;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class EntryWidget
extends Slot
implements DraggableStackProviderWidget {
    @ApiStatus.Internal
    private byte noticeMark = 0;
    protected boolean highlight = true;
    protected boolean tooltips = true;
    protected boolean background = true;
    protected boolean interactable = true;
    protected boolean interactableFavorites = true;
    protected boolean wasClicked = false;
    private final Rectangle bounds;
    private final OriginalRetainingCyclingList<EntryStack<?>> stacks = new OriginalRetainingCyclingList<EntryStack>(EntryStack::empty);
    private long lastCycleTime = -1L;
    @Nullable
    private Set<UnaryOperator<Tooltip>> tooltipProcessors;
    public class_2960 tagMatch;
    public boolean removeTagMatch = true;
    private long lastCheckTime = -1L;
    private long lastCheckedTime = -1L;
    private Display display;
    private Supplier<DisplayTooltipComponent> displayTooltipComponent;
    private NumberAnimator<Float> darkBackgroundAlpha = ValueAnimator.ofFloat().withConvention(() -> Float.valueOf(REIRuntime.getInstance().isDarkThemeEnabled() ? 1.0f : 0.0f), ValueAnimator.typicalTransitionTime()).asFloat();
    private final NumberAnimator<Float> darkHighlightedAlpha = ValueAnimator.ofFloat().withConvention(() -> Float.valueOf(REIRuntime.getInstance().isDarkThemeEnabled() ? 1.0f : 0.0f), ValueAnimator.typicalTransitionTime()).asFloat();

    public EntryWidget(Point point) {
        this(new Rectangle(point.x - 1, point.y - 1, 18, 18));
    }

    public EntryWidget(Rectangle bounds) {
        this.bounds = bounds;
    }

    public EntryWidget unmarkInputOrOutput() {
        this.noticeMark = 0;
        return this;
    }

    public EntryWidget markIsInput() {
        this.noticeMark = 1;
        return this;
    }

    public EntryWidget markIsOutput() {
        this.noticeMark = (byte)2;
        return this;
    }

    public byte getNoticeMark() {
        return this.noticeMark;
    }

    public void setNoticeMark(byte noticeMark) {
        this.noticeMark = noticeMark;
    }

    public void setInteractable(boolean interactable) {
        this.interactable(interactable);
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public void setInteractableFavorites(boolean interactableFavorites) {
        this.interactableFavorites(interactableFavorites);
    }

    public boolean isInteractableFavorites() {
        return this.interactableFavorites;
    }

    public EntryWidget disableInteractions() {
        return this.interactable(false);
    }

    public EntryWidget interactable(boolean b) {
        this.interactable = b;
        this.interactableFavorites = this.interactableFavorites && this.interactable;
        return this;
    }

    public EntryWidget disableFavoritesInteractions() {
        return this.interactableFavorites(false);
    }

    public EntryWidget interactableFavorites(boolean b) {
        this.interactableFavorites = b && this.interactable;
        return this;
    }

    public EntryWidget noHighlight() {
        return this.highlight(false);
    }

    public EntryWidget highlight(boolean b) {
        this.highlight = b;
        return this;
    }

    public boolean isHighlightEnabled() {
        return this.highlight;
    }

    public void setHighlightEnabled(boolean highlights) {
        this.highlight(highlights);
    }

    public EntryWidget noTooltips() {
        return this.tooltips(false);
    }

    public EntryWidget tooltips(boolean b) {
        this.tooltips = b;
        return this;
    }

    public void setTooltipsEnabled(boolean tooltipsEnabled) {
        this.tooltips(tooltipsEnabled);
    }

    public boolean isTooltipsEnabled() {
        return this.tooltips;
    }

    public EntryWidget noBackground() {
        return this.background(false);
    }

    public EntryWidget background(boolean b) {
        this.background = b;
        return this;
    }

    public void setBackgroundEnabled(boolean backgroundEnabled) {
        this.background(backgroundEnabled);
    }

    public boolean isBackgroundEnabled() {
        return this.background;
    }

    public Slot clearEntries() {
        this.getCyclingEntries().clear();
        if (this.removeTagMatch) {
            this.tagMatch = null;
        }
        return this;
    }

    public EntryWidget clearStacks() {
        return (EntryWidget)this.clearEntries();
    }

    public EntryWidget entry(EntryStack<?> stack) {
        Objects.requireNonNull(stack);
        this.getCyclingEntries().add(stack);
        if (this.removeTagMatch) {
            this.tagMatch = null;
        }
        return this;
    }

    public EntryWidget entries(Collection<? extends EntryStack<?>> stacks) {
        Objects.requireNonNull(stacks);
        this.getCyclingEntries().addAll(stacks);
        if (this.removeTagMatch) {
            this.tagMatch = null;
        }
        return this;
    }

    public Slot withEntriesListener(Consumer<Slot> listener) {
        this.getCyclingEntries().addListener($ -> listener.accept(this));
        return this;
    }

    public Slot entries(CyclingList<EntryStack<?>> stacks) {
        this.getCyclingEntries().setBacking(stacks);
        if (this.removeTagMatch) {
            this.tagMatch = null;
        }
        return this;
    }

    public CyclingList<EntryStack<?>> getBackingCyclingEntries() {
        return this.stacks.getBacking();
    }

    public OriginalRetainingCyclingList<EntryStack<?>> getCyclingEntries() {
        return this.stacks;
    }

    public EntryStack<?> getCurrentEntry() {
        if (this.lastCycleTime == -1L) {
            this.lastCycleTime = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() > this.lastCycleTime + this.getCyclingInterval()) {
            this.lastCycleTime = System.currentTimeMillis();
            this.getCyclingEntries().next();
        }
        return this.getCyclingEntries().peek();
    }

    public List<EntryStack<?>> getEntries() {
        return this.getCyclingEntries().get();
    }

    protected long getCyclingInterval() {
        return 1000L;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Rectangle getInnerBounds() {
        return new Rectangle(this.bounds.x + 1, this.bounds.y + 1, this.bounds.width - 2, this.bounds.height - 2);
    }

    @Nullable
    private TransferHandler _getTransferHandler() {
        this.lastCheckTime = class_156.method_658();
        if (PluginManager.areAnyReloading()) {
            return null;
        }
        try {
            DisplayRegistry displayRegistry = DisplayRegistry.getInstance();
            DisplayCache displayCache = ((DisplayRegistryImpl)displayRegistry).cache();
            CategoryRegistry categoryRegistry = CategoryRegistry.getInstance();
            Map filteringQuickCraftCategories = ConfigObject.getInstance().getFilteringQuickCraftCategories();
            boolean shouldFilterDisplays = ConfigObject.getInstance().shouldFilterDisplays();
            for (Display display : displayCache.getAllDisplaysByOutputs(this.getEntries())) {
                CategoryIdentifier categoryIdentifier = display.getCategoryIdentifier();
                Optional configuration = categoryRegistry.tryGet(categoryIdentifier);
                if (configuration.isEmpty() || categoryRegistry.isCategoryInvisible(((CategoryRegistry.CategoryConfiguration)configuration.get()).getCategory()) || !filteringQuickCraftCategories.getOrDefault(categoryIdentifier, ((CategoryRegistry.CategoryConfiguration)configuration.get()).isQuickCraftingEnabledByDefault()).booleanValue() || shouldFilterDisplays && !displayRegistry.isDisplayVisible(display)) continue;
                AutoCraftingEvaluator.AutoCraftingResult result = AutoCraftingEvaluator.evaluateAutoCrafting(false, false, display, null);
                if (!result.successful) continue;
                this.display = display;
                this.displayTooltipComponent = Suppliers.memoize(() -> new DisplayTooltipComponent((DisplaySpec)display));
                return result.successfulHandler;
            }
        }
        catch (ConcurrentModificationException ignored) {
            this.display = null;
            this.displayTooltipComponent = null;
            this.lastCheckTime = -1L;
        }
        return null;
    }

    private TransferHandler getTransferHandler(boolean query) {
        if (PluginManager.areAnyReloading()) {
            return null;
        }
        if (this.display != null) {
            if (ViewsImpl.isRecipesFor(null, this.getEntries(), this.display)) {
                AutoCraftingEvaluator.AutoCraftingResult result = AutoCraftingEvaluator.evaluateAutoCrafting(false, false, this.display, null);
                if (result.successful) {
                    return result.successfulHandler;
                }
            }
            this.display = null;
            this.displayTooltipComponent = null;
            this.lastCheckTime = -1L;
        }
        if (this.lastCheckTime != -1L && class_156.method_658() - this.lastCheckTime < 2000L) {
            return null;
        }
        return query ? this._getTransferHandler() : null;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.drawBackground(graphics, mouseX, mouseY, delta);
        this.drawCurrentEntry(graphics, mouseX, mouseY, delta);
        boolean highlighted = this.containsMouse(mouseX, mouseY);
        if (this.hasTooltips() && highlighted) {
            this.queueTooltip(graphics, mouseX, mouseY, delta);
        }
        if (this.hasHighlight() && highlighted) {
            this.drawHighlighted(graphics, mouseX, mouseY, delta);
        }
        this.drawExtra(graphics, mouseX, mouseY, delta);
    }

    public final boolean hasTooltips() {
        return this.isTooltipsEnabled();
    }

    public final boolean hasHighlight() {
        return this.isHighlightEnabled();
    }

    @ApiStatus.Internal
    public void setDarkBackgroundAlpha(NumberAnimator<Float> darkBackgroundAlpha) {
        this.darkBackgroundAlpha = darkBackgroundAlpha;
    }

    protected void drawBackground(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (this.background) {
            this.darkBackgroundAlpha.update((double)delta);
            graphics.method_25290(class_10799.field_56883, InternalTextures.CHEST_GUI_TEXTURE, this.bounds.x, this.bounds.y, 0.0f, 222.0f, this.bounds.width, this.bounds.height, 256, 256);
            if (((Float)this.darkBackgroundAlpha.value()).floatValue() > 0.0f) {
                graphics.method_25291(class_10799.field_56883, InternalTextures.CHEST_GUI_TEXTURE_DARK, this.bounds.x, this.bounds.y, 0.0f, 222.0f, this.bounds.width, this.bounds.height, 256, 256, class_9848.method_61317((float)((Float)this.darkBackgroundAlpha.value()).floatValue()));
            }
        }
    }

    protected void drawCurrentEntry(class_332 graphics, int mouseX, int mouseY, float delta) {
        EntryStack<?> entry = this.getCurrentEntry();
        entry.render(graphics, this.getInnerBounds(), mouseX, mouseY, delta);
    }

    protected void queueTooltip(class_332 graphics, int mouseX, int mouseY, float delta) {
        Tooltip tooltip = this.getCurrentTooltip(TooltipContext.ofMouse((class_1792.class_9635)class_1792.class_9635.method_59528((class_1937)this.minecraft.field_1687)));
        if (tooltip != null) {
            tooltip.queue();
        }
    }

    protected void drawExtra(class_332 graphics, int mouseX, int mouseY, float delta) {
    }

    @Nullable
    public Tooltip getCurrentTooltip(TooltipContext context) {
        Tooltip tooltip = this.getCurrentEntry().getTooltip(context);
        if (tooltip != null && !(class_310.method_1551().field_1755 instanceof DisplayScreen)) {
            boolean exists;
            boolean bl = exists = this.getTransferHandler(false) != null;
            if (!exists) {
                if (this.lastCheckedTime == -1L || class_156.method_658() - this.lastCheckedTime > 400L) {
                    this.lastCheckedTime = class_156.method_658();
                }
                if (class_156.method_658() - this.lastCheckedTime > 200L) {
                    this.lastCheckedTime = -1L;
                    exists = this.getTransferHandler(true) != null;
                }
            } else {
                this.lastCheckedTime = -1L;
            }
            if (exists) {
                tooltip.add((class_2561)class_2561.method_43471((String)"text.auto_craft.move_items.tooltip").method_27692(class_124.field_1054));
                tooltip.add((class_5632)this.displayTooltipComponent.get());
            }
        }
        if (tooltip != null) {
            if (this.interactableFavorites && ConfigObject.getInstance().doDisplayFavoritesTooltip() && !ConfigObject.getInstance().getFavoriteKeyCode().isUnknown()) {
                String name = ConfigObject.getInstance().getFavoriteKeyCode().getLocalizedName().getString();
                if (this.reverseFavoritesAction()) {
                    tooltip.addAllTexts((Iterable)Stream.of(class_1074.method_4662((String)"text.rei.remove_favorites_tooltip", (Object[])new Object[]{name}).split("\n")).map(class_2561::method_43470).collect(Collectors.toList()));
                } else {
                    tooltip.addAllTexts((Iterable)Stream.of(class_1074.method_4662((String)"text.rei.favorites_tooltip", (Object[])new Object[]{name}).split("\n")).map(class_2561::method_43470).collect(Collectors.toList()));
                }
            }
            if (this.tooltipProcessors != null) {
                for (UnaryOperator<Tooltip> processor : this.tooltipProcessors) {
                    tooltip = (Tooltip)processor.apply(tooltip);
                }
            }
        }
        if (tooltip != null) {
            Tooltip.Entry entry;
            if (this.interactableFavorites && ConfigObject.getInstance().doDisplayFavoritesTooltip() && !ConfigObject.getInstance().getFavoriteKeyCode().isUnknown()) {
                String name = ConfigObject.getInstance().getFavoriteKeyCode().getLocalizedName().getString();
                if (this.reverseFavoritesAction()) {
                    tooltip.addAllTexts((Iterable)Stream.of(class_1074.method_4662((String)"text.rei.remove_favorites_tooltip", (Object[])new Object[]{name}).split("\n")).map(class_2561::method_43470).collect(Collectors.toList()));
                } else {
                    tooltip.addAllTexts((Iterable)Stream.of(class_1074.method_4662((String)"text.rei.favorites_tooltip", (Object[])new Object[]{name}).split("\n")).map(class_2561::method_43470).collect(Collectors.toList()));
                }
            }
            if (this.tooltipProcessors != null) {
                for (UnaryOperator<Tooltip> processor : this.tooltipProcessors) {
                    tooltip = (Tooltip)processor.apply(tooltip);
                }
            }
            if (!tooltip.entries().isEmpty() && ConfigObject.getInstance().doDisplayIMEHints() && (entry = (Tooltip.Entry)tooltip.entries().get(0)).isText()) {
                String name = FormattingUtils.stripFormatting((String)entry.getAsText().getString());
                InputMethod active = InputMethod.active();
                String suggested = active.suggestInputString(name);
                if (suggested != null) {
                    tooltip.entries().add(1, Tooltip.entry((class_2561)class_2561.method_43470((String)suggested).method_27692(class_124.field_1080)));
                }
            }
        }
        return tooltip;
    }

    protected void drawHighlighted(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.darkHighlightedAlpha.update((double)delta);
        Rectangle bounds = this.getInnerBounds();
        graphics.method_25296(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), -2130706433, -2130706433);
        int darkColor = 0x111111 | (int)(90.0f * ((Float)this.darkHighlightedAlpha.value()).floatValue()) << 24;
        graphics.method_25296(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), darkColor, darkColor);
    }

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }

    protected boolean wasClicked() {
        boolean b = this.wasClicked;
        this.wasClicked = false;
        return b;
    }

    public void tooltipProcessor(UnaryOperator<Tooltip> operator) {
        if (this.tooltipProcessors == null) {
            this.tooltipProcessors = Collections.singleton(operator);
        } else {
            if (!(this.tooltipProcessors instanceof LinkedHashSet)) {
                this.tooltipProcessors = new LinkedHashSet<UnaryOperator<Tooltip>>(this.tooltipProcessors);
            }
            this.tooltipProcessors.add(operator);
        }
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (this.containsMouse(event.comp_4798(), event.comp_4799())) {
            this.wasClicked = true;
            return true;
        }
        return super.method_25402(event, doubleClick);
    }

    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        if (REIRuntimeImpl.isWithinRecipeViewingScreen && this.getCyclingEntries().get().size() > 1 && this.containsMouse(mouseX, mouseY)) {
            if (amountY < 0.0) {
                for (EntryWidget slot : Widgets.walk((Iterable)this.minecraft.field_1755.method_25396(), EntryWidget.class::isInstance)) {
                    slot.getCyclingEntries().previous();
                    slot.lastCycleTime = System.currentTimeMillis();
                }
                return true;
            }
            if (amountY > 0.0) {
                for (EntryWidget slot : Widgets.walk((Iterable)this.minecraft.field_1755.method_25396(), EntryWidget.class::isInstance)) {
                    slot.getCyclingEntries().next();
                    slot.lastCycleTime = System.currentTimeMillis();
                }
                return true;
            }
        }
        return false;
    }

    public boolean method_25406(class_11909 event) {
        if (!this.interactable) {
            return false;
        }
        if (this.wasClicked() && this.containsMouse(event.comp_4798(), event.comp_4799()) && this.doAction(event)) {
            ((CurrentDraggingStack)DraggingContext.getInstance()).drop();
            return true;
        }
        return false;
    }

    protected boolean doAction(class_11909 event) {
        FavoriteEntry favoriteEntry;
        ModifierKeyCode keyCode;
        if (this.interactableFavorites && ConfigObject.getInstance().isFavoritesEnabled() && !this.getCurrentEntry().isEmpty() && (keyCode = ConfigObject.getInstance().getFavoriteKeyCode()).matchesMouse(event.method_74245()) && (favoriteEntry = this.asFavoriteEntry()) != null) {
            if (this.reverseFavoritesAction()) {
                ConfigObject.getInstance().getFavoriteEntries().remove(favoriteEntry);
            } else {
                ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
            }
            return true;
        }
        if (!(class_310.method_1551().field_1755 instanceof DisplayScreen) && class_310.method_1551().method_74188()) {
            try {
                TransferHandler handler = this.getTransferHandler(true);
                if (handler != null) {
                    class_465 containerScreen = REIRuntime.getInstance().getPreviousContainerScreen();
                    TransferHandler.Context context = TransferHandler.Context.create((boolean)true, (class_310.method_1551().method_74187() || event.method_74245() == 1 ? 1 : 0) != 0, (class_465)containerScreen, (Display)this.display);
                    TransferHandler.ApplicabilityResult applicabilityResult = handler.checkApplicable(context);
                    if (!applicabilityResult.isApplicable()) {
                        return false;
                    }
                    TransferHandler.Result transferResult = applicabilityResult.isSuccessful() ? handler.handle(context) : applicabilityResult.getError();
                    if (transferResult.isBlocking()) {
                        this.minecraft.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                        if (transferResult.isReturningToScreen() && class_310.method_1551().field_1755 != containerScreen) {
                            class_310.method_1551().method_1507((class_437)containerScreen);
                            REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
                        }
                        return true;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (ConfigObject.getInstance().getRecipeKeybind().getType() != class_3675.class_307.field_1672 && event.method_74245() == 0 || ConfigObject.getInstance().getRecipeKeybind().matchesMouse(event.method_74245())) {
            return ViewSearchBuilder.builder().addRecipesFor(this.getCurrentEntry()).open();
        }
        if (ConfigObject.getInstance().getUsageKeybind().getType() != class_3675.class_307.field_1672 && event.method_74245() == 1 || ConfigObject.getInstance().getUsageKeybind().matchesMouse(event.method_74245())) {
            return ViewSearchBuilder.builder().addUsagesFor(this.getCurrentEntry()).open();
        }
        return false;
    }

    @ApiStatus.Internal
    @Nullable
    protected FavoriteEntry asFavoriteEntry() {
        FavoriteEntry entry = FavoriteEntry.fromEntryStack((EntryStack)this.getCurrentEntry().normalize());
        return entry.isInvalid() ? null : entry;
    }

    @ApiStatus.Internal
    public boolean cancelDeleteItems(EntryStack<?> stack) {
        return false;
    }

    protected boolean reverseFavoritesAction() {
        return false;
    }

    public boolean containsMouse(double mouseX, double mouseY) {
        return mouseX >= (double)(this.bounds.x + 1) && mouseY >= (double)(this.bounds.y + 1) && mouseX <= (double)(this.bounds.getMaxX() - 1) && mouseY <= (double)(this.bounds.getMaxY() - 1);
    }

    public boolean method_25404(class_11908 event) {
        if (this.containsMouse(EntryWidget.mouse())) {
            return this.keyPressedIgnoreContains(event);
        }
        return false;
    }

    public boolean keyPressedIgnoreContains(class_11908 event) {
        FavoriteEntry favoriteEntry;
        if (!this.interactable) {
            return false;
        }
        if (this.interactableFavorites && ConfigObject.getInstance().isFavoritesEnabled() && !this.getCurrentEntry().isEmpty() && ConfigObject.getInstance().getFavoriteKeyCode().matchesKey(event.comp_4795(), event.comp_4796()) && (favoriteEntry = this.asFavoriteEntry()) != null) {
            if (this.reverseFavoritesAction()) {
                ConfigObject.getInstance().getFavoriteEntries().remove(favoriteEntry);
            } else {
                ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
            }
            return true;
        }
        if (ConfigObject.getInstance().getRecipeKeybind().matchesKey(event.comp_4795(), event.comp_4796())) {
            return ViewSearchBuilder.builder().addRecipesFor(this.getCurrentEntry()).open();
        }
        if (ConfigObject.getInstance().getUsageKeybind().matchesKey(event.comp_4795(), event.comp_4796())) {
            return ViewSearchBuilder.builder().addUsagesFor(this.getCurrentEntry()).open();
        }
        return false;
    }

    @Nullable
    public DraggableStack getHoveredStack(final DraggingContext<class_437> context, double mouseX, double mouseY) {
        if (!this.getCurrentEntry().isEmpty() && this.containsMouse(mouseX, mouseY)) {
            return new DraggableStack(){
                final EntryStack<?> stack;
                {
                    this.stack = EntryWidget.this.getCurrentEntry().copy().removeSetting(EntryStack.Settings.RENDERER).removeSetting(EntryStack.Settings.FLUID_RENDER_RATIO);
                }

                public EntryStack<?> getStack() {
                    return this.stack;
                }

                public void drag() {
                }

                public void release(DraggedAcceptorResult result) {
                    if (result == DraggedAcceptorResult.PASS) {
                        context.renderBackToPosition((DraggableStack)this, DraggingContext.getInstance().getCurrentPosition(), () -> new Point(EntryWidget.this.getBounds().x, EntryWidget.this.getBounds().y));
                    }
                }
            };
        }
        return null;
    }

    @Deprecated
    public void render(class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
        Rectangle clone = this.getBounds().clone();
        this.getBounds().setBounds(bounds.x - 1, bounds.y - 1, bounds.width + 2, bounds.height + 2);
        this.method_25394(graphics, mouseX, mouseY, delta);
        this.getBounds().setBounds(clone);
    }

    public void fillCrashReport(class_128 report, class_129 category) {
        super.fillCrashReport(report, category);
        category.method_577("Notice mark", () -> String.valueOf(this.getNoticeMark()));
        category.method_577("Interactable", () -> String.valueOf(this.isInteractable()));
        category.method_577("Interactable favorites", () -> String.valueOf(this.isInteractableFavorites()));
        category.method_577("Highlight enabled", () -> String.valueOf(this.isHighlightEnabled()));
        category.method_577("Tooltip enabled", () -> String.valueOf(this.isTooltipsEnabled()));
        category.method_577("Background enabled", () -> String.valueOf(this.isBackgroundEnabled()));
        category.method_577("Entries count", () -> String.valueOf(this.getEntries().size()));
        EntryStack<?> currentEntry = this.getCurrentEntry();
        class_129 entryCategory = report.method_562("Current Rendering Entry");
        currentEntry.fillCrashReport(report, entryCategory);
    }
}

