/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.config.options.preview;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.config.ConfigAccess;
import me.shedaniel.rei.impl.client.gui.config.options.AllREIConfigOptions;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class TooltipPreviewer {
    public static WidgetWithBounds create(ConfigAccess access, int width, @Nullable IntSupplier height) {
        Rectangle bounds = new Rectangle();
        return Widgets.withBounds((Widget)Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
            EntryStack stack = EntryStacks.of((class_1935)class_1802.field_8118);
            boolean appendModNames = access.get(AllREIConfigOptions.APPEND_MOD_NAMES);
            boolean appendFavorites = access.get(AllREIConfigOptions.APPEND_FAVORITES_HINT);
            ArrayList<Tooltip.Entry> entries = new ArrayList<Tooltip.Entry>();
            entries.add(Tooltip.entry((class_2561)ConfigUtils.translatable("block.minecraft.oak_planks")));
            if (appendModNames) {
                entries.add(Tooltip.entry((class_2561)ConfigUtils.literal("Minecraft").method_27695(new class_124[]{class_124.field_1078, class_124.field_1056})));
            }
            if (appendFavorites) {
                String name = ConfigObject.getInstance().getFavoriteKeyCode().getLocalizedName().getString();
                entries.addAll(Stream.of(class_1074.method_4662((String)"text.rei.favorites_tooltip", (Object[])new Object[]{name}).split("\n")).map(ConfigUtils::literal).map(Tooltip::entry).toList());
            }
            List components = entries.stream().flatMap(entry -> class_310.method_1551().field_1772.method_1728((class_5348)entry.getAsText(), width - 12 - 4).stream()).toList();
            int minWidth = components.stream().mapToInt(component -> class_310.method_1551().field_1772.method_30880(component)).max().orElse(0) + 4;
            int minHeight = components.stream().mapToInt(component -> components.get(0) == component && components.size() >= 2 ? 12 : 10).sum() + 4;
            int tX = Math.max(6, (width - minWidth) / 2);
            int tWidth = Math.min(width - 12, minWidth);
            int tY = 28;
            int tHeight = Math.min(minHeight, height == null ? 100000 : height.getAsInt() - tY - 4);
            graphics.method_51448().pushMatrix();
            graphics.method_51448().translate(0.0f, height == null ? 4.0f : (float)Math.max(0, (height.getAsInt() - (tY + tHeight)) / 2));
            bounds.setSize(width, height == null ? tY + tHeight + 12 : height.getAsInt());
            stack.getRenderer().render(stack, graphics, new Rectangle(width / 2 - 12, 0, 24, 24), mouseX, mouseY, delta);
            int finalTY = tY;
            graphics.method_25296(tX - 3, finalTY - 4, tX + tWidth + 3, finalTY - 3, -267386864, -267386864);
            graphics.method_25296(tX - 3, finalTY + tHeight + 3, tX + tWidth + 3, finalTY + tHeight + 4, -267386864, -267386864);
            graphics.method_25296(tX - 3, finalTY - 3, tX + tWidth + 3, finalTY + tHeight + 3, -267386864, -267386864);
            graphics.method_25296(tX - 4, finalTY - 3, tX - 3, finalTY + tHeight + 3, -267386864, -267386864);
            graphics.method_25296(tX + tWidth + 3, finalTY - 3, tX + tWidth + 4, finalTY + tHeight + 3, -267386864, -267386864);
            graphics.method_25296(tX - 3, finalTY - 3 + 1, tX - 3 + 1, finalTY + tHeight + 3 - 1, 0x505000FF, 1344798847);
            graphics.method_25296(tX + tWidth + 2, finalTY - 3 + 1, tX + tWidth + 3, finalTY + tHeight + 3 - 1, 0x505000FF, 1344798847);
            graphics.method_25296(tX - 3, finalTY - 3, tX + tWidth + 3, finalTY - 3 + 1, 0x505000FF, 0x505000FF);
            graphics.method_25296(tX - 3, finalTY + tHeight + 2, tX + tWidth + 3, finalTY + tHeight + 3, 1344798847, 1344798847);
            for (int i = 0; i < components.size(); ++i) {
                graphics.method_51430(class_310.method_1551().field_1772, (class_5481)components.get(i), tX + 2, tY + 2, -1, false);
                tY += 10 + (i == 0 ? 2 : 0);
            }
            graphics.method_51448().popMatrix();
        }), (Rectangle)bounds);
    }

    private static void fillGradient(Matrix4f pose, class_4588 buffer, int x1, int y1, int x2, int y2, int blitOffset, int color1, int color2) {
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float g = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float h = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float i = (float)(color1 & 0xFF) / 255.0f;
        float j = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float k = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float l = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float m = (float)(color2 & 0xFF) / 255.0f;
        buffer.method_22918(pose, (float)x2, (float)y1, (float)blitOffset).method_22915(g, h, i, f);
        buffer.method_22918(pose, (float)x1, (float)y1, (float)blitOffset).method_22915(g, h, i, f);
        buffer.method_22918(pose, (float)x1, (float)y2, (float)blitOffset).method_22915(k, l, m, j);
        buffer.method_22918(pose, (float)x2, (float)y2, (float)blitOffset).method_22915(k, l, m, j);
    }
}

