/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.common.runtime;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.fluid.FluidStack;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.common.plugins.REICommonPlugin;
import me.shedaniel.rei.api.common.transfer.info.stack.PlayerInventorySlotAccessor;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessorRegistry;
import me.shedaniel.rei.api.common.transfer.info.stack.VanillaSlotAccessor;
import me.shedaniel.rei.plugin.client.entry.FluidEntryDefinition;
import me.shedaniel.rei.plugin.client.entry.ItemEntryDefinition;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.stream.Stream;

@ApiStatus.Internal
public class DefaultRuntimePlugin implements REICommonPlugin {
    public static final class_2960 PLUGIN = class_2960.method_60655("roughlyenoughitems", "default_runtime_plugin");
    
    @Override
    public void registerEntryTypes(EntryTypeRegistry registry) {
        registry.register(VanillaEntryTypes.ITEM, new ItemEntryDefinition());
        registry.register(VanillaEntryTypes.FLUID, new FluidEntryDefinition());
        
        registry.registerBridge(VanillaEntryTypes.ITEM, VanillaEntryTypes.FLUID, input -> {
            Optional<Stream<EntryStack<FluidStack>>> stream = FluidSupportProvider.getInstance().itemToFluids(input);
            if (!stream.isPresent()) {
                return CompoundEventResult.pass();
            }
            return CompoundEventResult.interruptTrue(stream.get());
        });
    }
    
    @Override
    public void registerSlotAccessors(SlotAccessorRegistry registry) {
        registry.register(class_2960.method_60655("roughlyenoughitems", "vanilla"),
                slotAccessor -> slotAccessor instanceof VanillaSlotAccessor,
                new SlotAccessorRegistry.Serializer() {
                    @Override
                    public SlotAccessor read(class_1703 menu, class_1657 player, class_2487 tag) {
                        int slot = tag.method_10550("Slot").orElseThrow();
                        return new VanillaSlotAccessor(menu.field_7761.get(slot));
                    }
                    
                    @Override
                    @Nullable
                    public class_2487 save(class_1703 menu, class_1657 player, SlotAccessor accessor) {
                        if (!(accessor instanceof VanillaSlotAccessor)) {
                            throw new IllegalArgumentException("Cannot save non-vanilla slot accessor!");
                        }
                        class_2487 tag = new class_2487();
                        tag.method_10569("Slot", ((VanillaSlotAccessor) accessor).getSlot().field_7874);
                        return tag;
                    }
                });
        registry.register(class_2960.method_60655("roughlyenoughitems", "player"),
                slotAccessor -> slotAccessor instanceof PlayerInventorySlotAccessor,
                new SlotAccessorRegistry.Serializer() {
                    @Override
                    public SlotAccessor read(class_1703 menu, class_1657 player, class_2487 tag) {
                        int slot = tag.method_10550("Slot").orElseThrow();
                        return new PlayerInventorySlotAccessor(player, slot);
                    }
                    
                    @Override
                    @Nullable
                    public class_2487 save(class_1703 menu, class_1657 player, SlotAccessor accessor) {
                        if (!(accessor instanceof PlayerInventorySlotAccessor)) {
                            throw new IllegalArgumentException("Cannot save non-player slot accessor!");
                        }
                        class_2487 tag = new class_2487();
                        tag.method_10569("Slot", ((PlayerInventorySlotAccessor) accessor).getIndex());
                        return tag;
                    }
                });
    }
}
