/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.config.addon;

import me.shedaniel.rei.api.client.config.addon.ConfigAddon;
import me.shedaniel.rei.api.client.config.addon.ConfigAddonRegistry;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import net.minecraft.class_10799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public class ConfigAddonsScreen extends class_437 {
    private AddonsList rulesList;
    private final class_437 parent;
    
    public ConfigAddonsScreen(class_437 parent) {
        super(class_2561.method_43471("text.rei.addons"));
        this.parent = parent;
    }
    
    @Override
    public void method_25426() {
        super.method_25426();
        {
            class_2561 backText = class_2561.method_43470("↩ ").method_10852(class_2561.method_43471("gui.back"));
            method_37063(class_4185.method_46430(backText, button -> {
                field_22787.method_1507(parent);
            }).method_46434(4, 4, class_310.method_1551().field_1772.method_27525(backText) + 10, 20).method_46431());
        }
        rulesList = method_25429(new AddonsList(field_22787, field_22789, field_22790, 30, field_22790));
        ConfigAddonRegistryImpl addonRegistry = (ConfigAddonRegistryImpl) ConfigAddonRegistry.getInstance();
        for (ConfigAddon addon : addonRegistry.getAddons()) {
            rulesList.addItem(new DefaultAddonEntry(parent, addon));
        }
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.rulesList.method_25394(graphics, mouseX, mouseY, delta);
        super.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_35720(this.field_22793, this.field_22785.method_30937(), (int) (this.field_22789 / 2.0F - this.field_22793.method_27525(this.field_22785) / 2.0F), 12, -1);
    }
    
    public static class AddonsList extends UpdatedListWidget<AddonEntry> {
        private boolean inFocus;
        
        public AddonsList(class_310 client, int width, int height, int top, int bottom) {
            super(client, width, height, top, bottom);
        }
        
        @Override
        protected boolean isSelected(int index) {
            return false;
        }
        
        @Override
        protected int addItem(AddonEntry item) {
            return super.addItem(item);
        }
        
        @Override
        public int getItemWidth() {
            return width - 40;
        }
        
        @Override
        protected int getScrollbarPosition() {
            return width - 14;
        }
    }
    
    public static abstract class AddonEntry extends UpdatedListWidget.ElementEntry<AddonEntry> {
        @Override
        public int getItemHeight() {
            return 26;
        }
        
        @Override
        @Nullable
        public class_8016 method_48205(class_8023 focusNavigationEvent) {
            return null;
        }
    }
    
    public static class DefaultAddonEntry extends AddonEntry {
        private final class_4185 configureButton;
        private final ConfigAddon addon;
        
        public DefaultAddonEntry(class_437 parent, ConfigAddon addon) {
            this.addon = addon;
            this.configureButton = new class_4185(0, 0, 20, 20, class_2561.method_30163(null), button -> {
                class_310.method_1551().method_1507(this.addon.createScreen(class_310.method_1551().field_1755));
            }, Supplier::get) {
                @Override
                public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
                    super.method_48579(graphics, mouseX, mouseY, delta);
                    graphics.method_25290(class_10799.field_56883, InternalTextures.CHEST_GUI_TEXTURE, method_46426() + 3, method_46427() + 3, 0, 0, 14, 14, 256, 256);
                }
            };
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            class_310 client = class_310.method_1551();
            {
                class_2561 title = addon.getName();
                int i = client.field_1772.method_27525(title);
                if (i > entryWidth - 28) {
                    class_5348 titleTrimmed = class_5348.method_29433(client.field_1772.method_1714(title, entryWidth - 28 - client.field_1772.method_1727("...")), class_5348.method_29430("..."));
                    graphics.method_35720(client.field_1772, class_2477.method_10517().method_30934(titleTrimmed), x + 2, y + 1, 16777215);
                } else {
                    graphics.method_35720(client.field_1772, title.method_30937(), x + 2, y + 1, 16777215);
                }
            }
            {
                class_2561 subtitle = addon.getDescription();
                int i = client.field_1772.method_27525(subtitle);
                if (i > entryWidth - 28) {
                    class_5348 subtitleTrimmed = class_5348.method_29433(client.field_1772.method_1714(subtitle, entryWidth - 28 - client.field_1772.method_1727("...")), class_5348.method_29430("..."));
                    graphics.method_35720(client.field_1772, class_2477.method_10517().method_30934(subtitleTrimmed), x + 2, y + 12, 8421504);
                } else {
                    graphics.method_35720(client.field_1772, subtitle.method_30937(), x + 2, y + 12, 8421504);
                }
            }
            configureButton.method_46421(x + entryWidth - 25);
            configureButton.method_46419(y + 1);
            configureButton.method_25394(graphics, mouseX, mouseY, delta);
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.singletonList(configureButton);
        }
        
        @Override
        public List<? extends class_6379> narratables() {
            return Collections.singletonList(configureButton);
        }
    }
}
