/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.networking;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.UnaryOperator;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.impl.client.registry.display.DisplayRegistryImpl;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_7995;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record DisplaySyncPacket(SyncType syncType, Collection<Display> displays, long version) implements class_8710
{
    public static final class_8710.class_9154<DisplaySyncPacket> TYPE = new class_8710.class_9154(RoughlyEnoughItemsNetwork.SYNC_DISPLAYS_PACKET);
    public static final class_9139<? super class_9129, DisplaySyncPacket> STREAM_CODEC = class_9139.method_56436(SyncType.STREAM_CODEC, DisplaySyncPacket::syncType, (class_9139)Display.streamCodec().method_56433(codec -> new class_9139<class_9129, Display>(){

        public void encode(class_9129 buf, Display display) {
            class_9129 tmpBuf = new class_9129(Unpooled.buffer(), buf.method_56349());
            try {
                codec.encode((Object)tmpBuf, (Object)display);
            }
            catch (Throwable throwable) {
                tmpBuf.release();
                buf.method_52964(false);
                InternalLogger.getInstance().debug("Failed to encode display: %s".formatted(display), throwable);
                return;
            }
            buf.method_52964(true);
            class_9129.method_56894((ByteBuf)buf, (byte[])ByteBufUtil.getBytes((ByteBuf)tmpBuf));
            tmpBuf.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Display decode(class_9129 buf) {
            boolean success = buf.readBoolean();
            if (!success) {
                return null;
            }
            class_9129 tmpBuf = new class_9129(Unpooled.wrappedBuffer((byte[])class_9129.method_56890((ByteBuf)buf)), buf.method_56349());
            try {
                Display display = (Display)codec.decode((Object)tmpBuf);
                return display;
            }
            catch (Throwable throwable) {
                Display display = null;
                return display;
            }
            finally {
                tmpBuf.release();
            }
        }
    }).method_56433(class_9135.method_56374(ArrayList::new)).method_56432(list -> list.stream().filter(Objects::nonNull).toList(), UnaryOperator.identity()), DisplaySyncPacket::displays, (class_9139)class_9135.field_54505, DisplaySyncPacket::version, DisplaySyncPacket::new);

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    @Environment(value=EnvType.CLIENT)
    public void handle(NetworkManager.PacketContext context) {
        DisplayRegistryImpl registry = (DisplayRegistryImpl)DisplayRegistry.getInstance();
        if (this.syncType() == SyncType.SET) {
            InternalLogger.getInstance().info("[REI Server Display Sync] Received server's request to set %d recipes.", new Object[]{this.displays().size()});
            registry.addJob(() -> {
                registry.removeSyncedRecipes();
                for (Display display : this.displays()) {
                    registry.add(display, DisplayRegistryImpl.SYNCED);
                }
            });
        } else if (this.syncType() == SyncType.APPEND) {
            InternalLogger.getInstance().info("[REI Server Display Sync] Received server's request to append %d recipes.", new Object[]{this.displays().size()});
            registry.addJob(() -> {
                for (Display display : this.displays()) {
                    registry.add(display, DisplayRegistryImpl.SYNCED);
                }
            });
        }
    }

    public static enum SyncType {
        APPEND,
        SET;

        public static final IntFunction<SyncType> BY_ID;
        public static final class_9139<ByteBuf, SyncType> STREAM_CODEC;

        static {
            BY_ID = class_7995.method_47914(Enum::ordinal, (Object[])SyncType.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
            STREAM_CODEC = class_9135.method_56375(BY_ID, Enum::ordinal);
        }
    }
}

