/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.region;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.FloatingPoint;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.entry.region.RegionEntry;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitorWidget;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.widget.EntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.RealRegionEntry;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionDraggableStack;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionEntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionListener;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3902;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class EntryStacksRegionWidget<T extends RegionEntry<T>>
extends WidgetWithBounds
implements DraggableComponentProviderWidget<Object>,
DraggableComponentVisitorWidget {
    public final RegionListener<T> listener;
    protected int blockedCount;
    private Rectangle bounds = new Rectangle();
    private Rectangle innerBounds;
    public final ScrollingContainer scrolling = new ScrollingContainer(){

        public Rectangle getBounds() {
            return EntryStacksRegionWidget.this.getBounds();
        }

        public int getMaxScrollHeight() {
            if (EntryStacksRegionWidget.this.innerBounds.width == 0) {
                return 0;
            }
            return class_3532.method_15386((float)((float)(EntryStacksRegionWidget.this.entries.size() + EntryStacksRegionWidget.this.blockedCount) / ((float)EntryStacksRegionWidget.this.innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
        }

        public int getScrollBarX(int maxX) {
            if (!ConfigObject.getInstance().isLeftHandSidePanel()) {
                return EntryStacksRegionWidget.this.bounds.x + 1;
            }
            return maxX - 7;
        }
    };
    private final Int2ObjectMap<RealRegionEntry<T>> entries = new Int2ObjectLinkedOpenHashMap();
    private final Int2ObjectMap<RealRegionEntry<T>> removedEntries = new Int2ObjectLinkedOpenHashMap();
    private List<RegionEntryWidget<T>> entriesList = Lists.newArrayList();
    private List<Widget> children = Lists.newArrayList();

    public EntryStacksRegionWidget(RegionListener<T> listener) {
        this.listener = listener;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (this.bounds.isEmpty()) {
            return;
        }
        int entrySize = EntryListWidget.entrySize();
        this.updateEntriesPosition(entry -> true);
        for (RealRegionEntry entry2 : this.entries.values()) {
            entry2.update(delta);
        }
        ObjectIterator removedEntriesIterator = this.removedEntries.values().iterator();
        while (removedEntriesIterator.hasNext()) {
            RealRegionEntry removedEntry = (RealRegionEntry)removedEntriesIterator.next();
            removedEntry.update(delta);
            if (!(removedEntry.size.doubleValue() <= 300.0)) continue;
            removedEntriesIterator.remove();
            this.entriesList.remove((Object)removedEntry.getWidget());
            this.children.remove((Object)removedEntry.getWidget());
        }
        graphics.method_44379(this.bounds.x, this.bounds.y, this.bounds.getMaxX(), this.bounds.getMaxY());
        Stream<RegionEntryWidget> entryStream = this.entriesList.stream().filter(entry -> entry.getBounds().getMaxY() >= this.bounds.getY() && entry.getBounds().y <= this.bounds.getMaxY());
        new EntryRendererManager(entryStream.collect(Collectors.toList())).render(graphics, mouseX, mouseY, delta);
        this.updatePosition(delta);
        this.scrolling.renderScrollBar(graphics, 0, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        graphics.method_44380();
    }

    public List<Widget> method_25396() {
        return this.children;
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (this.scrolling.updateDraggingState(event.comp_4798(), event.comp_4799(), event.method_74245())) {
            return true;
        }
        return super.method_25402(event, doubleClick);
    }

    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.containsMouse(mouseX, mouseY) && amountY != 0.0) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
            return true;
        }
        return super.method_25401(mouseX, mouseY, amountX, amountY);
    }

    public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
        if (this.scrolling.mouseDragged(event.comp_4798(), event.comp_4799(), event.method_74245(), deltaX, deltaY)) {
            return true;
        }
        return super.method_25403(event, deltaX, deltaY);
    }

    private void updatePosition(float delta) {
        this.scrolling.updatePosition(delta);
    }

    public boolean method_25404(class_11908 event) {
        if (this.containsMouse(EntryStacksRegionWidget.mouse())) {
            for (Widget widget : this.method_25396()) {
                if (!widget.method_25404(event)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public DraggableComponent<Object> getHovered(DraggingContext<class_437> context, double mouseX, double mouseY) {
        if (this.innerBounds.contains(mouseX, mouseY)) {
            for (RealRegionEntry entry : this.entries.values()) {
                if (!entry.getWidget().containsMouse(mouseX, mouseY) || !this.listener.canBeDragged(entry)) continue;
                DraggableComponent<?> component = this.listener.convertToDraggableComponent(entry);
                return EntryStacksRegionWidget.wrapDraggable(component, this, entry);
            }
        }
        return null;
    }

    public static <T, E extends RegionEntry<E>> DraggableComponent<T> wrapDraggable(final DraggableComponent<T> component, final EntryStacksRegionWidget<E> region, final RealRegionEntry<E> entry) {
        return new DraggableComponent<T>(){
            private int previousIndex = -1;

            public T get() {
                return component.get();
            }

            public int getWidth() {
                return component.getWidth();
            }

            public int getHeight() {
                return component.getHeight();
            }

            public void drag() {
                if (region.listener.removeOnDrag()) {
                    this.previousIndex = region.indexOf(entry);
                    region.remove(entry, RemovalMode.MIGRATED);
                }
                component.drag();
            }

            public void release(DraggedAcceptorResult result) {
                component.release(result);
                if (result != DraggedAcceptorResult.CONSUMED) {
                    if (!entry.region.listener.removeOnDrag()) {
                        DraggingContext.getInstance().renderBack((DraggableComponent)this, DraggingContext.getInstance().getCurrentPosition(), () -> ((FloatingPoint)entry2.pos.value()).getLocation());
                    } else if (result == DraggedAcceptorResult.ACCEPTED) {
                        DraggingContext context = DraggingContext.getInstance();
                        double x = context.getCurrentPosition().x;
                        double y = (double)context.getCurrentPosition().y + entry.region.getScrollAmount();
                        entry.region.drop(entry, x, y, this.previousIndex);
                    } else {
                        entry.region.drop(entry);
                    }
                } else {
                    entry.region.listener.onConsumed(entry);
                }
            }

            public void render(class_332 graphics, Point position, int mouseX, int mouseY, float delta) {
                component.render(graphics, position, mouseX, mouseY, delta);
            }

            public void render(class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                component.render(graphics, bounds, mouseX, mouseY, delta);
            }
        };
    }

    public EntryStack<?> getFocusedStack() {
        Point mouse = EntryStacksRegionWidget.mouse();
        if (this.innerBounds.contains(mouse)) {
            for (RealRegionEntry entry : this.entries.values()) {
                if (!entry.getWidget().containsMouse(mouse)) continue;
                return entry.getWidget().getCurrentEntry().copy();
            }
        }
        return EntryStack.empty();
    }

    public Stream<EntryStack<?>> getEntries() {
        return this.entriesList.stream().filter(entry -> entry.getBounds().getMaxY() >= this.bounds.getY() && entry.getBounds().y <= this.bounds.getMaxY()).map(EntryWidget::getCurrentEntry).filter(entry -> !entry.isEmpty());
    }

    public DraggedAcceptorResult acceptDragged(DraggingContext<class_437> context, DraggableComponent<?> component) {
        return component.getIf((Object[])new EntryStack[0]).map(comp -> this.acceptDraggedStack(context, DraggableStack.from((DraggableComponent)comp))).orElse(this.innerBounds.contains(context.getCurrentPosition()) && this.drop(context, component) ? DraggedAcceptorResult.CONSUMED : DraggedAcceptorResult.PASS);
    }

    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<class_437> context, DraggableStack stack) {
        return this.checkDraggedStacks(context, stack).filter(entry -> this.innerBounds.contains(context.getCurrentPosition())).flatMap(entry -> {
            if (stack instanceof RegionDraggableStack && ((RegionDraggableStack)stack).getEntry().region == this && ((RegionDraggableStack)stack).getShowcaseWidget() == null) {
                return Optional.empty();
            }
            if (!this.drop((RealRegionEntry<T>)entry)) {
                return Optional.empty();
            }
            return Optional.of(class_3902.field_17274);
        }).isPresent() ? DraggedAcceptorResult.CONSUMED : DraggedAcceptorResult.PASS;
    }

    public boolean drop(DraggingContext<class_437> context, DraggableComponent<?> component) {
        T regionEntry = this.listener.convertDraggableComponent(context, component);
        if (regionEntry == null) {
            return false;
        }
        RealRegionEntry<T> entry = new RealRegionEntry<T>(this, regionEntry, EntryListWidget.entrySize());
        entry.size.setAs(EntryListWidget.entrySize() * 100);
        return this.drop(entry);
    }

    public Optional<RealRegionEntry<T>> checkDraggedStacks(DraggingContext<class_437> context, DraggableStack stack) {
        EntrySerializer serializer = stack.getStack().getDefinition().getSerializer();
        if (serializer != null) {
            try {
                Object regionEntry;
                Object object = regionEntry = stack instanceof RegionDraggableStack ? ((RegionDraggableStack)stack).getEntry().getEntry().copy() : this.listener.convertDraggableStack(context, stack);
                if (regionEntry == null) {
                    return Optional.empty();
                }
                RealRegionEntry<RegionEntry> entry = new RealRegionEntry<RegionEntry>(this, (RegionEntry)regionEntry, EntryListWidget.entrySize());
                entry.size.setAs(EntryListWidget.entrySize() * 100);
                return Optional.of(entry);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public void setEntries(List<T> newEntries, RemovalMode removalMode) {
        newEntries = Lists.newArrayList((Iterable)newEntries);
        newEntries.removeIf(entry -> entry == null || entry.isEntryInvalid());
        int entrySize = EntryListWidget.entrySize();
        IntOpenHashSet newFavoritesHash = new IntOpenHashSet((IntCollection)CollectionUtils.mapToInt((Collection)newEntries, RegionEntry::hashCode));
        ArrayList removedEntries = Lists.newArrayList((Iterable)this.entries.values());
        removedEntries.removeIf(arg_0 -> EntryStacksRegionWidget.lambda$setEntries$8((IntSet)newFavoritesHash, arg_0));
        if (!removedEntries.isEmpty() && removalMode == RemovalMode.THROW_EXCEPTION) {
            throw new IllegalStateException("Cannot remove entries from region " + String.valueOf((Object)this) + ": " + String.valueOf(removedEntries));
        }
        if (removalMode == RemovalMode.DISAPPEAR) {
            for (RealRegionEntry removedEntry : removedEntries) {
                removedEntry.remove();
                this.removedEntries.put(removedEntry.hashIgnoreAmount(), (Object)removedEntry);
            }
        }
        ArrayList<RealRegionEntry<RegionEntry>> addedEntries = new ArrayList<RealRegionEntry<RegionEntry>>();
        Int2ObjectOpenHashMap prevEntries = new Int2ObjectOpenHashMap(this.entries);
        this.entries.clear();
        for (RegionEntry regionEntry : newEntries) {
            RealRegionEntry<RegionEntry> realEntry = (RealRegionEntry<RegionEntry>)prevEntries.get(regionEntry.hashCode());
            if (realEntry == null) {
                realEntry = new RealRegionEntry<RegionEntry>(this, regionEntry, entrySize);
                addedEntries.add(realEntry);
            }
            if (ConfigObject.getInstance().isReducedMotion()) {
                realEntry.size.setAs(entrySize * 100);
            } else {
                realEntry.size.setTo(entrySize * 100, 300L);
            }
            this.entries.put(realEntry.hashIgnoreAmount(), realEntry);
        }
        this.applyNewEntriesList();
        this.updateEntriesPosition(arg_0 -> EntryStacksRegionWidget.lambda$setEntries$9((Int2ObjectMap)prevEntries, arg_0));
        for (RealRegionEntry realRegionEntry : removedEntries) {
            this.listener.onRemove(realRegionEntry);
        }
        for (RealRegionEntry realRegionEntry : addedEntries) {
            this.listener.onAdd(realRegionEntry);
        }
        this.listener.onSetNewEntries(this.entriesList);
        this.listener.onSetNewEntries(this.entriesList.stream().map(RegionEntryWidget::getEntry).map(RealRegionEntry::getEntry));
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public void applyNewEntriesList() {
        this.entriesList = Stream.concat(this.entries.values().stream().map(RealRegionEntry::getWidget), this.removedEntries.values().stream().map(RealRegionEntry::getWidget)).collect(Collectors.toList());
        this.children = Stream.of(this.entries.values().stream().map(RealRegionEntry::getWidget), this.removedEntries.values().stream().map(RealRegionEntry::getWidget)).flatMap(Function.identity()).collect(Collectors.toList());
    }

    public void updateEntriesPosition(Predicate<RealRegionEntry<T>> animated) {
        int entrySize = EntryListWidget.entrySize();
        this.blockedCount = 0;
        this.innerBounds = EntryStacksRegionWidget.updateInnerBounds(this.bounds);
        int width = this.innerBounds.width / entrySize;
        int currentX = 0;
        int currentY = 0;
        int releaseIndex = this.getReleaseIndex(null);
        int slotIndex = 0;
        block0: for (RealRegionEntry entry : this.entries.values()) {
            while (true) {
                int xPos = currentX * entrySize + this.innerBounds.x;
                int yPos = currentY * entrySize + this.innerBounds.y;
                if (++currentX >= width) {
                    currentX = 0;
                    ++currentY;
                }
                if (this.listener.notSteppingOnExclusionZones(xPos, yPos - this.scrolling.scrollAmountInt(), entrySize, entrySize)) {
                    if (slotIndex++ == releaseIndex) continue;
                    entry.moveTo(animated.test(entry), xPos, yPos);
                    continue block0;
                }
                ++this.blockedCount;
            }
        }
    }

    private int getReleaseIndex(@Nullable Point position) {
        boolean draggingComponent;
        DraggingContext context = DraggingContext.getInstance();
        if (position == null) {
            position = context.getCurrentPosition();
        }
        boolean draggingStack = context.isDraggingStack() && this.bounds.contains(position) && this.checkDraggedStacks((DraggingContext<class_437>)context.cast(), context.getCurrentStack()).isPresent();
        boolean bl = draggingComponent = draggingStack || context.isDraggingComponent() && this.bounds.contains(position) && this.listener.convertDraggableComponent((DraggingContext<class_437>)context.cast(), context.getDragged()) != null;
        if (draggingStack || draggingComponent) {
            int yPos;
            int xPos;
            int entrySize = EntryListWidget.entrySize();
            int width = this.innerBounds.width / entrySize;
            int currentX = 0;
            int currentY = 0;
            ArrayList entriesPoints = Lists.newArrayList();
            block0: for (RealRegionEntry entry : this.entries.values()) {
                while (true) {
                    int xPos2 = currentX * entrySize + this.innerBounds.x;
                    int yPos2 = currentY * entrySize + this.innerBounds.y;
                    if (++currentX >= width) {
                        currentX = 0;
                        ++currentY;
                    }
                    if (this.listener.notSteppingOnExclusionZones(xPos2, yPos2 - this.scrolling.scrollAmountInt(), entrySize, entrySize)) {
                        entriesPoints.add(new class_3545((Object)entry, (Object)new Point(xPos2, yPos2)));
                        continue block0;
                    }
                    ++this.blockedCount;
                }
            }
            int maxSize = entriesPoints.size();
            if (currentX != 0 && this.listener.notSteppingOnExclusionZones(xPos = currentX * entrySize + this.innerBounds.x, (yPos = currentY * entrySize + this.innerBounds.y) - this.scrolling.scrollAmountInt(), entrySize, entrySize)) {
                entriesPoints.add(new class_3545(null, (Object)new Point(xPos, yPos)));
            }
            double x = position.x - 8;
            double y = (double)position.y + this.scrolling.scrollAmount() - 8.0;
            return class_3532.method_15340((int)entriesPoints.stream().filter(value -> {
                double otherY = ((Point)value.method_15441()).y;
                return otherY <= y + (double)(entrySize / 2) && otherY + (double)entrySize > y + (double)(entrySize / 2);
            }).min(Comparator.comparingDouble(value -> {
                double otherX = ((Point)value.method_15441()).x;
                double otherY = ((Point)value.method_15441()).y;
                return (x - otherX) * (x - otherX) + (y - otherY) * (y - otherY);
            })).map(entriesPoints::indexOf).orElse(maxSize), (int)0, (int)entriesPoints.size());
        }
        return -2;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        int entrySize = EntryListWidget.entrySize();
        int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2 - 6) / (float)entrySize)), 1);
        if (!ConfigObject.getInstance().isLeftHandSidePanel()) {
            return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) + 3.0f), bounds.y, width * entrySize, bounds.height);
        }
        return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) - 3.0f), bounds.y, width * entrySize, bounds.height);
    }

    public boolean drop(RealRegionEntry<T> entry) {
        DraggingContext context = DraggingContext.getInstance();
        double x = context.getCurrentPosition().x;
        double y = (double)context.getCurrentPosition().y + this.scrolling.scrollAmount();
        return this.drop(entry, x, y);
    }

    public boolean drop(RealRegionEntry<T> entry, double x, double y) {
        boolean contains = this.bounds.contains(x, y);
        int newIndex = contains ? this.getReleaseIndex(new Point(x, y)) : Math.max(-1, Iterables.indexOf((Iterable)this.entries.values(), e -> e == entry));
        return this.drop(entry, x, y, newIndex < 0 ? this.entries.size() : newIndex);
    }

    public boolean drop(RealRegionEntry<T> entry, double x, double y, int newIndex) {
        if (newIndex < 0) {
            return this.drop(entry, x, y);
        }
        if (!this.listener.canAcceptDrop(entry)) {
            return false;
        }
        entry.pos.setAs((Object)new FloatingPoint(x - 8.0, y - 8.0));
        if (this.entries.size() <= newIndex) {
            RealRegionEntry remove = (RealRegionEntry)this.entries.remove(entry.hashIgnoreAmount());
            if (remove != null) {
                remove.remove();
                this.removedEntries.put(remove.hashIgnoreAmount(), (Object)remove);
            }
            this.entries.put(entry.hashIgnoreAmount(), entry);
        } else {
            Int2ObjectLinkedOpenHashMap prevEntries = new Int2ObjectLinkedOpenHashMap(this.entries);
            this.entries.clear();
            int index = 0;
            for (Int2ObjectMap.Entry entryEntry : prevEntries.int2ObjectEntrySet()) {
                if (index == newIndex) {
                    this.entries.put(entry.hashIgnoreAmount(), entry);
                }
                if (entryEntry.getIntKey() == entry.hashIgnoreAmount()) continue;
                this.entries.put(entryEntry.getIntKey(), (Object)((RealRegionEntry)entryEntry.getValue()));
                ++index;
            }
        }
        this.applyNewEntriesList();
        this.listener.onDrop(this.entries.values().stream().map(RealRegionEntry::getEntry));
        this.setEntries(this.entries.values().stream().map(RealRegionEntry::getEntry).collect(Collectors.toList()), RemovalMode.THROW_EXCEPTION);
        return true;
    }

    public int indexOf(RealRegionEntry<T> entry) {
        return this.entriesList.indexOf(entry.getWidget());
    }

    public void remove(RealRegionEntry<T> entry, RemovalMode mode) {
        RealRegionEntry currentEntry = (RealRegionEntry)this.entries.get(entry.hashIgnoreAmount());
        if (currentEntry != null) {
            List newEntries = CollectionUtils.map((Collection)this.entries.values(), RealRegionEntry::getEntry);
            newEntries.remove(currentEntry.getEntry());
            this.setEntries(newEntries, mode);
        }
    }

    public double getScrollAmount() {
        return this.scrolling.scrollAmount();
    }

    public boolean has(RealRegionEntry<T> entry) {
        return this.has(entry.getEntry());
    }

    public boolean has(T entry) {
        int hash = entry.hashCode();
        return this.entries.containsKey(hash) && !this.removedEntries.containsKey(hash);
    }

    public Rectangle getInnerBounds() {
        return this.innerBounds;
    }

    private static /* synthetic */ boolean lambda$setEntries$9(Int2ObjectMap prevEntries, RealRegionEntry entry) {
        return prevEntries.containsKey(entry.hashIgnoreAmount());
    }

    private static /* synthetic */ boolean lambda$setEntries$8(IntSet newFavoritesHash, RealRegionEntry entry) {
        return newFavoritesHash.contains(entry.hashIgnoreAmount());
    }

    public static enum RemovalMode {
        THROW_EXCEPTION,
        DISAPPEAR,
        MIGRATED;

    }
}

