/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.performance;

import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.entries.ToggleMenuEntry;
import me.shedaniel.rei.impl.client.gui.screen.ScreenWithMenu;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import java.util.*;
import java.util.function.Supplier;
import java.util.stream.Stream;

@Environment(EnvType.CLIENT)
public class DisplayRegistryInfoScreen extends ScreenWithMenu {
    private Runnable onClose;
    
    public DisplayRegistryInfoScreen(Runnable onClose) {
        super(class_2561.method_43471("text.rei.display_registry_analysis"));
        this.onClose = onClose;
    }
    
    private ListWidget list;
    private SortType sortType = SortType.ID;
    
    @Override
    public void method_25426() {
        {
            class_2561 backText = class_2561.method_43470("↩ ").method_10852(class_2561.method_43471("gui.back"));
            method_37063(new class_4185.class_12231(4, 4, class_310.method_1551().field_1772.method_27525(backText) + 10, 20, backText, button -> {
                this.onClose.run();
                this.onClose = null;
            }, Supplier::get) {});
        }
        {
            class_2561 text = class_2561.method_43471("text.rei.sort");
            Rectangle bounds = new Rectangle(this.field_22789 - 4 - class_310.method_1551().field_1772.method_27525(text) - 10, 4, class_310.method_1551().field_1772.method_27525(text) + 10, 20);
            method_37063(new class_4185.class_12231(bounds.x, bounds.y, bounds.width, bounds.height, text, button -> {
                this.setMenu(new Menu(bounds, CollectionUtils.map(SortType.values(), type -> {
                    return ToggleMenuEntry.of(class_2561.method_43469("text.rei.sort.by", type.name().toLowerCase(Locale.ROOT)), () -> false, o -> {
                        this.closeMenu();
                        this.sortType = type;
                        this.method_25423(this.field_22789, this.field_22790);
                    });
                }), false));
            }, Supplier::get) {});
        }
        list = new ListWidget();
        list.addItem(new EntryImpl(class_2561.method_43470("Total Displays"), DisplayRegistry.getInstance().size()));
        sort(DisplayRegistry.getInstance().getAll().entrySet().stream())
                .forEach(entry -> {
                    list.addItem(new EntryImpl(entry.getKey(), entry.getValue().size()));
                });
        method_25429(list);
    }
    
    private Stream<Map.Entry<CategoryIdentifier<?>, List<Display>>> sort(Stream<Map.Entry<CategoryIdentifier<?>, List<Display>>> stream) {
        return switch (sortType) {
            case COUNT -> stream.sorted(Comparator.<Map.Entry<CategoryIdentifier<?>, List<Display>>>comparingInt(value -> value.getValue().size()).reversed());
            case ID -> stream.sorted(Comparator.comparing(value -> value.getKey().toString()));
        };
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        list.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_35720(this.field_22793, this.field_22785.method_30937(), (int) (this.field_22789 / 2.0F - this.field_22793.method_27525(this.field_22785) / 2.0F), 12, -1);
    }
    
    public static abstract class ListEntry extends UpdatedListWidget.ElementEntry<ListEntry> {
    }
    
    private class ListWidget extends UpdatedListWidget<ListEntry> {
        public ListWidget() {
            super(DisplayRegistryInfoScreen.this.field_22787, DisplayRegistryInfoScreen.this.field_22789, DisplayRegistryInfoScreen.this.field_22790, 30, DisplayRegistryInfoScreen.this.field_22790);
        }
        
        @Override
        public int getItemWidth() {
            return width;
        }
        
        @Override
        public int addItem(ListEntry item) {
            return super.addItem(item);
        }
        
        @Override
        protected int getScrollbarPosition() {
            return width - 6;
        }
    }
    
    public static class EntryImpl extends ListEntry {
        private final class_2561 component;
        public final int count;
        
        public EntryImpl(CategoryIdentifier<?> identifier, int count) {
            this(class_2561.method_43470(identifier.getIdentifier().toString()), count);
        }
        
        public EntryImpl(class_2561 component, int count) {
            this.component = component;
            this.count = count;
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            graphics.method_35720(class_310.method_1551().field_1772, this.component.method_30937(), x + 4, y + 6, -1);
            class_5481 rightText = class_2561.method_43469("text.rei.display_registry_analysis.displays", count).method_30937();
            graphics.method_35720(class_310.method_1551().field_1772, rightText, x + entryWidth - 6 - 8 - class_310.method_1551().field_1772.method_30880(rightText), y + 6, -1);
        }
        
        @Override
        public int getItemHeight() {
            return 24;
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }
        
        @Override
        public List<? extends class_6379> narratables() {
            return Collections.emptyList();
        }
    }
    
    private enum SortType {
        COUNT,
        ID
    }
}
