/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.runtime;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Color;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.impl.client.gui.hints.HintProvider;
import me.shedaniel.rei.impl.client.search.argument.Argument;
import me.shedaniel.rei.impl.client.search.argument.ArgumentCache;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class SearchFilterPrepareWatcher
implements HintProvider {
    private Double lastProcess;

    @Override
    public List<Component> provide() {
        this.lastProcess = null;
        try {
            ArgumentCache cache = Argument.cache;
            if (cache.currentStep != null && cache.prepareStacks != null && cache.prepareStacks.size() > 100 && cache.prepareStart != null) {
                double lastProcess;
                if (Util.getEpochMillis() - cache.prepareStart < 100L) {
                    return Collections.emptyList();
                }
                int prepareStageCurrent = cache.currentStep.step;
                int prepareStageTotal = cache.currentStep.totalSteps;
                ArgumentCache.CurrentStep.Step currentStage = (ArgumentCache.CurrentStep.Step)ArrayUtils.get((Object[])cache.currentStep.steps, (int)(prepareStageCurrent - 1));
                int currentStageCurrent = currentStage == null ? 0 : currentStage.stacks;
                int currentStageTotal = currentStage == null ? 0 : currentStage.totalStacks;
                double prepareStageProgress = prepareStageTotal == 0 ? 0.0 : (double)prepareStageCurrent / (double)prepareStageTotal;
                double currentStageProgress = currentStageTotal == 0 ? 0.0 : (double)currentStageCurrent / (double)currentStageTotal;
                double d = lastProcess = prepareStageTotal == 0 ? 0.0 : Math.max(0.0, prepareStageProgress - (1.0 - currentStageProgress) / (double)prepareStageTotal);
                if (lastProcess < 0.05 || lastProcess > 0.95) {
                    return Collections.emptyList();
                }
                this.lastProcess = lastProcess;
                return ImmutableList.of((Object)Component.translatable((String)"text.rei.caching.search"), (Object)Component.translatable((String)"text.rei.caching.search.step", (Object[])new Object[]{prepareStageCurrent, prepareStageTotal, Math.round(lastProcess * 100.0)}));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public Tooltip provideTooltip(Point mouse) {
        return null;
    }

    @Override
    @Nullable
    public Double getProgress() {
        return this.lastProcess;
    }

    @Override
    public Color getColor() {
        return Color.ofTransparent((int)-2213633);
    }

    @Override
    public List<HintProvider.HintButton> getButtons() {
        return Collections.emptyList();
    }
}

