/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.entry;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.architectury.hooks.item.ItemStackHooks;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ItemEntryDefinition
implements EntryDefinition<ItemStack>,
EntrySerializer<ItemStack> {
    @OnlyIn(value=Dist.CLIENT)
    private EntryRenderer<ItemStack> renderer;
    private static final ReferenceSet<Item> SEARCH_BLACKLISTED = new ReferenceOpenHashSet();

    public ItemEntryDefinition() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> Client.init(this));
    }

    @Override
    public Class<ItemStack> getValueType() {
        return ItemStack.class;
    }

    @Override
    public EntryType<ItemStack> getType() {
        return VanillaEntryTypes.ITEM;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public EntryRenderer<ItemStack> getRenderer() {
        return this.renderer;
    }

    @Override
    @Nullable
    public ResourceLocation getIdentifier(EntryStack<ItemStack> entry, ItemStack value) {
        return BuiltInRegistries.ITEM.getKey((Object)value.getItem());
    }

    @Override
    public boolean isEmpty(EntryStack<ItemStack> entry, ItemStack value) {
        return value.isEmpty();
    }

    @Override
    public ItemStack copy(EntryStack<ItemStack> entry, ItemStack value) {
        return value.copy();
    }

    @Override
    public ItemStack normalize(EntryStack<ItemStack> entry, ItemStack value) {
        ItemStack copy = value.copy();
        copy.setCount(1);
        return copy;
    }

    @Override
    public ItemStack wildcard(EntryStack<ItemStack> entry, ItemStack value) {
        return new ItemStack((ItemLike)value.getItem(), 1);
    }

    @Override
    @Nullable
    public ItemStack cheatsAs(EntryStack<ItemStack> entry, ItemStack value) {
        return value.copy();
    }

    @Override
    @Nullable
    public ItemStack add(ItemStack o1, ItemStack o2) {
        return ItemStackHooks.copyWithCount((ItemStack)o1, (int)(o1.getCount() + o2.getCount()));
    }

    @Override
    public long hash(EntryStack<ItemStack> entry, ItemStack value, ComparisonContext context) {
        int code = 1;
        code = 31 * code + System.identityHashCode(value.getItem());
        code = 31 * code + Long.hashCode(ItemComparatorRegistry.getInstance().hashOf(context, value));
        return code;
    }

    @Override
    public boolean equals(ItemStack o1, ItemStack o2, ComparisonContext context) {
        if (o1.getItem() != o2.getItem()) {
            return false;
        }
        return ItemComparatorRegistry.getInstance().hashOf(context, o1) == ItemComparatorRegistry.getInstance().hashOf(context, o2);
    }

    @Override
    @Nullable
    public EntrySerializer<ItemStack> getSerializer() {
        return this;
    }

    @Override
    public boolean acceptsNull() {
        return false;
    }

    @Override
    public Codec<ItemStack> codec() {
        return ItemStack.CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ItemStack> streamCodec() {
        return ItemStack.OPTIONAL_STREAM_CODEC;
    }

    @Override
    public Component asFormattedText(EntryStack<ItemStack> entry, ItemStack value) {
        return this.asFormattedText(entry, value, TooltipContext.of(Item.TooltipContext.EMPTY));
    }

    @Override
    public Component asFormattedText(EntryStack<ItemStack> entry, ItemStack value, TooltipContext context) {
        if (!SEARCH_BLACKLISTED.contains((Object)value.getItem())) {
            try {
                return value.getHoverName();
            }
            catch (Throwable e) {
                if (context != null && context.isSearch()) {
                    throw e;
                }
                e.printStackTrace();
                SEARCH_BLACKLISTED.add((Object)value.getItem());
            }
        }
        try {
            return Component.literal((String)I18n.get((String)("item." + BuiltInRegistries.ITEM.getKey((Object)value.getItem()).toString().replace(":", ".")), (Object[])new Object[0]));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return Component.literal((String)"ERROR");
        }
    }

    @Override
    public Stream<? extends TagKey<?>> getTagsFor(EntryStack<ItemStack> entry, ItemStack value) {
        Stream tags = value.getTags();
        Item item = value.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            tags = Stream.concat(tags, blockItem.getBlock().builtInRegistryHolder().tags());
        }
        return tags;
    }

    @OnlyIn(value=Dist.CLIENT)
    private List<Component> tryGetItemStackToolTip(EntryStack<ItemStack> entry, ItemStack value, TooltipContext context) {
        if (!SEARCH_BLACKLISTED.contains((Object)value.getItem())) {
            try {
                return value.getTooltipLines(context.vanillaContext(), (Player)Minecraft.getInstance().player, context.getFlag());
            }
            catch (Throwable e) {
                if (context.isSearch()) {
                    throw e;
                }
                e.printStackTrace();
                SEARCH_BLACKLISTED.add((Object)value.getItem());
            }
        }
        return Lists.newArrayList((Object[])new Component[]{this.asFormattedText(entry, value, context)});
    }

    @Override
    public void fillCrashReport(CrashReport report, CrashReportCategory category, EntryStack<ItemStack> entry) {
        EntryDefinition.super.fillCrashReport(report, category, entry);
        ItemStack stack = entry.getValue();
        category.setDetail("Item Type", () -> String.valueOf(stack.getItem()));
        category.setDetail("Item Damage", () -> String.valueOf(stack.getDamageValue()));
        category.setDetail("Item Components", () -> DataComponentPatch.CODEC.encodeStart((DynamicOps)BasicDisplay.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)stack.getComponentsPatch()).result().map(Tag::toString).orElse("Error"));
        category.setDetail("Item Foil", () -> String.valueOf(stack.hasFoil()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private Client() {
        }

        private static void init(ItemEntryDefinition definition) {
            definition.renderer = definition.new ItemEntryRenderer();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ItemEntryRenderer
    implements EntryRenderer<ItemStack> {
        private static final float SCALE = 20.0f;
        public static final int ITEM_LIGHT = 0xF000F0;

        @Override
        public void render(EntryStack<ItemStack> entry, GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
            if (!entry.isEmpty()) {
                ItemStack value = entry.getValue();
                graphics.pose().pushMatrix();
                graphics.pose().translate((float)bounds.x, (float)bounds.y);
                graphics.pose().scale((float)bounds.getWidth() / 16.0f, (float)bounds.getHeight() / 16.0f);
                graphics.renderItem(value, 0, 0);
                if (!value.isEmpty()) {
                    graphics.renderItemDecorations(Minecraft.getInstance().font, value, 0, 0);
                }
                graphics.pose().popMatrix();
            }
        }

        @Override
        @Nullable
        public Tooltip getTooltip(EntryStack<ItemStack> entry, TooltipContext context) {
            if (entry.isEmpty()) {
                return null;
            }
            Tooltip tooltip = Tooltip.create(new Component[0]);
            Optional component = entry.getValue().getTooltipImage();
            List<Component> components = ItemEntryDefinition.this.tryGetItemStackToolTip(entry, entry.getValue(), context);
            if (!components.isEmpty()) {
                tooltip.add(components.get(0));
            }
            component.ifPresent(tooltip::add);
            for (int i = 1; i < components.size(); ++i) {
                tooltip.add(components.get(i));
            }
            return tooltip.withTooltipStyle((ResourceLocation)entry.getValue().get(DataComponents.TOOLTIP_STYLE));
        }
    }
}

