/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.displays;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.client.displays.ClientsidedRecipeBookDisplay;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.crafting.CraftingDisplay;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;

public abstract class ClientsidedCraftingDisplay
extends BasicDisplay
implements CraftingDisplay,
ClientsidedRecipeBookDisplay {
    private final Optional<RecipeDisplayId> id;

    public ClientsidedCraftingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<RecipeDisplayId> id) {
        super(inputs, outputs, Optional.empty());
        this.id = id;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.CRAFTING;
    }

    @Override
    public Optional<RecipeDisplayId> recipeDisplayId() {
        return this.id;
    }

    public static class Shapeless
    extends ClientsidedCraftingDisplay {
        public static final DisplaySerializer<Shapeless> SERIALIZER = DisplaySerializer.of(RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(BasicDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(BasicDisplay::getOutputEntries), (App)Codec.INT.xmap(RecipeDisplayId::new, RecipeDisplayId::index).optionalFieldOf("id").forGetter(ClientsidedCraftingDisplay::recipeDisplayId)).apply((Applicative)instance, Shapeless::new)), StreamCodec.composite((StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getInputEntries, (StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getOutputEntries, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT.map(RecipeDisplayId::new, RecipeDisplayId::index)), ClientsidedCraftingDisplay::recipeDisplayId, Shapeless::new), false);

        public Shapeless(ShapelessCraftingRecipeDisplay recipe, Optional<RecipeDisplayId> id) {
            super(EntryIngredients.ofSlotDisplays(recipe.ingredients()), List.of(EntryIngredients.ofSlotDisplay(recipe.result())), id);
        }

        public Shapeless(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<RecipeDisplayId> id) {
            super(inputs, outputs, id);
        }

        @Override
        public boolean isShapeless() {
            return true;
        }

        @Override
        public int getWidth() {
            return this.getInputEntries().size() > 4 ? 3 : 2;
        }

        @Override
        public int getHeight() {
            return this.getInputEntries().size() > 4 ? 3 : 2;
        }

        @Override
        public int getInputWidth(int craftingWidth, int craftingHeight) {
            return craftingWidth * craftingHeight <= this.getInputEntries().size() ? craftingWidth : Math.min(this.getInputEntries().size(), 3);
        }

        @Override
        public int getInputHeight(int craftingWidth, int craftingHeight) {
            return (int)Math.ceil((double)this.getInputEntries().size() / (double)this.getInputWidth(craftingWidth, craftingHeight));
        }

        @Override
        public DisplaySerializer<? extends Display> getSerializer() {
            return SERIALIZER;
        }
    }

    public static class Shaped
    extends ClientsidedCraftingDisplay {
        public static final DisplaySerializer<Shaped> SERIALIZER = DisplaySerializer.of(RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(BasicDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(BasicDisplay::getOutputEntries), (App)Codec.INT.xmap(RecipeDisplayId::new, RecipeDisplayId::index).optionalFieldOf("id").forGetter(ClientsidedCraftingDisplay::recipeDisplayId), (App)Codec.INT.fieldOf("width").forGetter(Shaped::getWidth), (App)Codec.INT.fieldOf("height").forGetter(Shaped::getHeight)).apply((Applicative)instance, Shaped::new)), StreamCodec.composite((StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getInputEntries, (StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getOutputEntries, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT.map(RecipeDisplayId::new, RecipeDisplayId::index)), ClientsidedCraftingDisplay::recipeDisplayId, (StreamCodec)ByteBufCodecs.INT, Shaped::getWidth, (StreamCodec)ByteBufCodecs.INT, Shaped::getHeight, Shaped::new), false);
        private final int width;
        private final int height;

        public Shaped(ShapedCraftingRecipeDisplay recipe, Optional<RecipeDisplayId> id) {
            super(EntryIngredients.ofSlotDisplays(recipe.ingredients()), List.of(EntryIngredients.ofSlotDisplay(recipe.result())), id);
            this.width = recipe.width();
            this.height = recipe.height();
        }

        public Shaped(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<RecipeDisplayId> id, int width, int height) {
            super(inputs, outputs, id);
            this.width = width;
            this.height = height;
        }

        @Override
        public boolean isShapeless() {
            return false;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public DisplaySerializer<? extends Display> getSerializer() {
            return SERIALIZER;
        }
    }
}

