/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.registry.displays;

import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.impl.common.registry.displays.DisplayKey;
import me.shedaniel.rei.impl.common.registry.displays.DisplaysHolder;
import me.shedaniel.rei.impl.common.registry.displays.RemappingMap;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class DisplaysHolderImpl
implements DisplaysHolder {
    private final Map<CategoryIdentifier<?>, DisplaysList> displays = new ConcurrentHashMap();
    private final Map<CategoryIdentifier<?>, List<Display>> unmodifiableDisplays = new RemappingMap<CategoryIdentifier, DisplaysList>(Collections.unmodifiableMap(this.displays), list -> {
        if (list == null) {
            return null;
        }
        return ((DisplaysList)list).synchronizedList;
    }, this::checkCategory);
    protected final WeakHashMap<Display, Object> originsMap = new WeakHashMap();
    private final MutableInt displayCount = new MutableInt(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Display display, @Nullable Object origin) {
        this.displays.computeIfAbsent(display.getCategoryIdentifier(), location -> new DisplaysList()).add(display);
        this.displayCount.increment();
        if (origin != null) {
            WeakHashMap<Display, Object> weakHashMap = this.originsMap;
            synchronized (weakHashMap) {
                this.originsMap.put(display, origin);
            }
        }
    }

    @Override
    public boolean remove(Display display) {
        if (this.displays.get(display.getCategoryIdentifier()).remove(display)) {
            this.removeFallout(display);
            if (this.displays.get(display.getCategoryIdentifier()).isEmpty()) {
                this.displays.remove(display.getCategoryIdentifier());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFallout(Display display) {
        this.displayCount.decrement();
        WeakHashMap<Display, Object> weakHashMap = this.originsMap;
        synchronized (weakHashMap) {
            this.originsMap.remove(display);
        }
    }

    @Override
    public int size() {
        return this.displayCount.intValue();
    }

    @Override
    public Map<CategoryIdentifier<?>, List<Display>> getUnmodifiable() {
        return this.unmodifiableDisplays;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object getDisplayOrigin(Display display) {
        WeakHashMap<Display, Object> weakHashMap = this.originsMap;
        synchronized (weakHashMap) {
            Object origin = this.originsMap.get(display);
            if (origin != null) {
                return origin;
            }
        }
        return null;
    }

    protected boolean checkCategory(CategoryIdentifier<?> key) {
        return true;
    }

    private static class DisplaysList
    extends ArrayList<Display> {
        private final List<Display> synchronizedList;

        public DisplaysList() {
            List<Display> unmodifiableList = Collections.unmodifiableList(this);
            this.synchronizedList = Collections.synchronizedList(unmodifiableList);
        }
    }

    public static class ByKey
    extends DisplaysHolderImpl
    implements DisplaysHolder.ByKey {
        private final SetMultimap<DisplayKey, Display> displaysByKey = Multimaps.newSetMultimap(new IdentityHashMap(), ReferenceOpenHashSet::new);

        @Override
        public void add(Display display, @Nullable Object origin) {
            super.add(display, origin);
            Optional<ResourceLocation> location = display.getDisplayLocation();
            if (location.isPresent()) {
                this.displaysByKey.put((Object)DisplayKey.create(display.getCategoryIdentifier(), location.get()), (Object)display);
            }
        }

        @Override
        protected void removeFallout(Display display) {
            Optional<ResourceLocation> location = display.getDisplayLocation();
            if (location.isPresent()) {
                this.displaysByKey.remove((Object)DisplayKey.create(display.getCategoryIdentifier(), location.get()), (Object)display);
            }
            super.removeFallout(display);
        }

        @Override
        public Set<Display> getDisplaysByKey(DisplayKey key) {
            return this.displaysByKey.get((Object)key);
        }
    }
}

