/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.favorites.trash;

import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.client.gui.widget.favorites.panel.FavoritesPanel;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class TrashWidget
extends WidgetWithBounds {
    private final Rectangle bounds = new Rectangle();
    private final FavoritesListWidget parent;
    private final NumberAnimator<Double> height;
    private double lastProgress;

    public TrashWidget(FavoritesListWidget parent) {
        this.parent = parent;
        this.height = ValueAnimator.ofDouble().withConvention(() -> {
            Rectangle fullBounds = this.parent.favoritesBounds;
            if (DraggingContext.getInstance().isDraggingComponent() && fullBounds.contains(DraggingContext.getInstance().getCurrentPosition())) {
                return Math.min(60.0, (double)fullBounds.height * 0.23);
            }
            return 0.0;
        }, ValueAnimator.typicalTransitionTime());
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.updateBounds(delta)) {
            float opacity = (Mth.cos((float)((float)((double)((float)(System.currentTimeMillis() % 2000L) / 1000.0f) * Math.PI))) + 1.0f) / 2.0f;
            if (ConfigObject.getInstance().isReducedMotion()) {
                opacity = 0.75f;
            }
            int alpha = 18 + (int)(34.0 * this.lastProgress * (double)opacity);
            graphics.fillGradient(this.bounds.x, this.bounds.y, this.bounds.getMaxX(), this.bounds.getMaxY(), 0xFFFFFF | alpha << 24, 0xFFFFFF | alpha << 24);
            int lineColor = (int)(96.0 * this.lastProgress) << 24 | 0xFFFFFF;
            graphics.fillGradient(this.bounds.x, this.bounds.y, this.bounds.getMaxX(), this.bounds.y + 1, lineColor, lineColor);
            graphics.fillGradient(this.bounds.x, this.bounds.getMaxY() - 1, this.bounds.getMaxX(), this.bounds.getMaxY(), lineColor, lineColor);
            graphics.fillGradient(this.bounds.x, this.bounds.y + 1, this.bounds.x + 1, this.bounds.getMaxY() - 1, lineColor, lineColor);
            graphics.fillGradient(this.bounds.getMaxX() - 1, this.bounds.y + 1, this.bounds.getMaxX(), this.bounds.getMaxY() - 1, lineColor, lineColor);
            MutableComponent text = Component.translatable((String)"text.rei.dispose_here");
            if (170.0 * this.lastProgress > 4.0) {
                graphics.drawString(this.font, (Component)text, this.bounds.getCenterX() - this.font.width((FormattedText)text) / 2, this.bounds.getCenterY() - 4, (int)(170.0 * this.lastProgress) << 24 | 0xFFFFFF, false);
            }
        }
    }

    public boolean updateBounds(float delta) {
        if (ConfigObject.getInstance().isReducedMotion()) {
            this.height.setAs((Number)((Double)this.height.target()));
        }
        this.height.update((double)delta);
        double trashBoundsHeight = (Double)this.height.value();
        if (Math.round(trashBoundsHeight) > 0L) {
            Rectangle fullBounds = this.parent.favoritesBounds;
            FavoritesPanel favoritePanel = this.parent.favoritePanel;
            double heightTarget = Math.min(150.0, (double)fullBounds.height * 0.23);
            this.lastProgress = Math.pow(Mth.clamp((double)(trashBoundsHeight / heightTarget), (double)0.0, (double)1.0), 7.0);
            int y = fullBounds.getMaxY() - 4 - favoritePanel.getBounds().height;
            this.bounds.setBounds(fullBounds.x + 4, (int)Math.round((double)y - trashBoundsHeight), fullBounds.width - 8, (int)Math.round(trashBoundsHeight - 4.0));
            return true;
        }
        this.bounds.setBounds(0, 0, 0, 0);
        this.lastProgress = 0.0;
        return false;
    }

    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }

    public double getHeight() {
        return (Double)this.height.value();
    }
}

