/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueProvider;
import me.shedaniel.math.Color;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;

public class ButtonWidget
extends Button {
    private static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/button"), ResourceLocation.withDefaultNamespace((String)"widget/button_disabled"), ResourceLocation.withDefaultNamespace((String)"widget/button_highlighted"));
    private static final WidgetSprites DARK_SPRITES = new WidgetSprites(ResourceLocation.parse((String)"roughlyenoughitems:widget/button_dark"), ResourceLocation.parse((String)"roughlyenoughitems:widget/button_disabled_dark"), ResourceLocation.parse((String)"roughlyenoughitems:widget/button_highlighted_dark"));
    private Rectangle bounds;
    private boolean enabled = true;
    private Component text;
    @Nullable
    private Integer tint;
    @Nullable
    private Consumer<Button> onClick;
    @Nullable
    private BiConsumer<GuiGraphics, Button> onRender;
    private boolean focusable = false;
    private boolean focused = false;
    @Nullable
    private @Nullable Function<Button, @Nullable Component[]> tooltipFunction;
    @Nullable
    private BiFunction<Button, Point, Integer> textColorFunction;
    private final ValueAnimator<Color> darkBackground;
    private ValueProvider<Double> alpha;

    public ButtonWidget(Rectangle rectangle, Component text) {
        this.bounds = Objects.requireNonNull(rectangle);
        this.text = Objects.requireNonNull(text);
        this.darkBackground = ValueAnimator.ofColor().withConvention(() -> Color.ofTransparent((int)(REIRuntime.getInstance().isDarkThemeEnabled() ? -1 : 0xFFFFFF)), ValueAnimator.typicalTransitionTime());
        this.alpha = ValueProvider.constant((Object)1.0);
    }

    @Override
    public final boolean isFocused() {
        return this.focused;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public final OptionalInt getTint() {
        return OptionalInt.empty();
    }

    @Override
    public final void setTint(int tint) {
        this.tint = tint;
    }

    @Override
    public final void removeTint() {
        this.tint = null;
    }

    @Override
    public final Component getText() {
        return this.text;
    }

    @Override
    public final void setText(Component text) {
        this.text = text;
    }

    @Override
    @Nullable
    public final Consumer<Button> getOnClick() {
        return this.onClick;
    }

    @Override
    public final void setOnClick(@Nullable Consumer<Button> onClick) {
        this.onClick = onClick;
    }

    @Override
    @Nullable
    public final BiConsumer<GuiGraphics, Button> getOnRender() {
        return this.onRender;
    }

    @Override
    public final void setOnRender(BiConsumer<GuiGraphics, Button> onRender) {
        this.onRender = onRender;
    }

    @Override
    public final boolean isFocusable() {
        return this.focusable;
    }

    @Override
    public final void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    public void setAlpha(ValueProvider<Double> alpha) {
        this.alpha = alpha;
    }

    @Override
    @Nullable
    public final Component[] getTooltip() {
        if (this.tooltipFunction == null) {
            return null;
        }
        return this.tooltipFunction.apply(this);
    }

    @Override
    public final void setTooltip(@Nullable @Nullable Function<Button, @Nullable Component[]> tooltip) {
        this.tooltipFunction = tooltip;
    }

    @Override
    public final void setTextColor(@Nullable BiFunction<Button, Point, Integer> textColorFunction) {
        this.textColorFunction = textColorFunction;
    }

    @Override
    public final int getTextColor(Point mouse) {
        Integer apply;
        if (this.textColorFunction != null && (apply = this.textColorFunction.apply(this, mouse)) != null) {
            return apply;
        }
        if (!this.enabled) {
            return 0xA0A0A0;
        }
        if (this.isFocused(mouse.x, mouse.y)) {
            return 0xFFFFA0;
        }
        return 0xE0E0E0;
    }

    @Override
    public final Rectangle getBounds() {
        return this.bounds;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Component[] tooltip;
        this.darkBackground.update((double)delta);
        this.alpha.update((double)delta);
        if (this.onRender != null) {
            this.onRender.accept(graphics, this);
        }
        int x = this.bounds.x;
        int y = this.bounds.y;
        int width = this.bounds.width;
        int height = this.bounds.height;
        int alphaAsInt = (int)((Double)this.alpha.value() * 255.0);
        this.renderBackground(graphics, x, y, width, height, this.isFocused(mouseX, mouseY), false, Color.ofTransparent((int)(0xFFFFFF | alphaAsInt << 24)));
        Color darkBackgroundColor = (Color)this.darkBackground.value();
        darkBackgroundColor = Color.ofRGBA((int)darkBackgroundColor.getRed(), (int)darkBackgroundColor.getGreen(), (int)darkBackgroundColor.getBlue(), (int)((int)Math.round((double)darkBackgroundColor.getAlpha() * (Double)this.alpha.value())));
        this.renderBackground(graphics, x, y, width, height, this.isFocused(mouseX, mouseY), true, darkBackgroundColor);
        int color = 0xE0E0E0;
        if (!this.enabled) {
            color = 0xA0A0A0;
        } else if (this.isFocused(mouseX, mouseY)) {
            color = 0xFFFFA0;
        }
        if (this.tint != null) {
            graphics.fillGradient(x + 1, y + 1, x + width - 1, y + height - 1, this.tint.intValue(), this.tint.intValue());
        }
        if (alphaAsInt > 10) {
            graphics.drawCenteredString(this.font, this.getText(), x + width / 2, y + (height - 8) / 2, color | alphaAsInt << 24);
        }
        if ((tooltip = this.getTooltip()) != null) {
            if (!this.focused && this.containsMouse(mouseX, mouseY)) {
                Tooltip.create(tooltip).queue();
            } else if (this.focused) {
                Tooltip.create(new Point(x + width / 2, y + height / 2), tooltip).queue();
            }
        }
    }

    protected boolean isFocused(int mouseX, int mouseY) {
        return this.containsMouse(mouseX, mouseY) || this.focused;
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        return this.enabled && this.focusable ? ComponentPath.leaf((GuiEventListener)this) : null;
    }

    @Override
    public void onClick() {
        Consumer<Button> onClick = this.getOnClick();
        if (onClick != null) {
            onClick.accept(this);
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.containsMouse(event.x(), event.y()) && this.isEnabled() && event.button() == 0) {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            this.onClick();
            return true;
        }
        return false;
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.isEnabled() && this.focused) {
            if (event.key() != 257 && event.key() != 32 && event.key() != 335) {
                return false;
            }
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            this.onClick();
            return true;
        }
        return false;
    }

    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }

    protected void renderBackground(GuiGraphics graphics, int x, int y, int width, int height, boolean focused) {
        this.renderBackground(graphics, x, y, width, height, focused, REIRuntime.getInstance().isDarkThemeEnabled(), Color.ofTransparent((int)-1));
    }

    protected void renderBackground(GuiGraphics graphics, int x, int y, int width, int height, boolean focused, boolean dark, Color color) {
        WidgetSprites sprites = dark ? DARK_SPRITES : SPRITES;
        ResourceLocation texture = sprites.get(this.isEnabled(), focused);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, texture, x, y, width, height, color.getColor());
    }
}

