/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;

public final class ArrowWidget
extends Arrow {
    private Rectangle bounds;
    private double animationDuration = -1.0;
    private NumberAnimator<Float> darkBackgroundAlpha = ValueAnimator.ofFloat().withConvention(() -> Float.valueOf(REIRuntime.getInstance().isDarkThemeEnabled() ? 1.0f : 0.0f), ValueAnimator.typicalTransitionTime()).asFloat();

    public ArrowWidget(Rectangle bounds) {
        this.bounds = new Rectangle(Objects.requireNonNull(bounds));
    }

    @Override
    public double getAnimationDuration() {
        return this.animationDuration;
    }

    @Override
    public void setAnimationDuration(double animationDurationMS) {
        this.animationDuration = animationDurationMS;
        if (this.animationDuration <= 0.0) {
            this.animationDuration = -1.0;
        }
    }

    @ApiStatus.Internal
    public void setDarkBackgroundAlpha(NumberAnimator<Float> darkBackgroundAlpha) {
        this.darkBackgroundAlpha = darkBackgroundAlpha;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.darkBackgroundAlpha.update((double)delta);
        this.renderBackground(graphics, false, 1.0f);
        if (((Float)this.darkBackgroundAlpha.value()).floatValue() > 0.0f) {
            this.renderBackground(graphics, true, ((Float)this.darkBackgroundAlpha.value()).floatValue());
        }
    }

    public void renderBackground(GuiGraphics graphics, boolean dark, float alpha) {
        ResourceLocation texture = REIRuntime.getInstance().getDefaultDisplayTexture(dark);
        if (this.getAnimationDuration() > 0.0) {
            int width = Mth.ceil((double)((double)System.currentTimeMillis() / (this.animationDuration / 24.0) % 24.0));
            graphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.getX() + width, this.getY(), (float)(106 + width), 91.0f, 24 - width, 17, 256, 256, 0xFFFFFF | (int)(alpha * 255.0f) << 24);
            graphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.getX(), this.getY(), 82.0f, 91.0f, width, 17, 256, 256, 0xFFFFFF | (int)(alpha * 255.0f) << 24);
        } else {
            graphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.getX(), this.getY(), 106.0f, 91.0f, 24, 17, 256, 256, 0xFFFFFF | (int)(alpha * 255.0f) << 24);
        }
    }

    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }
}

