/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;

public class MergedWidgetWithBounds
extends WidgetWithBounds {
    private final Supplier<Rectangle> bounds;
    private final List<Widget> widgets;

    public MergedWidgetWithBounds(Supplier<Rectangle> bounds, List<Widget> widgets) {
        this.bounds = bounds;
        this.widgets = widgets;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        for (Widget widget : this.widgets) {
            widget.render(graphics, mouseX, mouseY, delta);
        }
    }

    public List<? extends GuiEventListener> children() {
        return this.widgets;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        for (Widget widget : this.widgets) {
            if (!widget.mouseScrolled(mouseX, mouseY, amountX, amountY)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(KeyEvent event) {
        for (Widget widget : this.widgets) {
            if (!widget.keyPressed(event)) continue;
            return true;
        }
        return false;
    }

    public boolean keyReleased(KeyEvent event) {
        for (Widget widget : this.widgets) {
            if (!widget.keyReleased(event)) continue;
            return true;
        }
        return false;
    }

    public boolean charTyped(CharacterEvent event) {
        for (Widget widget : this.widgets) {
            if (!widget.charTyped(event)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(MouseButtonEvent event, double deltaX, double deltaY) {
        for (Widget widget : this.widgets) {
            if (!widget.mouseDragged(event, deltaX, deltaY)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        for (Widget widget : this.widgets) {
            if (!widget.mouseReleased(event)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getZRenderingPriority() {
        return CollectionUtils.max(this.widgets, Comparator.comparingDouble(Widget::getZRenderingPriority)).map(Widget::getZRenderingPriority).orElse(0.0);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds.get();
    }

    @Override
    @Deprecated
    public void render(GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
        Rectangle clone = this.getBounds().clone();
        this.getBounds().setBounds(bounds);
        this.render(graphics, mouseX, mouseY, delta);
        this.getBounds().setBounds(clone);
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return this.getBounds().contains(mouseX, mouseY);
    }

    public Optional<GuiEventListener> getChildAt(double mouseX, double mouseY) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.containsMouse(mouseX, mouseY)) continue;
            return Optional.of(widget);
        }
        return Optional.empty();
    }
}

