/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen.collapsible.selection;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.search.SearchProvider;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.search.OverlaySearchField;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CustomCollapsibleEntrySelectionScreen
extends Screen {
    private final List<EntryStack<?>> selectedStacks;
    protected List<EntryStack<?>> selected = Lists.newArrayList();
    protected final ScrollingContainer scrolling = new ScrollingContainer(){

        public int getMaxScrollHeight() {
            return Mth.ceil((float)((float)CustomCollapsibleEntrySelectionScreen.this.entryStacks.size() / ((float)CustomCollapsibleEntrySelectionScreen.this.innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize() + 28;
        }

        public Rectangle getBounds() {
            return CustomCollapsibleEntrySelectionScreen.this.getBounds();
        }

        public int getScrollBarX(int maxX) {
            return CustomCollapsibleEntrySelectionScreen.this.width - 7;
        }
    };
    public Screen parent;
    private Tooltip tooltip = null;
    private List<EntryStack<?>> entryStacks = null;
    private Rectangle innerBounds;
    private List<InnerStackEntry> entries = Collections.emptyList();
    private List<GuiEventListener> elements = Collections.emptyList();
    private final List<PointPair> points = new ArrayList<PointPair>();
    private final OverlaySearchField searchField;
    private final Button selectAllButton;
    private final Button selectNoneButton;
    private final Button addButton;
    private final Button removeButton;
    private final Button backButton;
    private Predicate<Rectangle> selectionCache;
    private SearchFilter lastFilter = SearchFilter.matchAll();

    public CustomCollapsibleEntrySelectionScreen(List<EntryStack<?>> selectedStacks) {
        super((Component)Component.translatable((String)"text.rei.collapsible.entries.custom.title"));
        this.selectedStacks = selectedStacks;
        this.searchField = new OverlaySearchField(0, 0, 0, 0);
        MutableComponent selectAllText = Component.translatable((String)"config.roughlyenoughitems.filteredEntries.selectAll");
        this.selectAllButton = new Button(this, 0, 0, Minecraft.getInstance().font.width((FormattedText)selectAllText) + 10, 20, (Component)selectAllText, button -> {
            this.points.clear();
            this.points.add(new PointPair(new Point(-1073741823, -1073741823), new Point(0x3FFFFFFF, 0x3FFFFFFF)));
        }, Supplier::get){};
        MutableComponent selectNoneText = Component.translatable((String)"config.roughlyenoughitems.filteredEntries.selectNone");
        this.selectNoneButton = new Button(this, 0, 0, Minecraft.getInstance().font.width((FormattedText)selectNoneText) + 10, 20, (Component)selectNoneText, button -> this.points.clear(), Supplier::get){};
        MutableComponent addText = Component.translatable((String)"text.rei.collapsible.entries.custom.select.add");
        this.addButton = new Button(this, 0, 0, Minecraft.getInstance().font.width((FormattedText)addText) + 10, 20, (Component)addText, button -> {
            for (int i = 0; i < this.entryStacks.size(); ++i) {
                EntryStack<?> stack = this.entryStacks.get(i);
                InnerStackEntry entry = this.entries.get(i);
                entry.getBounds().y = entry.backupY - this.scrolling.scrollAmountInt();
                if (!entry.isSelected() || entry.isFiltered()) continue;
                selectedStacks.add(stack);
                entry.dirty = true;
            }
        }, Supplier::get){};
        MutableComponent removeText = Component.translatable((String)"text.rei.collapsible.entries.custom.select.remove");
        this.removeButton = new Button(this, 0, 0, Minecraft.getInstance().font.width((FormattedText)removeText) + 10, 20, (Component)removeText, button -> {
            for (int i = 0; i < this.entryStacks.size(); ++i) {
                EntryStack<?> stack = this.entryStacks.get(i);
                InnerStackEntry entry = this.entries.get(i);
                entry.getBounds().y = entry.backupY - this.scrolling.scrollAmountInt();
                if (!entry.isSelected() || !selectedStacks.remove(stack)) continue;
                entry.dirty = true;
            }
        }, Supplier::get){};
        MutableComponent backText = Component.literal((String)"\u21a9 ").append((Component)Component.translatable((String)"gui.back"));
        this.backButton = new Button(this, 0, 0, Minecraft.getInstance().font.width((FormattedText)backText) + 10, 20, (Component)backText, button -> {
            this.minecraft.setScreen(this.parent);
            this.parent = null;
        }, Supplier::get){};
        this.searchField.isMain = false;
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
        this.parent = null;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        int width = Math.max(Mth.floor((float)((float)(bounds.width - 2 - 6) / (float)EntryListWidget.entrySize())), 1);
        return new Rectangle((int)((float)bounds.getCenterX() - (float)(width * EntryListWidget.entrySize()) / 2.0f), bounds.y + 5, width * EntryListWidget.entrySize(), bounds.height);
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 30, this.width, this.height - 30);
    }

    public void init() {
        super.init();
        Rectangle bounds = this.getBounds();
        this.updateSearch(this.searchField.getText());
        this.selectAllButton.setX(2);
        this.selectAllButton.setY(bounds.getMaxY() - 22);
        this.selectNoneButton.setX(4 + this.selectAllButton.getWidth());
        this.selectNoneButton.setY(bounds.getMaxY() - 22);
        int searchFieldWidth = Math.max(bounds.width - (this.selectNoneButton.getX() + this.selectNoneButton.getWidth() + this.addButton.getWidth() + this.removeButton.getWidth() + 12), 100);
        this.searchField.getBounds().setBounds(this.selectNoneButton.getX() + this.selectNoneButton.getWidth() + 4, bounds.getMaxY() - 21, searchFieldWidth, 18);
        this.addButton.setX(bounds.getMaxX() - this.addButton.getWidth() - this.removeButton.getWidth() - 4);
        this.addButton.setY(bounds.getMaxY() - 22);
        this.removeButton.setX(bounds.getMaxX() - this.removeButton.getWidth() - 2);
        this.removeButton.setY(bounds.getMaxY() - 22);
        this.backButton.setX(4);
        this.backButton.setY(4);
        this.searchField.setResponder(this::updateSearch);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int nextIndex;
        super.render(graphics, mouseX, mouseY, delta);
        this.updateSelectionCache();
        Rectangle bounds = this.getBounds();
        this.tooltip = null;
        UpdatedListWidget.renderAs(this.minecraft, this.width, this.height, bounds.y, this.height, graphics, delta);
        if (bounds.isEmpty()) {
            return;
        }
        graphics.enableScissor(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY());
        for (InnerStackEntry entry : this.entries) {
            entry.clearStacks();
        }
        int skip = Math.max(0, Mth.floor((double)(this.scrolling.scrollAmount() / (double)EntryListWidget.entrySize())));
        for (int i = nextIndex = skip * this.innerBounds.width / EntryListWidget.entrySize(); i < this.entryStacks.size(); ++i) {
            EntryStack<?> stack = this.entryStacks.get(i);
            InnerStackEntry entry = this.entries.get(nextIndex);
            entry.getBounds().y = entry.backupY - this.scrolling.scrollAmountInt();
            if (entry.getBounds().y > bounds.getMaxY()) break;
            entry.entry((EntryStack)stack);
            entry.render(graphics, mouseX, mouseY, delta);
            ++nextIndex;
        }
        this.updatePosition(delta);
        this.scrolling.renderScrollBar(graphics, 0, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        this.searchField.render(graphics, mouseX, mouseY, delta);
        this.selectAllButton.render(graphics, mouseX, mouseY, delta);
        this.selectNoneButton.render(graphics, mouseX, mouseY, delta);
        this.addButton.render(graphics, mouseX, mouseY, delta);
        this.removeButton.render(graphics, mouseX, mouseY, delta);
        graphics.disableScissor();
        graphics.fillGradient(0, bounds.y, this.width, bounds.y + 4, -16777216, 0);
        this.backButton.render(graphics, mouseX, mouseY, delta);
        if (this.tooltip != null) {
            ScreenOverlayImpl.getInstance().renderTooltip(graphics, this.tooltip);
        }
        graphics.drawString(this.font, this.title.getVisualOrderText(), this.width / 2 - this.font.width((FormattedText)this.title) / 2, 12, -1);
        MutableComponent hint = Component.translatable((String)"config.roughlyenoughitems.filteringRulesScreen.hint").withStyle(ChatFormatting.YELLOW);
        graphics.drawString(this.font, (Component)hint, this.width - this.font.width((FormattedText)hint) - 15, 12, -1);
    }

    private Predicate<Rectangle> getSelection() {
        return this.selectionCache;
    }

    private void updateSelectionCache() {
        if (!this.points.isEmpty()) {
            Predicate<Rectangle> predicate = rect -> false;
            for (PointPair pair : this.points) {
                Point firstPoint = pair.firstPoint();
                Point secondPoint = pair.secondPoint();
                if (secondPoint == null) {
                    secondPoint = PointHelper.ofMouse();
                    secondPoint.translate(0, this.scrolling.scrollAmountInt());
                }
                int left = Math.min(firstPoint.x, secondPoint.x);
                int top = Math.min(firstPoint.y, secondPoint.y);
                int right = Math.max(firstPoint.x, secondPoint.x);
                int bottom = Math.max(firstPoint.y, secondPoint.y);
                Rectangle rectangle = new Rectangle(left, top - this.scrolling.scrollAmountInt(), Math.max(1, right - left), Math.max(1, bottom - top));
                predicate = predicate.or(arg_0 -> ((Rectangle)rectangle).intersects(arg_0));
            }
            this.selectionCache = predicate;
            return;
        }
        this.selectionCache = rect -> false;
    }

    public boolean mouseDragged(MouseButtonEvent event, double deltaX, double deltaY) {
        if (this.scrolling.mouseDragged(event.x(), event.y(), event.button(), deltaX, deltaY)) {
            return true;
        }
        return super.mouseDragged(event, deltaX, deltaY);
    }

    private void updatePosition(float delta) {
        this.scrolling.updatePosition(delta);
    }

    public void updateSearch(String searchTerm) {
        this.lastFilter = SearchProvider.getInstance().createFilter(searchTerm);
        LinkedHashSet list = Sets.newLinkedHashSet();
        ((Stream)EntryRegistry.getInstance().getEntryStacks().parallel()).filter(this::matches).map(EntryStack::normalize).forEachOrdered(list::add);
        this.entryStacks = Lists.newArrayList((Iterable)list);
        this.updateEntriesPosition();
    }

    public boolean matches(EntryStack<?> stack) {
        EntrySerializer<?> serializer = stack.getDefinition().getSerializer();
        if (serializer == null) {
            return false;
        }
        return this.lastFilter.test(stack);
    }

    public void updateEntriesPosition() {
        int entrySize = EntryListWidget.entrySize();
        this.innerBounds = CustomCollapsibleEntrySelectionScreen.updateInnerBounds(this.getBounds());
        int width = this.innerBounds.width / entrySize;
        int pageHeight = this.innerBounds.height / entrySize;
        int slotsToPrepare = Math.max(this.entryStacks.size() * 3, width * pageHeight * 3);
        int currentX = 0;
        int currentY = 0;
        ArrayList entries = Lists.newArrayList();
        for (int i = 0; i < slotsToPrepare; ++i) {
            int xPos = currentX * entrySize + this.innerBounds.x;
            int yPos = currentY * entrySize + this.innerBounds.y;
            entries.add(new InnerStackEntry(xPos, yPos, entrySize));
            if (++currentX < width) continue;
            currentX = 0;
            ++currentY;
        }
        this.entries = entries;
        this.elements = Lists.newArrayList((Iterable)entries);
        this.elements.add((GuiEventListener)this.searchField);
    }

    public List<? extends GuiEventListener> children() {
        return this.elements;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.scrolling.updateDraggingState(event.x(), event.y(), event.button())) {
            return true;
        }
        if (this.getBounds().contains(event.x(), event.y())) {
            if (this.searchField.mouseClicked(event, doubleClick)) {
                this.points.clear();
                return true;
            }
            if (this.selectAllButton.mouseClicked(event, doubleClick)) {
                return true;
            }
            if (this.selectNoneButton.mouseClicked(event, doubleClick)) {
                return true;
            }
            if (this.addButton.mouseClicked(event, doubleClick)) {
                return true;
            }
            if (this.removeButton.mouseClicked(event, doubleClick)) {
                return true;
            }
            if (event.button() == 0) {
                if (!event.hasShiftDown()) {
                    this.points.clear();
                }
                this.points.add(new PointPair(new Point(event.x(), event.y() + this.scrolling.scrollAmount()), null));
                return true;
            }
        }
        return this.backButton.mouseClicked(event, doubleClick);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        PointPair pair;
        if (event.button() == 0 && !this.points.isEmpty() && (pair = this.points.get(this.points.size() - 1)).secondPoint() == null) {
            this.points.set(this.points.size() - 1, new PointPair(pair.firstPoint(), new Point(event.x(), event.y() + this.scrolling.scrollAmount())));
            return true;
        }
        return super.mouseReleased(event);
    }

    public boolean charTyped(CharacterEvent event) {
        for (GuiEventListener guiEventListener : this.children()) {
            if (!guiEventListener.charTyped(event)) continue;
            return true;
        }
        return super.charTyped(event);
    }

    public boolean keyPressed(KeyEvent event) {
        for (GuiEventListener guiEventListener : this.children()) {
            if (!guiEventListener.keyPressed(event)) continue;
            return true;
        }
        if (event.isSelectAll()) {
            this.points.clear();
            this.points.add(new PointPair(new Point(-1073741823, -1073741823), new Point(0x3FFFFFFF, 0x3FFFFFFF)));
            return true;
        }
        if (event.isEscape() && this.shouldCloseOnEsc()) {
            this.backButton.onPress((InputWithModifiers)event);
            return true;
        }
        return false;
    }

    public void updateArea(@Nullable String searchTerm) {
        if (searchTerm != null) {
            this.updateSearch(searchTerm);
        } else if (this.entryStacks == null) {
            this.updateSearch("");
        } else {
            this.updateEntriesPosition();
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.getBounds().contains(mouseX, mouseY) && amountY != 0.0) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
            return true;
        }
        super.mouseScrolled(mouseX, mouseY, amountX, amountY);
        return true;
    }

    private class InnerStackEntry
    extends EntryWidget {
        private final int backupY;
        private boolean filtered;
        private boolean dirty;

        private InnerStackEntry(int x, int y, int entrySize) {
            super(new Point(x, y));
            this.filtered = false;
            this.dirty = true;
            this.backupY = y;
            this.getBounds().width = this.getBounds().height = entrySize;
            this.interactableFavorites(false);
            this.interactable(false);
            this.noHighlight();
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && CustomCollapsibleEntrySelectionScreen.this.getBounds().contains(mouseX, mouseY);
        }

        @Override
        protected void drawExtra(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (this.isSelected()) {
                boolean filtered = this.isFiltered();
                Rectangle bounds = this.getBounds();
                graphics.fillGradient(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), filtered ? 0x70FFFFFF : 0x55FFFFFF, filtered ? 0x70FFFFFF : 0x55FFFFFF);
            }
        }

        public boolean isSelected() {
            return CustomCollapsibleEntrySelectionScreen.this.getSelection().test(this.getBounds());
        }

        public boolean isFiltered() {
            if (this.dirty) {
                this.filtered = CustomCollapsibleEntrySelectionScreen.this.selectedStacks.contains(this.getCurrentEntry());
                this.dirty = false;
            }
            return this.filtered;
        }

        @Override
        protected void drawBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (this.isFiltered()) {
                Rectangle bounds = this.getBounds();
                graphics.fillGradient(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), -7913949, -7913949);
            }
        }

        @Override
        protected void queueTooltip(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (CustomCollapsibleEntrySelectionScreen.this.searchField.containsMouse(mouseX, mouseY)) {
                return;
            }
            Tooltip tooltip = this.getCurrentTooltip(TooltipContext.of(new Point(mouseX, mouseY), Item.TooltipContext.of((Level)this.minecraft.level)));
            if (tooltip != null) {
                CustomCollapsibleEntrySelectionScreen.this.tooltip = tooltip;
            }
        }
    }

    private record PointPair(Point firstPoint, @Nullable Point secondPoint) {
    }
}

