/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.error;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ErrorsScreen
extends Screen {
    private List<Object> components;
    private AbstractButton doneButton;
    private ErrorsEntryListWidget listWidget;
    private Screen parent;
    private boolean quitable;

    public ErrorsScreen(Component title, List<Object> components, Screen parent, boolean quitable) {
        super(title);
        this.components = components;
        this.parent = parent;
        this.quitable = quitable;
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.key() == 256) {
            Minecraft.getInstance().setScreen(this.parent);
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void init() {
        this.listWidget = new ErrorsEntryListWidget(this.minecraft, this.width, this.height, 32, this.height - 32);
        this.addWidget((GuiEventListener)this.listWidget);
        this.listWidget._clearItems();
        for (Object component : this.components) {
            if (component instanceof Component) {
                this.listWidget._addEntry(new ErrorsEntryListWidget.TextEntry((Component)component, this.listWidget.getItemWidth()));
                continue;
            }
            this.listWidget._addEntry((ErrorsEntryListWidget.Entry)((Object)((Function)component).apply(this.listWidget.getItemWidth())));
        }
        this.listWidget._addEntry(new ErrorsEntryListWidget.TextEntry((Component)Component.empty(), this.listWidget.getItemWidth()));
        if (this.quitable) {
            this.doneButton = new Button(this, this.width / 2 - 100, this.height - 26, 200, 20, (Component)Component.translatable((String)"gui.done"), button -> Minecraft.getInstance().setScreen(this.parent), Supplier::get){};
            this.addRenderableWidget((GuiEventListener)this.doneButton);
        } else {
            this.doneButton = new Button(this, this.width / 2 - 100, this.height - 26, 200, 20, (Component)Component.translatable((String)"menu.quit"), button -> this.exit(), Supplier::get){};
            this.addRenderableWidget((GuiEventListener)this.doneButton);
        }
    }

    private void exit() {
        boolean localServer = this.minecraft.isLocalServer();
        this.minecraft.level.disconnect(ClientLevel.DEFAULT_QUIT_MESSAGE);
        if (localServer) {
            this.minecraft.disconnectWithSavingScreen();
        } else {
            this.minecraft.disconnectWithProgressScreen();
        }
        System.exit(-1);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.listWidget.mouseScrolled(mouseX, mouseY, amountX, amountY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, amountX, amountY);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        graphics.drawCenteredString(this.font, this.getTitle(), this.width / 2, 16, 0xFFFFFF);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.renderBackground(graphics, mouseX, mouseY, delta);
        this.listWidget.render(graphics, mouseX, mouseY, delta);
    }
}

