/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.error;

import com.mojang.blaze3d.platform.NativeImage;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicSmoothScrollingEntryListWidget;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Vector3f;

@ApiStatus.Internal
public class ErrorsEntryListWidget
extends DynamicSmoothScrollingEntryListWidget<Entry> {
    private boolean inFocus;

    public ErrorsEntryListWidget(Minecraft client, int width, int height, int startY, int endY) {
        super(client, width, height, startY, endY, InternalTextures.LEGACY_DIRT);
    }

    public void _clearItems() {
        this.clearItems();
    }

    private Entry _getEntry(int index) {
        return (Entry)((Object)this.children().get(index));
    }

    public void _addEntry(Entry entry) {
        this.addItem(entry);
    }

    public int getItemWidth() {
        return this.width - 80;
    }

    protected int getScrollbarPosition() {
        return this.width - 40;
    }

    public static abstract class Entry
    extends DynamicEntryListWidget.Entry<Entry> {
        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }

        public void setFocused(boolean bl) {
        }

        public boolean isFocused() {
            return false;
        }
    }

    public static class LinkEntry
    extends Entry {
        private Component text;
        private List<FormattedCharSequence> textSplit;
        private String link;
        private boolean contains;

        public LinkEntry(Component text, String link, int width) {
            this.text = text;
            this.textSplit = Minecraft.getInstance().font.split((FormattedText)text, width - 6);
            this.link = link;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            boolean bl = this.contains = mouseX >= x && mouseX <= x + entryWidth && mouseY >= y && mouseY <= y + entryHeight;
            if (this.contains) {
                graphics.setTooltipForNextFrame(Minecraft.getInstance().font, (Component)Component.literal((String)"Click to open link."), mouseX, mouseY);
                int yy = y;
                for (FormattedCharSequence textSp : this.textSplit) {
                    FormattedCharSequence underlined = characterVisitor -> textSp.accept((charIndex, style, codePoint) -> characterVisitor.accept(charIndex, style.applyFormat(ChatFormatting.UNDERLINE), codePoint));
                    graphics.drawString(Minecraft.getInstance().font, underlined, x + 5, yy, -14695425);
                    yy += 12;
                }
            } else {
                int yy = y;
                for (FormattedCharSequence textSp : this.textSplit) {
                    graphics.drawString(Minecraft.getInstance().font, textSp, x + 5, yy, -14695425);
                    yy += 12;
                }
            }
        }

        public int getItemHeight() {
            return 12 * this.textSplit.size();
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
            if (this.contains && event.button() == 0) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                try {
                    Util.getPlatform().openUri(new URI(this.link));
                    return true;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }

    public static class ImageEntry
    extends Entry {
        private DynamicTexture texture;
        private ResourceLocation id;
        private int width;
        private int height;

        public ImageEntry(int width, DynamicTexture texture, ResourceLocation id) {
            this.id = id;
            this.texture = texture;
            this.width = (width - 6) / 2;
            NativeImage image = texture.getPixels();
            this.height = (int)((double)this.width * ((double)image.getHeight() / (double)image.getWidth()));
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            NativeImage image = this.texture.getPixels();
            this.width = (entryWidth - 6) / 2;
            this.height = (int)((double)this.width * ((double)image.getHeight() / (double)image.getWidth()));
            graphics.fill(x, y, x + this.width, y + this.height + 2, -1);
            graphics.innerBlit(RenderPipelines.GUI_TEXTURED, this.id, x + 1, x + this.width - 1, y + 1, y + this.height + 1, 0.0f, 0.0f, 1.0f, 0.0f, 1);
        }

        public int getItemHeight() {
            return this.height + 2;
        }
    }

    public static class HorizontalRuleEntry
    extends Entry {
        private int width;

        public HorizontalRuleEntry(int width) {
            this.width = width;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            if (this.width != entryWidth) {
                this.width = entryWidth;
            }
            graphics.fill(x + 2, y + 2, x + this.width - 6 - 2, y + 3, -8947849);
        }

        public int getItemHeight() {
            return 5;
        }
    }

    public static class TextEntry
    extends Entry {
        private Component text;
        private int width;
        private List<FormattedCharSequence> textSplit;
        private int savedX;
        private int savedY;

        public TextEntry(Component text, int width) {
            this.text = text;
            this.width = width - 6;
            this.textSplit = text.getString().trim().isEmpty() ? Collections.singletonList(text.getVisualOrderText()) : Minecraft.getInstance().font.split((FormattedText)text, this.width);
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            HoverEvent hoverEvent;
            if (this.width != entryWidth - 6) {
                this.width = entryWidth - 6;
                this.textSplit = this.text.getString().trim().isEmpty() ? Collections.singletonList(this.text.getVisualOrderText()) : Minecraft.getInstance().font.split((FormattedText)this.text, this.width);
            }
            this.savedX = x;
            this.savedY = y;
            int yy = y;
            for (FormattedCharSequence textSp : this.textSplit) {
                graphics.drawString(Minecraft.getInstance().font, textSp, x + 5, yy, -1);
                yy += 12;
            }
            Style style = this.getTextAt(mouseX, mouseY);
            Screen screen = Minecraft.getInstance().screen;
            if (style != null && screen != null && style.getHoverEvent() != null && (hoverEvent = style.getHoverEvent()) instanceof HoverEvent.ShowText) {
                Component component;
                HoverEvent.ShowText showText = (HoverEvent.ShowText)hoverEvent;
                try {
                    Component component2;
                    component = component2 = showText.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                graphics.setTooltipForNextFrame(Minecraft.getInstance().font, Minecraft.getInstance().font.split((FormattedText)component, Math.max(this.width / 2, 200)), x, y);
            }
        }

        public int getItemHeight() {
            return 12 * this.textSplit.size();
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
            Style style;
            if (event.button() == 0 && (style = this.getTextAt(event.x(), event.y())) != null && style.getClickEvent() != null) {
                Minecraft.getInstance().screen.handleComponentClicked(style);
                return true;
            }
            return super.mouseClicked(event, doubleClick);
        }

        @Nullable
        private Style getTextAt(double x, double y) {
            int lineCount = this.textSplit.size();
            if (lineCount > 0) {
                int line;
                int textX = Mth.floor((double)(x - (double)this.savedX));
                int textY = Mth.floor((double)(y - (double)this.savedY));
                if (textX >= 0 && textY >= 0 && textX <= this.width && textY < 12 * lineCount + lineCount && (line = textY / 12) < this.textSplit.size()) {
                    FormattedCharSequence orderedText = this.textSplit.get(line);
                    return Minecraft.getInstance().font.getSplitter().componentStyleAtWidth(orderedText, textX);
                }
            }
            return null;
        }
    }

    public static class ScaledEntry
    extends Entry
    implements ContainerEventHandler {
        public final Entry entry;
        public final float scale;
        public final Matrix3x2f transform;
        @Nullable
        private GuiEventListener focused;
        private boolean isDragging;

        public ScaledEntry(Entry entry, float scale) {
            this.entry = entry;
            this.scale = scale;
            this.transform = new Matrix3x2f().scale(scale, scale);
        }

        public Entry getEntry() {
            this.entry.setParent(this.getParent());
            return this.entry;
        }

        private Vector3f transformMouse(double mouseX, double mouseY) {
            Vector3f mouse = new Vector3f((float)mouseX, (float)mouseY, 1.0f);
            this.transform.transform(mouse);
            return mouse;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            Vector3f mouse = this.transformMouse(mouseX, mouseY);
            graphics.pose().pushMatrix();
            graphics.pose().mul((Matrix3x2fc)this.transform);
            Vector3f pos = new Vector3f((float)x, (float)y, 1.0f);
            pos.mul((Matrix3x2fc)new Matrix3x2f().scale(1.0f / this.scale, 1.0f / this.scale));
            this.getEntry().render(graphics, index, Math.round(pos.y()), Math.round(pos.x()), Math.round((float)entryWidth / this.scale), Math.round((float)entryHeight / this.scale), (int)mouse.x(), (int)mouse.y(), isSelected, delta);
            graphics.pose().popMatrix();
        }

        public int getItemHeight() {
            return this.getEntry().getItemHeight();
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return this.getEntry().narratables();
        }

        public List<? extends GuiEventListener> children() {
            return Collections.singletonList(this.getEntry());
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            Vector3f mouse = this.transformMouse(mouseX, mouseY);
            return super.isMouseOver((double)mouse.x(), (double)mouse.y());
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
            Vector3f mouse = this.transformMouse(event.x(), event.y());
            return super.mouseClicked(new MouseButtonEvent((double)mouse.x(), (double)mouse.y(), event.buttonInfo()), doubleClick);
        }

        public boolean mouseReleased(MouseButtonEvent event) {
            Vector3f mouse = this.transformMouse(event.x(), event.y());
            return super.mouseReleased(new MouseButtonEvent((double)mouse.x(), (double)mouse.y(), event.buttonInfo()));
        }

        public boolean mouseDragged(MouseButtonEvent event, double f, double g) {
            Vector3f mouse = this.transformMouse(event.x(), event.y());
            return super.mouseDragged(new MouseButtonEvent((double)mouse.x(), (double)mouse.y(), event.buttonInfo()), f, g);
        }

        public boolean mouseScrolled(double d, double e, double amountX, double amountY) {
            Vector3f mouse = this.transformMouse(d, e);
            return super.mouseScrolled((double)mouse.x(), (double)mouse.y(), amountX, amountY);
        }

        public final boolean isDragging() {
            return this.isDragging;
        }

        public final void setDragging(boolean dragging) {
            this.isDragging = dragging;
        }

        @Nullable
        public GuiEventListener getFocused() {
            return this.focused;
        }

        public void setFocused(@Nullable GuiEventListener focused) {
            this.focused = focused;
        }
    }

    public static class IndentedEntry
    extends Entry
    implements ContainerEventHandler {
        public final Entry entry;
        public final int indent;
        @Nullable
        private GuiEventListener focused;
        private boolean isDragging;

        public IndentedEntry(Entry entry, int indent) {
            this.entry = entry;
            this.indent = indent;
        }

        public Entry getEntry() {
            this.entry.setParent(this.getParent());
            return this.entry;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            this.getEntry().render(graphics, index, y, x + this.indent, entryWidth - this.indent, entryHeight, mouseX, mouseY, isSelected, delta);
        }

        public int getItemHeight() {
            return this.getEntry().getItemHeight();
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return this.getEntry().narratables();
        }

        public List<? extends GuiEventListener> children() {
            return Collections.singletonList(this.getEntry());
        }

        public final boolean isDragging() {
            return this.isDragging;
        }

        public final void setDragging(boolean dragging) {
            this.isDragging = dragging;
        }

        @Nullable
        public GuiEventListener getFocused() {
            return this.focused;
        }

        public void setFocused(@Nullable GuiEventListener focused) {
            this.focused = focused;
        }
    }

    public static class EmptyEntry
    extends Entry {
        public final int height;

        public EmptyEntry(int height) {
            this.height = height;
        }

        public void render(GuiGraphics graphics, int i, int i1, int i2, int i3, int i4, int i5, int i6, boolean b, float v) {
        }

        public int getItemHeight() {
            return this.height;
        }
    }
}

