/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.favorites;

import com.mojang.serialization.DataResult;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class DelegatingFavoriteEntryProviderImpl
extends FavoriteEntry {
    private final Supplier<DataResult<FavoriteEntry>> supplier;
    private final Supplier<CompoundTag> toJson;
    private FavoriteEntry value = null;

    public DelegatingFavoriteEntryProviderImpl(Supplier<DataResult<FavoriteEntry>> supplier, Supplier<CompoundTag> toJson) {
        this.supplier = supplier;
        this.toJson = toJson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FavoriteEntry getUnwrapped() {
        DelegatingFavoriteEntryProviderImpl delegatingFavoriteEntryProviderImpl = this;
        synchronized (delegatingFavoriteEntryProviderImpl) {
            if (this.value == null) {
                DataResult<FavoriteEntry> result = this.supplier.get();
                this.value = result.result().orElse(null);
            }
        }
        return Objects.requireNonNull(this.value).getUnwrapped();
    }

    @Override
    public UUID getUuid() {
        return this.getUnwrapped().getUuid();
    }

    @Override
    public boolean isInvalid() {
        try {
            return this.getUnwrapped().isInvalid();
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public Renderer getRenderer(boolean showcase) {
        return this.getUnwrapped().getRenderer(showcase);
    }

    @Override
    public boolean doAction(MouseButtonEvent event) {
        return this.getUnwrapped().doAction(event);
    }

    @Override
    public Optional<Supplier<Collection<FavoriteMenuEntry>>> getMenuEntries() {
        return this.getUnwrapped().getMenuEntries();
    }

    @Override
    public long hashIgnoreAmount() {
        return this.getUnwrapped().hashIgnoreAmount();
    }

    @Override
    public FavoriteEntry copy() {
        if (this.value != null && this.toJson != null) {
            return this.value.copy();
        }
        if (this.value != null) {
            return FavoriteEntry.delegateResult(() -> DataResult.success((Object)this.value.copy()), this.toJson);
        }
        return FavoriteEntry.delegateResult(this.supplier, this.toJson);
    }

    @Override
    public ResourceLocation getType() {
        return this.getUnwrapped().getType();
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        if (this.toJson == null) {
            return this.getUnwrapped().save(tag);
        }
        return tag.merge(this.toJson.get());
    }

    @Override
    public boolean isSame(FavoriteEntry other) {
        return this.getUnwrapped().isSame(other.getUnwrapped());
    }

    @Override
    @Nullable
    public DraggableComponent<?> asDraggableComponent(Slot slot) {
        return this.getUnwrapped().asDraggableComponent(slot);
    }
}

