/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.forge;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.PluginView;
import me.shedaniel.rei.api.common.plugins.REICommonPlugin;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import me.shedaniel.rei.forge.AnnotationUtils;
import me.shedaniel.rei.forge.REIPlugin;
import me.shedaniel.rei.forge.REIPluginClient;
import me.shedaniel.rei.forge.REIPluginCommon;
import me.shedaniel.rei.forge.REIPluginDedicatedServer;
import me.shedaniel.rei.forge.REIPluginLoader;
import me.shedaniel.rei.forge.REIPluginLoaderClient;
import me.shedaniel.rei.forge.REIPluginLoaderCommon;
import me.shedaniel.rei.forge.REIPluginLoaderDedicatedServer;
import me.shedaniel.rei.impl.init.PluginDetector;
import me.shedaniel.rei.plugin.client.forge.DefaultClientPluginImpl;
import me.shedaniel.rei.plugin.client.runtime.DefaultClientRuntimePlugin;
import me.shedaniel.rei.plugin.client.runtime.HideIngredientsFromTagsPlugin;
import me.shedaniel.rei.plugin.common.forge.DefaultPluginImpl;
import me.shedaniel.rei.plugin.common.runtime.DefaultRuntimePlugin;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;

public class PluginDetectorImpl
implements PluginDetector {
    private static final java.util.function.Supplier<List<Map.Entry<REIPluginProvider<me.shedaniel.rei.api.common.plugins.REIPlugin<?>>, List<String>>>> loaderProvided;
    private static final java.util.function.Supplier<List<Map.Entry<REIPluginProvider<me.shedaniel.rei.api.common.plugins.REIPlugin<?>>, List<String>>>> loaderProvidedCommon;
    private static final java.util.function.Supplier<List<Map.Entry<REIPluginProvider<me.shedaniel.rei.api.common.plugins.REIPlugin<?>>, List<String>>>> loaderProvidedDist;

    private static <P extends me.shedaniel.rei.api.common.plugins.REIPlugin<?>> REIPluginProvider<P> wrapPlugin(final List<String> modId, final REIPluginProvider<P> plugin) {
        return new REIPluginProvider<P>(){
            final String nameSuffix;
            {
                this.nameSuffix = " [" + String.join((CharSequence)", ", modId) + "]";
            }

            @Override
            public Collection<P> provide() {
                return plugin.provide();
            }

            @Override
            public Class<P> getPluginProviderClass() {
                return plugin.getPluginProviderClass();
            }

            @Override
            public String getPluginProviderName() {
                return plugin.getPluginProviderName() + this.nameSuffix;
            }
        };
    }

    @NotNull
    private static <T, P extends me.shedaniel.rei.api.common.plugins.REIPlugin<?>> List<Map.Entry<REIPluginProvider<P>, List<String>>> getPluginsLoader(Class<T> annotation) {
        ArrayList list = new ArrayList();
        AnnotationUtils.scanAnnotation(annotation, REIPluginProvider.class::isAssignableFrom, (modId, provider, clazz) -> {
            try {
                list.add(new AbstractMap.SimpleEntry<REIPluginProvider, List>((REIPluginProvider)provider.get(), (List)modId));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        });
        return list;
    }

    @Override
    public void detectCommonPlugins() {
        PluginView.getInstance().registerPlugin(PluginDetectorImpl.wrapPlugin(Collections.singletonList("roughlyenoughitems"), new DefaultPluginImpl()));
        PluginView.getInstance().registerPlugin(PluginDetectorImpl.wrapPlugin(Collections.singletonList("roughlyenoughitems"), new DefaultRuntimePlugin()));
        AnnotationUtils.scanAnnotation(REIPlugin.class, REICommonPlugin.class::isAssignableFrom, (modId, plugin, clazz) -> PluginView.getInstance().registerPlugin(PluginDetectorImpl.wrapPlugin(modId, (REIPluginProvider)plugin.get())));
        AnnotationUtils.scanAnnotation(REIPluginCommon.class, REICommonPlugin.class::isAssignableFrom, (modId, plugin, clazz) -> PluginView.getInstance().registerPlugin(PluginDetectorImpl.wrapPlugin(modId, (REIPluginProvider)plugin.get())));
        if (FMLEnvironment.getDist() == Dist.CLIENT) {
            AnnotationUtils.scanAnnotation(REIPluginClient.class, REICommonPlugin.class::isAssignableFrom, (modId, plugin, clazz) -> PluginView.getInstance().registerPlugin(PluginDetectorImpl.wrapPlugin(modId, (REIPluginProvider)plugin.get())));
        } else if (FMLEnvironment.getDist() == Dist.DEDICATED_SERVER) {
            AnnotationUtils.scanAnnotation(REIPluginDedicatedServer.class, REICommonPlugin.class::isAssignableFrom, (modId, plugin, clazz) -> PluginView.getInstance().registerPlugin(PluginDetectorImpl.wrapPlugin(modId, (REIPluginProvider)plugin.get())));
        }
        for (Map.Entry<REIPluginProvider<me.shedaniel.rei.api.common.plugins.REIPlugin<?>>, List<String>> entry : loaderProvided.get()) {
            PluginView.getInstance().registerPlugin(PluginDetectorImpl.wrapPlugin(entry.getValue(), PluginDetectorImpl.wrapAndFilter(entry.getKey(), REICommonPlugin.class)));
        }
        for (Map.Entry<REIPluginProvider<me.shedaniel.rei.api.common.plugins.REIPlugin<?>>, List<String>> entry : loaderProvidedCommon.get()) {
            PluginView.getInstance().registerPlugin(PluginDetectorImpl.wrapPlugin(entry.getValue(), PluginDetectorImpl.wrapAndFilter(entry.getKey(), REICommonPlugin.class)));
        }
        for (Map.Entry<REIPluginProvider<me.shedaniel.rei.api.common.plugins.REIPlugin<?>>, List<String>> entry : loaderProvidedDist.get()) {
            PluginView.getInstance().registerPlugin(PluginDetectorImpl.wrapPlugin(entry.getValue(), PluginDetectorImpl.wrapAndFilter(entry.getKey(), REICommonPlugin.class)));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public java.util.function.Supplier<Runnable> detectClientPlugins() {
        return () -> () -> {
            PluginView.getClientInstance().registerPlugin(PluginDetectorImpl.wrapPlugin(Collections.singletonList("roughlyenoughitems"), new DefaultClientPluginImpl()));
            PluginView.getClientInstance().registerPlugin(PluginDetectorImpl.wrapPlugin(Collections.singletonList("roughlyenoughitems"), new DefaultClientRuntimePlugin()));
            PluginView.getClientInstance().registerPlugin(PluginDetectorImpl.wrapPlugin(Collections.singletonList("roughlyenoughitems"), new HideIngredientsFromTagsPlugin()));
            AnnotationUtils.scanAnnotation(REIPlugin.class, REIClientPlugin.class::isAssignableFrom, (modId, plugin, clazz) -> ((PluginView)((Object)PluginManager.getClientInstance())).registerPlugin(PluginDetectorImpl.wrapPlugin(modId, (REIPluginProvider)plugin.get())));
            AnnotationUtils.scanAnnotation(REIPluginCommon.class, REIClientPlugin.class::isAssignableFrom, (modId, plugin, clazz) -> ((PluginView)((Object)PluginManager.getClientInstance())).registerPlugin(PluginDetectorImpl.wrapPlugin(modId, (REIPluginProvider)plugin.get())));
            AnnotationUtils.scanAnnotation(REIPluginClient.class, REIClientPlugin.class::isAssignableFrom, (modId, plugin, clazz) -> ((PluginView)((Object)PluginManager.getClientInstance())).registerPlugin(PluginDetectorImpl.wrapPlugin(modId, (REIPluginProvider)plugin.get())));
            for (Map.Entry<REIPluginProvider<me.shedaniel.rei.api.common.plugins.REIPlugin<?>>, List<String>> entry : loaderProvided.get()) {
                ((PluginView)((Object)PluginManager.getClientInstance())).registerPlugin(PluginDetectorImpl.wrapPlugin(entry.getValue(), PluginDetectorImpl.wrapAndFilter(entry.getKey(), REIClientPlugin.class)));
            }
            for (Map.Entry<REIPluginProvider<me.shedaniel.rei.api.common.plugins.REIPlugin<?>>, List<String>> entry : loaderProvidedCommon.get()) {
                ((PluginView)((Object)PluginManager.getClientInstance())).registerPlugin(PluginDetectorImpl.wrapPlugin(entry.getValue(), PluginDetectorImpl.wrapAndFilter(entry.getKey(), REIClientPlugin.class)));
            }
            for (Map.Entry<REIPluginProvider<me.shedaniel.rei.api.common.plugins.REIPlugin<?>>, List<String>> entry : loaderProvidedDist.get()) {
                ((PluginView)((Object)PluginManager.getClientInstance())).registerPlugin(PluginDetectorImpl.wrapPlugin(entry.getValue(), PluginDetectorImpl.wrapAndFilter(entry.getKey(), REIClientPlugin.class)));
            }
        };
    }

    private static <P extends me.shedaniel.rei.api.common.plugins.REIPlugin<P>> REIPluginProvider<P> wrapAndFilter(final REIPluginProvider<?> provider, final Class<P> clazz) {
        return new REIPluginProvider<P>(){

            @Override
            public Collection<P> provide() {
                return new AbstractCollection<P>(){

                    @Override
                    public Iterator<P> iterator() {
                        return Iterables.filter(provider.provide(), (Class)clazz).iterator();
                    }

                    @Override
                    public int size() {
                        return Iterators.size(this.iterator());
                    }
                };
            }

            @Override
            public Class<P> getPluginProviderClass() {
                return clazz;
            }

            @Override
            public String getPluginProviderName() {
                return provider.getPluginProviderName();
            }
        };
    }

    static {
        Supplier dist;
        loaderProvided = Suppliers.memoize(() -> PluginDetectorImpl.getPluginsLoader(REIPluginLoader.class));
        loaderProvidedCommon = Suppliers.memoize(() -> PluginDetectorImpl.getPluginsLoader(REIPluginLoaderCommon.class));
        if (FMLEnvironment.getDist() == Dist.CLIENT) {
            dist = Suppliers.memoize(() -> PluginDetectorImpl.getPluginsLoader(REIPluginLoaderClient.class));
        } else if (FMLEnvironment.getDist() == Dist.DEDICATED_SERVER) {
            dist = Suppliers.memoize(() -> PluginDetectorImpl.getPluginsLoader(REIPluginLoaderDedicatedServer.class));
        } else {
            throw new IllegalStateException("Unknown environment: " + String.valueOf(FMLEnvironment.getDist()));
        }
        loaderProvidedDist = dist;
    }
}

