/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.favorites;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.CompoundFavoriteRenderer;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class WeatherFavoriteEntry
extends FavoriteEntry {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"weather");
    public static final String TRANSLATION_KEY = "favorite.section.weather";
    private static final ResourceLocation CHEST_GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"textures/gui/recipecontainer.png");
    public static final String KEY = "weather";
    @Nullable
    private final Weather weather;

    public WeatherFavoriteEntry(@Nullable Weather weather) {
        this.weather = weather;
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    @Override
    public Renderer getRenderer(boolean showcase) {
        if (this.weather == null) {
            List renderers = IntStream.range(0, 3).mapToObj(WeatherFavoriteEntry::getRenderer).collect(Collectors.toList());
            return new CompoundFavoriteRenderer(this, showcase, renderers, () -> WeatherFavoriteEntry.getCurrentWeather().getId()){

                @Override
                @Nullable
                public Tooltip getTooltip(TooltipContext context) {
                    return Tooltip.create(context.getPoint(), new Component[]{Component.translatable((String)"text.rei.weather_button.tooltip.dropdown")});
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || this.getClass() != o.getClass()) {
                        return false;
                    }
                    return this.hashCode() == o.hashCode();
                }

                public int hashCode() {
                    return Objects.hash(this.getClass(), this.showcase);
                }
            };
        }
        return WeatherFavoriteEntry.getRenderer(this.weather.getId());
    }

    private static Weather getCurrentWeather() {
        ClientLevel world = Minecraft.getInstance().level;
        if (world.isThundering()) {
            return Weather.THUNDER;
        }
        if (world.getLevelData().isRaining()) {
            return Weather.RAIN;
        }
        return Weather.CLEAR;
    }

    private static Renderer getRenderer(int id) {
        final Weather weather = Weather.byId(id);
        return new Renderer(){

            @Override
            public void render(GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                int color;
                int n = color = bounds.contains(mouseX, mouseY) ? -1118482 : -5592406;
                if (bounds.width > 4 && bounds.height > 4) {
                    graphics.pose().pushMatrix();
                    graphics.pose().translate((float)bounds.getCenterX(), (float)bounds.getCenterY());
                    graphics.pose().scale((float)bounds.getWidth() / 18.0f, (float)bounds.getHeight() / 18.0f);
                    this.renderWeatherIcon(graphics, weather, 0, 0, color);
                    graphics.pose().popMatrix();
                }
            }

            private void renderWeatherIcon(GuiGraphics graphics, Weather type, int centerX, int centerY, int color) {
                graphics.blit(RenderPipelines.GUI_TEXTURED, CHEST_GUI_TEXTURE, centerX - 7, centerY - 7, (float)(type.getId() * 14), 14.0f, 14, 14, 256, 256);
            }

            @Override
            @Nullable
            public Tooltip getTooltip(TooltipContext context) {
                return Tooltip.create(context.getPoint(), new Component[]{Component.translatable((String)"text.rei.weather_button.tooltip.entry", (Object[])new Object[]{Component.translatable((String)weather.getTranslateKey())})});
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                return this.hashCode() == o.hashCode();
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.getClass(), false, weather});
            }
        };
    }

    @Override
    public boolean doAction(MouseButtonEvent event) {
        if (event.button() == 0) {
            if (this.weather != null) {
                Minecraft.getInstance().player.connection.sendCommand(StringUtils.removeStart((String)ConfigObject.getInstance().getWeatherCommand().replaceAll("\\{weather}", this.weather.name().toLowerCase(Locale.ROOT)), (String)"/"));
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
            return true;
        }
        return false;
    }

    @Override
    public Optional<Supplier<Collection<FavoriteMenuEntry>>> getMenuEntries() {
        if (this.weather == null) {
            return Optional.of(this::_getMenuEntries);
        }
        return Optional.empty();
    }

    private Collection<FavoriteMenuEntry> _getMenuEntries() {
        return CollectionUtils.map(Weather.values(), WeatherMenuEntry::new);
    }

    @Override
    public long hashIgnoreAmount() {
        return this.weather == null ? 31290831290L : (long)this.weather.ordinal();
    }

    @Override
    public FavoriteEntry copy() {
        return this;
    }

    @Override
    public ResourceLocation getType() {
        return ID;
    }

    @Override
    public boolean isSame(FavoriteEntry other) {
        if (!(other instanceof WeatherFavoriteEntry)) {
            return false;
        }
        WeatherFavoriteEntry that = (WeatherFavoriteEntry)other;
        return Objects.equals((Object)this.weather, (Object)that.weather);
    }

    @ApiStatus.Internal
    public static enum Weather {
        CLEAR(0, "text.rei.weather.clear"),
        RAIN(1, "text.rei.weather.rain"),
        THUNDER(2, "text.rei.weather.thunder");

        private final int id;
        private final String translateKey;

        private Weather(int id, String translateKey) {
            this.id = id;
            this.translateKey = translateKey;
        }

        public static Weather byId(int id) {
            return Weather.byId(id, CLEAR);
        }

        public static Weather byId(int id, Weather defaultWeather) {
            for (Weather weather : Weather.values()) {
                if (weather.id != id) continue;
                return weather;
            }
            return defaultWeather;
        }

        public int getId() {
            return this.id;
        }

        public String getTranslateKey() {
            return this.translateKey;
        }
    }

    public static class WeatherMenuEntry
    extends FavoriteMenuEntry {
        public final String text;
        public final Weather weather;
        private int x;
        private int y;
        private int width;
        private boolean selected;
        private boolean containsMouse;
        private boolean rendering;
        private int textWidth = -69;

        public WeatherMenuEntry(Weather weather) {
            this.text = I18n.get((String)weather.getTranslateKey(), (Object[])new Object[0]);
            this.weather = weather;
        }

        private int getTextWidth() {
            if (this.textWidth == -69) {
                this.textWidth = Math.max(0, this.font.width(this.text));
            }
            return this.textWidth;
        }

        @Override
        public int getEntryWidth() {
            return this.getTextWidth() + 4;
        }

        @Override
        public int getEntryHeight() {
            return 12;
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        @Override
        public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
            this.x = xPos;
            this.y = yPos;
            this.selected = selected;
            this.containsMouse = containsMouse;
            this.rendering = rendering;
            this.width = width;
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (this.selected) {
                graphics.fill(this.x, this.y, this.x + this.width, this.y + 12, -12237499);
            }
            if (this.selected && this.containsMouse) {
                REIRuntime.getInstance().queueTooltip(Tooltip.create(new Component[]{Component.translatable((String)"text.rei.weather_button.tooltip.entry", (Object[])new Object[]{this.text})}));
            }
            graphics.drawString(this.font, this.text, this.x + 2, this.y + 2, this.selected ? 0xFFFFFF : 0x888888, false);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
            Minecraft.getInstance().player.connection.sendCommand(StringUtils.removeStart((String)ConfigObject.getInstance().getWeatherCommand().replaceAll("\\{weather}", this.weather.name().toLowerCase(Locale.ROOT)), (String)"/"));
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            this.closeMenu();
            return true;
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return this.rendering && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 12);
        }
    }

    public static enum Type implements FavoriteEntryType<WeatherFavoriteEntry>
    {
        INSTANCE;


        @Override
        public DataResult<WeatherFavoriteEntry> read(CompoundTag object) {
            String stringValue = object.getStringOr(WeatherFavoriteEntry.KEY, "NOT_SET");
            Weather weather = stringValue.equals("NOT_SET") ? null : Weather.valueOf(stringValue);
            return DataResult.success((Object)new WeatherFavoriteEntry(weather), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public DataResult<WeatherFavoriteEntry> fromArgs(Object ... args) {
            if (args.length == 0) {
                return DataResult.error(() -> "Cannot create WeatherFavoriteEntry from empty args!");
            }
            Object object = args[0];
            if (!(object instanceof Weather)) {
                return DataResult.error(() -> "Creation of WeatherFavoriteEntry from args expected Weather as the first argument!");
            }
            Weather weather = (Weather)((Object)object);
            return DataResult.success((Object)new WeatherFavoriteEntry(weather), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public CompoundTag save(WeatherFavoriteEntry entry, CompoundTag tag) {
            tag.putString(WeatherFavoriteEntry.KEY, entry.weather == null ? "NOT_SET" : entry.weather.name());
            return tag;
        }
    }
}

