/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.displays;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.client.displays.ClientsidedRecipeBookDisplay;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.cooking.CookingDisplay;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.display.FurnaceRecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;

public abstract class ClientsidedCookingDisplay
extends BasicDisplay
implements CookingDisplay,
ClientsidedRecipeBookDisplay {
    private final Optional<RecipeDisplayId> id;

    public ClientsidedCookingDisplay(FurnaceRecipeDisplay recipe, Optional<RecipeDisplayId> id) {
        this(List.of(EntryIngredients.ofSlotDisplay(recipe.ingredient())), List.of(EntryIngredients.ofSlotDisplay(recipe.result())), id);
    }

    public ClientsidedCookingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<RecipeDisplayId> id) {
        super(inputs, outputs, Optional.empty());
        this.id = id;
    }

    @Override
    public OptionalDouble xp() {
        return OptionalDouble.empty();
    }

    @Override
    public OptionalDouble cookTime() {
        return OptionalDouble.empty();
    }

    @Override
    public Optional<RecipeDisplayId> recipeDisplayId() {
        return this.id;
    }

    protected static <D extends ClientsidedCookingDisplay> DisplaySerializer<D> serializer(Constructor<D> constructor) {
        return DisplaySerializer.of(RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(BasicDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(BasicDisplay::getOutputEntries), (App)Codec.INT.xmap(RecipeDisplayId::new, RecipeDisplayId::index).optionalFieldOf("id").forGetter(ClientsidedCookingDisplay::recipeDisplayId)).apply((Applicative)instance, constructor::create)), StreamCodec.composite((StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getInputEntries, (StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getOutputEntries, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT.map(RecipeDisplayId::new, RecipeDisplayId::index)), ClientsidedCookingDisplay::recipeDisplayId, constructor::create), false);
    }

    protected static interface Constructor<T extends ClientsidedCookingDisplay> {
        public T create(List<EntryIngredient> var1, List<EntryIngredient> var2, Optional<RecipeDisplayId> var3);
    }

    public static class Smoking
    extends ClientsidedCookingDisplay {
        public static DisplaySerializer<Blasting> SERIALIZER = Smoking.serializer(Blasting::new);

        public Smoking(FurnaceRecipeDisplay recipe, Optional<RecipeDisplayId> id) {
            super(recipe, id);
        }

        public Smoking(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<RecipeDisplayId> location) {
            super(inputs, outputs, location);
        }

        @Override
        public CategoryIdentifier<?> getCategoryIdentifier() {
            return BuiltinPlugin.SMOKING;
        }

        @Override
        public DisplaySerializer<? extends Display> getSerializer() {
            return SERIALIZER;
        }
    }

    public static class Blasting
    extends ClientsidedCookingDisplay {
        public static DisplaySerializer<Blasting> SERIALIZER = Blasting.serializer(Blasting::new);

        public Blasting(FurnaceRecipeDisplay recipe, Optional<RecipeDisplayId> id) {
            super(recipe, id);
        }

        public Blasting(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<RecipeDisplayId> location) {
            super(inputs, outputs, location);
        }

        @Override
        public CategoryIdentifier<?> getCategoryIdentifier() {
            return BuiltinPlugin.BLASTING;
        }

        @Override
        public DisplaySerializer<? extends Display> getSerializer() {
            return SERIALIZER;
        }
    }

    public static class Smelting
    extends ClientsidedCookingDisplay {
        public static DisplaySerializer<Smelting> SERIALIZER = Smelting.serializer(Smelting::new);

        public Smelting(FurnaceRecipeDisplay recipe, Optional<RecipeDisplayId> id) {
            super(recipe, id);
        }

        public Smelting(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<RecipeDisplayId> location) {
            super(inputs, outputs, location);
        }

        @Override
        public CategoryIdentifier<?> getCategoryIdentifier() {
            return BuiltinPlugin.SMELTING;
        }

        @Override
        public DisplaySerializer<? extends Display> getSerializer() {
            return SERIALIZER;
        }
    }
}

