/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.cooking;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.SimpleDisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.plugin.common.displays.cooking.CookingDisplay;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultCookingCategory
implements DisplayCategory<CookingDisplay> {
    private CategoryIdentifier<? extends CookingDisplay> identifier;
    private EntryStack<?> logo;
    private String categoryName;
    private double defaultCookingTime;

    public DefaultCookingCategory(CategoryIdentifier<? extends CookingDisplay> identifier, EntryStack<?> logo, String categoryName, double defaultCookingTime) {
        this.identifier = identifier;
        this.logo = logo;
        this.categoryName = categoryName;
        this.defaultCookingTime = defaultCookingTime;
    }

    @Override
    public List<Widget> setupDisplay(CookingDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.y + 10);
        DecimalFormat df = new DecimalFormat("###.##");
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase(bounds));
        widgets.add(Widgets.createResultSlotBackground(new Point(startPoint.x + 61, startPoint.y + 9)));
        widgets.add(Widgets.createBurningFire(new Point(startPoint.x + 1, startPoint.y + 20)).animationDurationMS(10000.0));
        if (display.cookTime().isPresent() && display.xp().isPresent()) {
            widgets.add(Widgets.createLabel(new Point(bounds.x + bounds.width - 5, bounds.y + 5), (Component)Component.translatable((String)"category.rei.cooking.time&xp", (Object[])new Object[]{df.format(display.xp().getAsDouble()), df.format(display.cookTime().getAsDouble() / 20.0)})).noShadow().rightAligned().color(-12566464, -4473925));
        }
        widgets.add(Widgets.createArrow(new Point(startPoint.x + 24, startPoint.y + 8)).animationDurationTicks(display.cookTime().orElse(this.defaultCookingTime)));
        widgets.add(Widgets.createSlot(new Point(startPoint.x + 61, startPoint.y + 9)).entries(display.getOutputEntries().get(0)).disableBackground().markOutput());
        widgets.add(Widgets.createSlot(new Point(startPoint.x + 1, startPoint.y + 1)).entries(display.getInputEntries().get(0)).markInput());
        return widgets;
    }

    @Override
    public DisplayRenderer getDisplayRenderer(CookingDisplay display) {
        return SimpleDisplayRenderer.from(Collections.singletonList(display.getInputEntries().get(0)), display.getOutputEntries());
    }

    @Override
    public int getDisplayHeight() {
        return 49;
    }

    @Override
    public CategoryIdentifier<? extends CookingDisplay> getCategoryIdentifier() {
        return this.identifier;
    }

    @Override
    public Renderer getIcon() {
        return this.logo;
    }

    @Override
    public Component getTitle() {
        return Component.translatable((String)this.categoryName);
    }
}

