/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.anvil;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.anvil.DefaultAnvilDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class DefaultAnvilCategory
implements DisplayCategory<DefaultAnvilDisplay> {
    @Override
    public CategoryIdentifier<? extends DefaultAnvilDisplay> getCategoryIdentifier() {
        return BuiltinPlugin.ANVIL;
    }

    @Override
    public Component getTitle() {
        return Component.translatable((String)"block.minecraft.anvil");
    }

    @Override
    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)Blocks.ANVIL);
    }

    @Override
    public List<Widget> setupDisplay(DefaultAnvilDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 31, bounds.getCenterY() - (display.getCost().isPresent() ? 20 : 13));
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase(bounds));
        widgets.add(Widgets.createArrow(new Point(startPoint.x + 27, startPoint.y + 4)));
        widgets.add(Widgets.createResultSlotBackground(new Point(startPoint.x + 61, startPoint.y + 5)));
        widgets.add(Widgets.createSlot(new Point(startPoint.x + 4 - 22, startPoint.y + 5)).entries(display.getInputEntries().get(0)).markInput());
        widgets.add(Widgets.createSlot(new Point(startPoint.x + 4, startPoint.y + 5)).entries(display.getInputEntries().get(1)).markInput());
        widgets.add(Widgets.createSlot(new Point(startPoint.x + 61, startPoint.y + 5)).entries(display.getOutputEntries().get(0)).disableBackground().markOutput());
        if (display.getCost().isPresent()) {
            widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
                Font font = Minecraft.getInstance().font;
                MutableComponent component = Component.translatable((String)"container.repair.cost", (Object[])new Object[]{display.getCost().getAsInt()});
                int x = startPoint.x + 102 - font.width((FormattedText)component) - 2;
                graphics.fill(x - 2, startPoint.y + 28, startPoint.x + 102, startPoint.y + 28 + 12, 0x4F000000);
                graphics.drawString(font, (Component)component, x, startPoint.y + 28 + 2, -8323296);
            }));
        }
        return widgets;
    }

    @Override
    public int getDisplayHeight() {
        return 48;
    }
}

