/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.type.types;

import com.mojang.serialization.Codec;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class BuiltinEntryDefinition<T>
implements EntryDefinition<T>,
EntrySerializer<T> {
    private final Class<T> clazz;
    private final EntryType<T> type;
    private final boolean empty;
    private final Supplier<T> defaultValue;
    @OnlyIn(value=Dist.CLIENT)
    private EntryRenderer<T> renderer;

    protected BuiltinEntryDefinition(Class<T> clazz, EntryType<T> type, boolean empty, Supplier<T> defaultValue, Supplier<Supplier<EntryRenderer<T>>> renderer) {
        this.clazz = clazz;
        this.type = type;
        this.empty = empty;
        this.defaultValue = defaultValue;
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> this.lambda$new$0((Supplier)renderer));
    }

    @Override
    public Class<T> getValueType() {
        return this.clazz;
    }

    @Override
    public EntryType<T> getType() {
        return this.type;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public EntryRenderer<T> getRenderer() {
        return this.renderer;
    }

    @Override
    @Nullable
    public ResourceLocation getIdentifier(EntryStack<T> entry, T value) {
        return null;
    }

    @Override
    public boolean isEmpty(EntryStack<T> entry, T value) {
        return this.empty;
    }

    @Override
    public T copy(EntryStack<T> entry, T value) {
        return value;
    }

    @Override
    public T normalize(EntryStack<T> entry, T value) {
        return value;
    }

    @Override
    public T wildcard(EntryStack<T> entry, T value) {
        return value;
    }

    @Override
    public long hash(EntryStack<T> entry, T value, ComparisonContext context) {
        return this.empty ? 0L : (long)Objects.hash(value.getClass().getName(), value);
    }

    @Override
    public boolean equals(T o1, T o2, ComparisonContext context) {
        return this.empty || Objects.equals(o1, o2);
    }

    @Override
    @Nullable
    public EntrySerializer<T> getSerializer() {
        return this.empty ? this : null;
    }

    @Override
    public Component asFormattedText(EntryStack<T> entry, T value) {
        return Component.empty();
    }

    @Override
    public Stream<? extends TagKey<?>> getTagsFor(EntryStack<T> entry, T value) {
        return Stream.empty();
    }

    @Override
    public Codec<T> codec() {
        return Codec.unit(this.defaultValue.get());
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return StreamCodec.unit(this.defaultValue.get());
    }

    private /* synthetic */ void lambda$new$0(Supplier renderer) {
        this.renderer = (EntryRenderer)((Supplier)renderer.get()).get();
    }
}

