/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.display;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.plugins.REICommonPlugin;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class DisplaySerializerRegistryImpl
implements DisplaySerializerRegistry {
    private final BiMap<ResourceLocation, DisplaySerializer<?>> serializers = HashBiMap.create();

    @Override
    public ReloadStage getStage() {
        return ReloadStage.START;
    }

    @Override
    public void startReload() {
        this.serializers.clear();
    }

    @Override
    public <D extends Display> void register(ResourceLocation id, DisplaySerializer<D> serializer) {
        InternalLogger.getInstance().debug("Added display serializer [%s] %s", id, serializer);
        this.serializers.put((Object)id, serializer);
    }

    @Override
    @Nullable
    public DisplaySerializer<?> get(ResourceLocation id) {
        return (DisplaySerializer)this.serializers.get((Object)id);
    }

    @Override
    @Nullable
    public ResourceLocation getId(DisplaySerializer<?> serializer) {
        return (ResourceLocation)this.serializers.inverse().get(serializer);
    }

    @Override
    public boolean isRegistered(DisplaySerializer<?> serializer) {
        return this.serializers.containsValue(serializer);
    }

    @Override
    public Codec<Display> codec() {
        return this.serializerCodec().dispatch(Display::getSerializer, DisplaySerializer::codec);
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, Display> streamCodec() {
        return this.serializerStreamCodec().cast().dispatch(Display::getSerializer, DisplaySerializer::streamCodec);
    }

    @Override
    public void acceptPlugin(REICommonPlugin plugin) {
        plugin.registerDisplaySerializer(this);
    }

    private Codec<DisplaySerializer<?>> serializerCodec() {
        return ResourceLocation.CODEC.flatXmap(id -> Optional.ofNullable(this.get((ResourceLocation)id)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown display serializer id: " + String.valueOf(id))), serializer -> {
            if (this.isRegistered((DisplaySerializer<?>)serializer)) {
                return DataResult.success((Object)this.getId((DisplaySerializer<?>)serializer));
            }
            return DataResult.error(() -> "Unregistered display serializer: " + String.valueOf(serializer));
        });
    }

    private StreamCodec<ByteBuf, DisplaySerializer<?>> serializerStreamCodec() {
        return new StreamCodec<ByteBuf, DisplaySerializer<?>>(){

            public DisplaySerializer<?> decode(ByteBuf object) {
                ResourceLocation id = new FriendlyByteBuf(object).readResourceLocation();
                DisplaySerializer<?> serializer = DisplaySerializerRegistryImpl.this.get(id);
                if (serializer == null) {
                    throw new NullPointerException("Unknown display serializer id: " + String.valueOf(id));
                }
                return serializer;
            }

            public void encode(ByteBuf buf, DisplaySerializer<?> serializer) {
                if (!DisplaySerializerRegistryImpl.this.isRegistered(serializer)) {
                    throw new IllegalArgumentException("Unregistered display serializer: " + String.valueOf(serializer));
                }
                new FriendlyByteBuf(buf).writeResourceLocation(DisplaySerializerRegistryImpl.this.getId(serializer));
            }
        };
    }
}

