/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument.type;

import java.util.ConcurrentModificationException;
import java.util.Locale;
import java.util.StringJoiner;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public final class TooltipArgumentType
extends ArgumentType<Unit, String> {
    private static final TooltipContext CONTEXT = TooltipContext.of(new Point(), Item.TooltipContext.EMPTY, (TooltipFlag)TooltipFlag.Default.NORMAL, true);
    public static String INVALID = "INVALID_PIECE_OF_TOOLTIP_I_DONT_THINK_PEOPLE_WILL_EXACTLY_HAVE_THIS_REI_REI_REI";
    private static final Style STYLE = Style.EMPTY.withColor(TextColor.fromRgb((int)16769197));

    @Override
    public String getName() {
        return "tooltip";
    }

    @Override
    @Nullable
    public String getPrefix() {
        return "#";
    }

    @Override
    public Style getHighlightedStyle() {
        return STYLE;
    }

    @Override
    public SearchMode getSearchMode() {
        return ConfigObject.getInstance().getTooltipSearchMode();
    }

    @Override
    public String cacheData(EntryStack<?> stack) {
        String tooltip = TooltipArgumentType.tryGetEntryStackTooltip(stack, 0);
        if (tooltip == null) {
            return INVALID;
        }
        return tooltip.toLowerCase(Locale.ROOT);
    }

    @Override
    public void matches(String tooltip, EntryStack<?> stack, Unit filterData, ArgumentType.ResultSink sink) {
        if (tooltip == INVALID) {
            return;
        }
        sink.testString(tooltip);
    }

    @Nullable
    public static String tryGetEntryStackTooltip(EntryStack<?> stack, int attempt) {
        try {
            Tooltip tooltip = stack.getTooltip(CONTEXT, false);
            if (tooltip != null) {
                StringJoiner joiner = new StringJoiner("\n");
                for (Tooltip.Entry entry : tooltip.entries()) {
                    if (!entry.isText()) continue;
                    joiner.add(entry.getAsText().getString());
                }
                return joiner.toString();
            }
            return "";
        }
        catch (Throwable throwable) {
            Throwable temp = throwable;
            while (temp != null) {
                if (!((temp = temp.getCause()) instanceof ConcurrentModificationException)) continue;
                if (attempt < 10) {
                    return TooltipArgumentType.tryGetEntryStackTooltip(stack, attempt + 1);
                }
                return null;
            }
            throw throwable;
        }
    }

    @Override
    public Unit prepareSearchFilter(String searchText) {
        return Unit.INSTANCE;
    }
}

