/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.impl.client.gui.widget.AutoCraftingEvaluator;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.joml.Matrix3x2f;

public class DisplayTooltipComponent
implements TooltipComponent,
ClientTooltipComponent {
    private final List<Widget> widgets;
    private final Widget widget;
    private final DisplaySpec display;
    private final Rectangle bounds;
    private final Supplier<AutoCraftingEvaluator.AutoCraftingResult> autoCraftingResult = Suppliers.memoizeWithExpiration(this::evaluateAutoCrafting, (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);

    public DisplayTooltipComponent(DisplaySpec display) {
        Display internalDisplay = display.provideInternalDisplay();
        CategoryRegistry.CategoryConfiguration<?> configuration = CategoryRegistry.getInstance().get(internalDisplay.getCategoryIdentifier());
        DisplayCategory<?> category = configuration.getCategory();
        this.bounds = new Rectangle(0, 0, category.getDisplayWidth(internalDisplay), category.getDisplayHeight());
        List<Widget> widgets = configuration.getView(internalDisplay).setupDisplay(internalDisplay, this.bounds);
        this.display = display;
        this.widgets = widgets;
        this.widget = Widgets.concat(widgets);
    }

    public DisplayTooltipComponent(DisplaySpec display, List<Widget> widgets, Rectangle bounds) {
        this.widgets = widgets;
        this.widget = Widgets.concat(widgets);
        this.display = display;
        this.bounds = bounds;
    }

    private AutoCraftingEvaluator.AutoCraftingResult evaluateAutoCrafting() {
        if (this.display == null) {
            return new AutoCraftingEvaluator.AutoCraftingResult();
        }
        return AutoCraftingEvaluator.evaluateAutoCrafting(false, false, this.display.provideInternalDisplay(), this.display::provideInternalDisplayIds);
    }

    public int getHeight(Font font) {
        return this.bounds.height + 4;
    }

    public int getWidth(Font font) {
        return this.bounds.width + 4;
    }

    public void renderImage(Font font, int x, int y, int width, int height, GuiGraphics graphics) {
        graphics.pose().pushMatrix();
        graphics.pose().translate((float)(x + 2), (float)(y + 2));
        graphics.pose().translate((float)(-this.bounds.getX()), (float)(-this.bounds.getY()));
        this.widget.render(graphics, -1000, -1000, 0.0f);
        AutoCraftingEvaluator.AutoCraftingResult craftingResult = this.autoCraftingResult.get();
        if (craftingResult.hasApplicable && craftingResult.renderer != null) {
            graphics.pose().pushMatrix();
            Rectangle transformedBounds = MatrixUtils.transform(MatrixUtils.inverse((Matrix3x2f)graphics.pose()), new Rectangle(x + 2, y + 2, this.bounds.width, this.bounds.height));
            Point mouse = MatrixUtils.transform((Matrix3x2f)graphics.pose(), PointHelper.ofMouse());
            craftingResult.renderer.render(graphics, mouse.x, mouse.y, Minecraft.getInstance().getDeltaTracker().getRealtimeDeltaTicks(), this.widgets, transformedBounds, this.display.provideInternalDisplay());
            graphics.pose().popMatrix();
        }
        graphics.pose().popMatrix();
    }
}

